/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.accessservices.service;

import java.util.List;
import org.odpi.openmetadata.accessservices.assetcatalog.client.AssetCatalog;
import org.odpi.openmetadata.accessservices.assetcatalog.exception.InvalidParameterException;
import org.odpi.openmetadata.accessservices.assetcatalog.exception.PropertyServerException;
import org.odpi.openmetadata.accessservices.assetcatalog.model.AssetDescription;
import org.odpi.openmetadata.accessservices.assetcatalog.model.Classification;
import org.odpi.openmetadata.accessservices.assetcatalog.model.Relationship;
import org.odpi.openmetadata.accessservices.assetcatalog.model.Term;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AssetCatalogOMASService {
    private final AssetCatalog assetCatalog;
    private static final Logger LOG = LoggerFactory.getLogger(AssetCatalogOMASService.class);

    @Autowired
    public AssetCatalogOMASService(AssetCatalog assetCatalog) {
        this.assetCatalog = assetCatalog;
    }

    public List<Term> searchAssets(String user, String searchCriteria) throws PropertyServerException, InvalidParameterException {
        try {
            return this.assetCatalog.searchForAssets(user, searchCriteria).getAssets();
        }
        catch (InvalidParameterException | PropertyServerException e) {
            LOG.error(String.format("Error retrieving asset details for '%s'", searchCriteria));
            throw e;
        }
    }

    public List<AssetDescription> getAssetSummary(String user, String assetId) throws PropertyServerException, InvalidParameterException {
        try {
            return this.assetCatalog.getAssetSummary(user, assetId).getAssetDescriptionList();
        }
        catch (InvalidParameterException | PropertyServerException e) {
            LOG.error(String.format("Error retrieving asset description for %s", assetId));
            throw e;
        }
    }

    public List<AssetDescription> getAssetDetails(String user, String assetId) throws PropertyServerException, InvalidParameterException {
        try {
            return this.assetCatalog.getAssetDetails(user, assetId).getAssetDescriptionList();
        }
        catch (InvalidParameterException | PropertyServerException e) {
            LOG.error(String.format("Error retrieving asset details for %s", assetId));
            throw e;
        }
    }

    public List<AssetDescription> getAssetUniverse(String user, String assetId) throws PropertyServerException, InvalidParameterException {
        try {
            return this.assetCatalog.getAssetUniverse(user, assetId).getAssetDescriptionList();
        }
        catch (InvalidParameterException | PropertyServerException e) {
            LOG.error(String.format("Error retrieving asset universe for %s", assetId));
            throw e;
        }
    }

    public List<Relationship> getAssetRelationships(String user, String assetId) throws PropertyServerException, InvalidParameterException {
        try {
            return this.assetCatalog.getAssetRelationships(user, assetId).getRelationships();
        }
        catch (InvalidParameterException | PropertyServerException e) {
            LOG.error(String.format("Error retrieving asset relationships for %s", assetId));
            throw e;
        }
    }

    public List<Relationship> getAssetRelationshipsForType(String user, String assetId, String relationshipType) throws PropertyServerException, InvalidParameterException {
        try {
            return this.assetCatalog.getAssetRelationshipsForType(user, assetId, relationshipType).getRelationships();
        }
        catch (InvalidParameterException | PropertyServerException e) {
            LOG.error(String.format("Error retrieving asset relationships for %s and relationship type %s", assetId, relationshipType));
            throw e;
        }
    }

    public List<Classification> getClassificationForAsset(String user, String assetId) throws PropertyServerException, InvalidParameterException {
        try {
            return this.assetCatalog.getClassificationForAsset(user, assetId).getClassifications();
        }
        catch (InvalidParameterException | PropertyServerException e) {
            LOG.error(String.format("Error retrieving asset classifications for %s", assetId));
            throw e;
        }
    }
}

