/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.accessservices.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.odpi.openmetadata.governanceservers.openlineage.client.OpenLineage;
import org.odpi.openmetadata.governanceservers.openlineage.model.GraphName;
import org.odpi.openmetadata.governanceservers.openlineage.model.Scope;
import org.odpi.openmetadata.governanceservers.openlineage.model.View;
import org.odpi.openmetadata.userinterface.accessservices.api.MalformedInputException;
import org.odpi.openmetadata.userinterface.accessservices.beans.Node;
import org.odpi.openmetadata.userinterface.accessservices.service.response.Edge;
import org.odpi.openmetadata.userinterface.accessservices.service.response.Property;
import org.odpi.openmetadata.userinterface.accessservices.service.response.Response;
import org.odpi.openmetadata.userinterface.accessservices.service.response.Vertice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class OpenLineageService {
    public static final String EDGES_LABEL = "edges";
    public static final String NODES_LABEL = "nodes";
    private final OpenLineage openLineageClient;
    private ObjectMapper mapper;
    @Value(value="${open.lineage.graph.source}")
    private GraphName graphName;
    private static final Logger LOG = LoggerFactory.getLogger(OpenLineageService.class);

    @Autowired
    public OpenLineageService(OpenLineage openLineageClient) {
        this.openLineageClient = openLineageClient;
        this.mapper = new ObjectMapper();
    }

    public String generateMockGraph(String userId) {
        return this.openLineageClient.generateMockGraph(userId);
    }

    public Map<String, Object> exportGraph(String userId) {
        String exportedGraph = this.openLineageClient.exportGraph(userId, this.graphName);
        Map graphData = this.processResponse(exportedGraph);
        return graphData;
    }

    public Map<String, Object> getUltimateSource(String userId, View view, String guid) {
        String response = this.openLineageClient.lineage(userId, this.graphName, Scope.ULTIMATE_SOURCE, view, guid);
        Map graphData = this.processResponse(response);
        return graphData;
    }

    public Map<String, Object> getEndToEndLineage(String userId, View view, String guid) {
        String response = this.openLineageClient.lineage(userId, this.graphName, Scope.END_TO_END, view, guid);
        Map graphData = this.processResponse(response);
        return graphData;
    }

    public Map<String, Object> getUltimateDestination(String userId, View view, String guid) {
        String response = this.openLineageClient.lineage(userId, this.graphName, Scope.ULTIMATE_DESTINATION, view, guid);
        Map graphData = this.processResponse(response);
        return graphData;
    }

    public Map<String, Object> getGlossaryLineage(String userId, View view, String guid) {
        String response = this.openLineageClient.lineage(userId, this.graphName, Scope.GLOSSARY, view, guid);
        Map graphData = this.processResponse(response);
        return graphData;
    }

    public Map<String, Object> getSourceAndDestination(String userId, View view, String guid) {
        String response = this.openLineageClient.lineage(userId, this.graphName, Scope.SOURCE_AND_DESTINATION, view, guid);
        Map graphData = this.processResponse(response);
        return graphData;
    }

    private Map<String, Object> processResponse(String response) {
        Response responseObj;
        HashMap<String, Object> graphData = new HashMap<String, Object>();
        ArrayList listEdges = new ArrayList();
        ArrayList listNodes = new ArrayList();
        LOG.debug("Received response from open lineage service: {}", (Object)response);
        if (response == null) {
            graphData.put(EDGES_LABEL, listEdges);
            graphData.put(NODES_LABEL, listNodes);
            return graphData;
        }
        try {
            responseObj = (Response)this.mapper.readValue(response, Response.class);
        }
        catch (IOException e) {
            throw new MalformedInputException("Unable to process response", (Exception)e);
        }
        Optional.ofNullable(responseObj.getVertices()).map(Collection::stream).orElseGet(Stream::empty).forEach(v -> this.addNodeAndEdges(v, listNodes, listEdges));
        graphData.put(EDGES_LABEL, listEdges);
        graphData.put(NODES_LABEL, listNodes);
        return graphData;
    }

    private void addNodeAndEdges(Vertice currentNode, List<Node> listNodes, List<org.odpi.openmetadata.userinterface.accessservices.beans.Edge> listEdges) {
        String labelRoot = currentNode.getLabel();
        String idRoot = String.valueOf(currentNode.getId().getValue());
        Map<String, String> properties = Optional.ofNullable(currentNode.getProperties()).map(e -> e.entrySet().stream()).orElseGet(Stream::empty).map(e -> new AbstractMap.SimpleEntry(e.getKey(), ((Property)((List)e.getValue()).get(0)).getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        String displayName = properties.get("vedisplayName");
        String glossaryTerm = properties.get("veglossaryTerm");
        if (StringUtils.isEmpty((Object)displayName)) {
            displayName = properties.get("displayName");
        }
        if (!StringUtils.isEmpty((Object)glossaryTerm)) {
            displayName = displayName + "\n" + glossaryTerm;
        }
        Node node = new Node(idRoot, displayName);
        node.setGroup(labelRoot);
        node.setProperties(properties);
        listEdges.addAll(Optional.ofNullable(currentNode.getInE()).map(e -> e.entrySet().stream()).orElseGet(Stream::empty).flatMap(e -> this.createEdges(idRoot, (String)e.getKey(), (List)e.getValue()).stream()).collect(Collectors.toList()));
        listNodes.add(node);
    }

    private List<org.odpi.openmetadata.userinterface.accessservices.beans.Edge> createEdges(String idRoot, String key, List<Edge> edges) {
        return Optional.ofNullable(edges).map(Collection::stream).orElseGet(Stream::empty).map(e -> {
            org.odpi.openmetadata.userinterface.accessservices.beans.Edge newEdge = new org.odpi.openmetadata.userinterface.accessservices.beans.Edge(idRoot, String.valueOf(e.getOutV().getValue()));
            newEdge.setLabel(key);
            return newEdge;
        }).collect(Collectors.toList());
    }
}

