/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.actionauthor.server;

import org.odpi.openmetadata.accessservices.governanceprogram.client.ConnectedAssetClient;
import org.odpi.openmetadata.accessservices.governanceprogram.client.ExternalReferenceManager;
import org.odpi.openmetadata.accessservices.governanceprogram.client.OpenGovernanceClient;
import org.odpi.openmetadata.accessservices.governanceprogram.client.OpenIntegrationServiceClient;
import org.odpi.openmetadata.accessservices.governanceprogram.client.OpenMetadataStoreClient;
import org.odpi.openmetadata.adminservices.configuration.registration.ViewServiceDescription;
import org.odpi.openmetadata.commonservices.multitenant.OMVSServiceInstance;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;

public class ActionAuthorInstance
extends OMVSServiceInstance {
    private static final ViewServiceDescription myDescription = ViewServiceDescription.ACTION_AUTHOR;
    private final ExternalReferenceManager externalReferenceManager;
    private final OpenMetadataStoreClient openMetadataStoreClient;
    private final OpenIntegrationServiceClient openIntegrationServiceClient;
    private final ConnectedAssetClient connectedAssetClient;
    private final OpenGovernanceClient openGovernanceClient;

    public ActionAuthorInstance(String serverName, AuditLog auditLog, String localServerUserId, int maxPageSize, String remoteServerName, String remoteServerURL) throws InvalidParameterException {
        super(serverName, myDescription.getViewServiceName(), auditLog, localServerUserId, maxPageSize, remoteServerName, remoteServerURL);
        this.externalReferenceManager = new ExternalReferenceManager(remoteServerName, remoteServerURL);
        this.connectedAssetClient = new ConnectedAssetClient(remoteServerName, remoteServerURL);
        this.openMetadataStoreClient = new OpenMetadataStoreClient(remoteServerName, remoteServerURL, maxPageSize);
        this.openIntegrationServiceClient = new OpenIntegrationServiceClient(remoteServerName, remoteServerURL, maxPageSize);
        this.openGovernanceClient = new OpenGovernanceClient(remoteServerName, remoteServerURL, maxPageSize);
    }

    public ExternalReferenceManager getExternalReferenceManager() {
        return this.externalReferenceManager;
    }

    public ConnectedAssetClient getConnectedAssetClient() {
        return this.connectedAssetClient;
    }

    public OpenMetadataStoreClient getOpenMetadataStoreClient() {
        return this.openMetadataStoreClient;
    }

    public OpenGovernanceClient getOpenGovernanceClient() {
        return this.openGovernanceClient;
    }

    public OpenIntegrationServiceClient getOpenIntegrationServiceClient() {
        return this.openIntegrationServiceClient;
    }
}

