/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.actionauthor.server;

import java.util.Date;
import org.odpi.openmetadata.accessservices.governanceprogram.client.OpenGovernanceClient;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FilterRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ResultsRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionProcessProperties;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionProcessStepProperties;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionTypeProperties;
import org.odpi.openmetadata.frameworkservices.gaf.rest.FirstGovernanceActionProcessStepResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionProcessElementResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionProcessElementsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionProcessGraphResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionProcessStepResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionProcessStepsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionTypeResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionTypesResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.NewGovernanceActionProcessRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.NextGovernanceActionProcessStepRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.NextGovernanceActionProcessStepsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateGovernanceActionProcessRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateGovernanceActionProcessStepRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateGovernanceActionTypeRequestBody;
import org.odpi.openmetadata.tokencontroller.TokenController;
import org.odpi.openmetadata.viewservices.actionauthor.server.ActionAuthorInstanceHandler;
import org.slf4j.LoggerFactory;

public class ActionAuthorRESTServices
extends TokenController {
    private static final ActionAuthorInstanceHandler instanceHandler = new ActionAuthorInstanceHandler();
    private static final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(ActionAuthorRESTServices.class), instanceHandler.getServiceName());
    private final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();

    public GUIDResponse createGovernanceActionType(String serverName, GovernanceActionTypeProperties requestBody) {
        String methodName = "createGovernanceActionType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "createGovernanceActionType");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "createGovernanceActionType");
            restCallLogger.setUserId(token, userId);
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "createGovernanceActionType");
                OpenGovernanceClient handler = instanceHandler.getOpenGovernanceClient(userId, serverName, "createGovernanceActionType");
                response.setGUID(handler.createGovernanceActionType(userId, requestBody));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createGovernanceActionType", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createGovernanceActionType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateGovernanceActionType(String serverName, String governanceActionTypeGUID, UpdateGovernanceActionTypeRequestBody requestBody) {
        String methodName = "updateGovernanceActionType";
        String propertiesParameterName = "requestBody.getProperties";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "updateGovernanceActionType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "updateGovernanceActionType");
            restCallLogger.setUserId(token, userId);
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "updateGovernanceActionType");
                OpenGovernanceClient handler = instanceHandler.getOpenGovernanceClient(userId, serverName, "updateGovernanceActionType");
                GovernanceActionTypeProperties properties = requestBody.getProperties();
                this.invalidParameterHandler.validateObject((Object)properties, "requestBody.getProperties", "updateGovernanceActionType");
                handler.updateGovernanceActionType(userId, governanceActionTypeGUID, requestBody.getMergeUpdate(), properties);
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateGovernanceActionType", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateGovernanceActionType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeGovernanceActionType(String serverName, String governanceActionTypeGUID, NullRequestBody requestBody) {
        String methodName = "removeGovernanceActionType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "removeGovernanceActionType");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "removeGovernanceActionType");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeGovernanceActionType");
            OpenGovernanceClient handler = instanceHandler.getOpenGovernanceClient(userId, serverName, "removeGovernanceActionType");
            handler.removeGovernanceActionType(userId, governanceActionTypeGUID);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeGovernanceActionType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionTypesResponse findGovernanceActionTypes(String serverName, boolean startsWith, boolean endsWith, boolean ignoreCase, int startFrom, int pageSize, FilterRequestBody requestBody) {
        String methodName = "findGovernanceActionTypes";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "findGovernanceActionTypes");
        GovernanceActionTypesResponse response = new GovernanceActionTypesResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "findGovernanceActionTypes");
            restCallLogger.setUserId(token, userId);
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "findGovernanceActionTypes");
                OpenGovernanceClient handler = instanceHandler.getOpenGovernanceClient(userId, serverName, "findGovernanceActionTypes");
                response.setElements(handler.findGovernanceActionTypes(userId, instanceHandler.getSearchString(requestBody.getFilter(), startsWith, endsWith, ignoreCase), startFrom, pageSize, requestBody.getEffectiveTime()));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "findGovernanceActionTypes", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findGovernanceActionTypes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionTypesResponse getGovernanceActionTypesByName(String serverName, int startFrom, int pageSize, FilterRequestBody requestBody) {
        String methodName = "getGovernanceActionTypesByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getGovernanceActionTypesByName");
        GovernanceActionTypesResponse response = new GovernanceActionTypesResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getGovernanceActionTypesByName");
            restCallLogger.setUserId(token, userId);
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceActionTypesByName");
                OpenGovernanceClient handler = instanceHandler.getOpenGovernanceClient(userId, serverName, "getGovernanceActionTypesByName");
                response.setElements(handler.getGovernanceActionTypesByName(userId, requestBody.getFilter(), startFrom, pageSize, requestBody.getEffectiveTime()));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getGovernanceActionTypesByName", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceActionTypesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionTypeResponse getGovernanceActionTypeByGUID(String serverName, String governanceActionTypeGUID) {
        String methodName = "getGovernanceActionTypeByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getGovernanceActionTypeByGUID");
        GovernanceActionTypeResponse response = new GovernanceActionTypeResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getGovernanceActionTypeByGUID");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceActionTypeByGUID");
            OpenGovernanceClient handler = instanceHandler.getOpenGovernanceClient(userId, serverName, "getGovernanceActionTypeByGUID");
            response.setElement(handler.getGovernanceActionTypeByGUID(userId, governanceActionTypeGUID));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceActionTypeByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createGovernanceActionProcess(String serverName, NewGovernanceActionProcessRequestBody requestBody) {
        String methodName = "createGovernanceActionProcess";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "createGovernanceActionProcess");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "createGovernanceActionProcess");
            restCallLogger.setUserId(token, userId);
            if (requestBody != null && requestBody.getProperties() != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "createGovernanceActionProcess");
                OpenGovernanceClient handler = instanceHandler.getOpenGovernanceClient(userId, serverName, "createGovernanceActionProcess");
                GovernanceActionProcessProperties processProperties = requestBody.getProperties();
                response.setGUID(handler.createGovernanceActionProcess(userId, processProperties, requestBody.getProcessStatus()));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createGovernanceActionProcess", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createGovernanceActionProcess", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateGovernanceActionProcess(String serverName, String processGUID, UpdateGovernanceActionProcessRequestBody requestBody) {
        String methodName = "updateGovernanceActionProcess";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "updateGovernanceActionProcess");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "updateGovernanceActionProcess");
            restCallLogger.setUserId(token, userId);
            if (requestBody != null && requestBody.getProperties() != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "updateGovernanceActionProcess");
                OpenGovernanceClient handler = instanceHandler.getOpenGovernanceClient(userId, serverName, "updateGovernanceActionProcess");
                handler.updateGovernanceActionProcess(userId, processGUID, requestBody.getMergeUpdate(), requestBody.getProcessStatus(), requestBody.getProperties());
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateGovernanceActionProcess", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateGovernanceActionProcess", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse publishGovernanceActionProcess(String serverName, String processGUID, NullRequestBody requestBody) {
        String methodName = "publishGovernanceActionProcess";
        String processGUIDParameterName = "processGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "publishGovernanceActionProcess");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "publishGovernanceActionProcess");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "publishGovernanceActionProcess");
            OpenGovernanceClient handler = instanceHandler.getOpenGovernanceClient(userId, serverName, "publishGovernanceActionProcess");
            handler.publishGovernanceActionProcess(userId, processGUID);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "publishGovernanceActionProcess", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse withdrawGovernanceActionProcess(String serverName, String processGUID, NullRequestBody requestBody) {
        String methodName = "withdrawGovernanceActionProcess";
        String processGUIDParameterName = "processGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "withdrawGovernanceActionProcess");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "withdrawGovernanceActionProcess");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "withdrawGovernanceActionProcess");
            OpenGovernanceClient handler = instanceHandler.getOpenGovernanceClient(userId, serverName, "withdrawGovernanceActionProcess");
            handler.withdrawGovernanceActionProcess(userId, processGUID);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "withdrawGovernanceActionProcess", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeGovernanceActionProcess(String serverName, String processGUID, NullRequestBody requestBody) {
        String methodName = "removeGovernanceActionProcess";
        String processGUIDParameterName = "processGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "removeGovernanceActionProcess");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "removeGovernanceActionProcess");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeGovernanceActionProcess");
            OpenGovernanceClient handler = instanceHandler.getOpenGovernanceClient(userId, serverName, "removeGovernanceActionProcess");
            handler.removeGovernanceActionProcess(userId, processGUID);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeGovernanceActionProcess", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionProcessElementsResponse findGovernanceActionProcesses(String serverName, boolean startsWith, boolean endsWith, boolean ignoreCase, int startFrom, int pageSize, FilterRequestBody requestBody) {
        String methodName = "findGovernanceActionProcesses";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "findGovernanceActionProcesses");
        GovernanceActionProcessElementsResponse response = new GovernanceActionProcessElementsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "findGovernanceActionProcesses");
            restCallLogger.setUserId(token, userId);
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "findGovernanceActionProcesses");
                OpenGovernanceClient handler = instanceHandler.getOpenGovernanceClient(userId, serverName, "findGovernanceActionProcesses");
                response.setElements(handler.getGovernanceActionProcessesByName(userId, instanceHandler.getSearchString(requestBody.getFilter(), startsWith, endsWith, ignoreCase), startFrom, pageSize, requestBody.getEffectiveTime()));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "findGovernanceActionProcesses", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findGovernanceActionProcesses", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionProcessElementsResponse getGovernanceActionProcessesByName(String serverName, int startFrom, int pageSize, FilterRequestBody requestBody) {
        String methodName = "getGovernanceActionProcessesByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getGovernanceActionProcessesByName");
        GovernanceActionProcessElementsResponse response = new GovernanceActionProcessElementsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getGovernanceActionProcessesByName");
            restCallLogger.setUserId(token, userId);
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceActionProcessesByName");
                OpenGovernanceClient handler = instanceHandler.getOpenGovernanceClient(userId, serverName, "getGovernanceActionProcessesByName");
                response.setElements(handler.getGovernanceActionProcessesByName(userId, requestBody.getFilter(), startFrom, pageSize, requestBody.getEffectiveTime()));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getGovernanceActionProcessesByName", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceActionProcessesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionProcessElementResponse getGovernanceActionProcessByGUID(String serverName, String processGUID) {
        String methodName = "getGovernanceActionProcessByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getGovernanceActionProcessByGUID");
        GovernanceActionProcessElementResponse response = new GovernanceActionProcessElementResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getGovernanceActionProcessByGUID");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceActionProcessByGUID");
            OpenGovernanceClient handler = instanceHandler.getOpenGovernanceClient(userId, serverName, "getGovernanceActionProcessByGUID");
            response.setElement(handler.getGovernanceActionProcessByGUID(userId, processGUID));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceActionProcessByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionProcessGraphResponse getGovernanceActionProcessGraph(String serverName, String processGUID, ResultsRequestBody requestBody) {
        String methodName = "getGovernanceActionProcessGraph";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getGovernanceActionProcessGraph");
        GovernanceActionProcessGraphResponse response = new GovernanceActionProcessGraphResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getGovernanceActionProcessGraph");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceActionProcessGraph");
            OpenGovernanceClient handler = instanceHandler.getOpenGovernanceClient(userId, serverName, "getGovernanceActionProcessGraph");
            if (requestBody != null) {
                response.setElement(handler.getGovernanceActionProcessGraph(userId, processGUID, requestBody.getEffectiveTime()));
            } else {
                response.setElement(handler.getGovernanceActionProcessGraph(userId, processGUID, new Date()));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceActionProcessGraph", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createGovernanceActionProcessStep(String serverName, GovernanceActionProcessStepProperties requestBody) {
        String methodName = "createGovernanceActionProcessStep";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "createGovernanceActionProcessStep");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "createGovernanceActionProcessStep");
            restCallLogger.setUserId(token, userId);
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "createGovernanceActionProcessStep");
                OpenGovernanceClient handler = instanceHandler.getOpenGovernanceClient(userId, serverName, "createGovernanceActionProcessStep");
                response.setGUID(handler.createGovernanceActionProcessStep(userId, requestBody));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createGovernanceActionProcessStep", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createGovernanceActionProcessStep", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateGovernanceActionProcessStep(String serverName, String processStepGUID, UpdateGovernanceActionProcessStepRequestBody requestBody) {
        String methodName = "updateGovernanceActionProcessStep";
        String propertiesParameterName = "requestBody.getProperties";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "updateGovernanceActionProcessStep");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "updateGovernanceActionProcessStep");
            restCallLogger.setUserId(token, userId);
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "updateGovernanceActionProcessStep");
                OpenGovernanceClient handler = instanceHandler.getOpenGovernanceClient(userId, serverName, "updateGovernanceActionProcessStep");
                this.invalidParameterHandler.validateObject((Object)requestBody.getProperties(), "requestBody.getProperties", "updateGovernanceActionProcessStep");
                handler.updateGovernanceActionProcessStep(userId, processStepGUID, requestBody.getMergeUpdate(), requestBody.getProperties());
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateGovernanceActionProcessStep", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateGovernanceActionProcessStep", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeGovernanceActionProcessStep(String serverName, String processStepGUID, NullRequestBody requestBody) {
        String methodName = "removeGovernanceActionProcessStep";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "removeGovernanceActionProcessStep");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "removeGovernanceActionProcessStep");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeGovernanceActionProcessStep");
            OpenGovernanceClient handler = instanceHandler.getOpenGovernanceClient(userId, serverName, "removeGovernanceActionProcessStep");
            handler.removeGovernanceActionProcessStep(userId, processStepGUID);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeGovernanceActionProcessStep", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionProcessStepsResponse findGovernanceActionProcessSteps(String serverName, boolean startsWith, boolean endsWith, boolean ignoreCase, int startFrom, int pageSize, FilterRequestBody requestBody) {
        String methodName = "findGovernanceActionProcessSteps";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "findGovernanceActionProcessSteps");
        GovernanceActionProcessStepsResponse response = new GovernanceActionProcessStepsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "findGovernanceActionProcessSteps");
            restCallLogger.setUserId(token, userId);
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "findGovernanceActionProcessSteps");
                OpenGovernanceClient handler = instanceHandler.getOpenGovernanceClient(userId, serverName, "findGovernanceActionProcessSteps");
                response.setElements(handler.findGovernanceActionProcessSteps(userId, instanceHandler.getSearchString(requestBody.getFilter(), startsWith, endsWith, ignoreCase), startFrom, pageSize, requestBody.getEffectiveTime()));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "findGovernanceActionProcessSteps", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findGovernanceActionProcessSteps", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionProcessStepsResponse getGovernanceActionProcessStepsByName(String serverName, int startFrom, int pageSize, FilterRequestBody requestBody) {
        String methodName = "getGovernanceActionProcessStepsByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getGovernanceActionProcessStepsByName");
        GovernanceActionProcessStepsResponse response = new GovernanceActionProcessStepsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getGovernanceActionProcessStepsByName");
            restCallLogger.setUserId(token, userId);
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceActionProcessStepsByName");
                OpenGovernanceClient handler = instanceHandler.getOpenGovernanceClient(userId, serverName, "getGovernanceActionProcessStepsByName");
                response.setElements(handler.getGovernanceActionProcessStepsByName(userId, requestBody.getFilter(), startFrom, pageSize, requestBody.getEffectiveTime()));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getGovernanceActionProcessStepsByName", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceActionProcessStepsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceActionProcessStepResponse getGovernanceActionProcessStepByGUID(String serverName, String processStepGUID) {
        String methodName = "getGovernanceActionProcessStepByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getGovernanceActionProcessStepByGUID");
        GovernanceActionProcessStepResponse response = new GovernanceActionProcessStepResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getGovernanceActionProcessStepByGUID");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernanceActionProcessStepByGUID");
            OpenGovernanceClient handler = instanceHandler.getOpenGovernanceClient(userId, serverName, "getGovernanceActionProcessStepByGUID");
            response.setElement(handler.getGovernanceActionProcessStepByGUID(userId, processStepGUID));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernanceActionProcessStepByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupFirstActionProcessStep(String serverName, String processGUID, String processStepGUID, FilterRequestBody requestBody) {
        String methodName = "setupFirstActionProcessStep";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "setupFirstActionProcessStep");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "setupFirstActionProcessStep");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupFirstActionProcessStep");
            OpenGovernanceClient handler = instanceHandler.getOpenGovernanceClient(userId, serverName, "setupFirstActionProcessStep");
            if (requestBody != null) {
                handler.setupFirstActionProcessStep(userId, processGUID, processStepGUID, requestBody.getFilter());
            } else {
                handler.setupFirstActionProcessStep(userId, processGUID, processStepGUID, null);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupFirstActionProcessStep", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public FirstGovernanceActionProcessStepResponse getFirstActionProcessStep(String serverName, String processGUID) {
        String methodName = "getFirstActionProcessStep";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getFirstActionProcessStep");
        FirstGovernanceActionProcessStepResponse response = new FirstGovernanceActionProcessStepResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getFirstActionProcessStep");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getFirstActionProcessStep");
            OpenGovernanceClient handler = instanceHandler.getOpenGovernanceClient(userId, serverName, "getFirstActionProcessStep");
            response.setElement(handler.getFirstActionProcessStep(userId, processGUID));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getFirstActionProcessStep", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeFirstProcessStep(String serverName, String processGUID, NullRequestBody requestBody) {
        String methodName = "removeFirstActionProcessStep";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "removeFirstActionProcessStep");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "removeFirstActionProcessStep");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeFirstActionProcessStep");
            OpenGovernanceClient handler = instanceHandler.getOpenGovernanceClient(userId, serverName, "removeFirstActionProcessStep");
            handler.removeFirstActionProcessStep(userId, processGUID);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeFirstActionProcessStep", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse setupNextActionProcessStep(String serverName, String currentProcessStepGUID, String nextProcessStepGUID, NextGovernanceActionProcessStepRequestBody requestBody) {
        String methodName = "setupNextActionProcessStep";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "setupNextActionProcessStep");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "setupNextActionProcessStep");
            restCallLogger.setUserId(token, userId);
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "setupNextActionProcessStep");
                OpenGovernanceClient handler = instanceHandler.getOpenGovernanceClient(userId, serverName, "setupNextActionProcessStep");
                response.setGUID(handler.setupNextActionProcessStep(userId, currentProcessStepGUID, nextProcessStepGUID, requestBody.getGuard(), requestBody.getMandatoryGuard()));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupNextActionProcessStep", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupNextActionProcessStep", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateNextActionProcessStep(String serverName, String nextProcessStepLinkGUID, NextGovernanceActionProcessStepRequestBody requestBody) {
        String methodName = "updateNextActionProcessStep";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "updateNextActionProcessStep");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "updateNextActionProcessStep");
            restCallLogger.setUserId(token, userId);
            if (requestBody != null) {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "updateNextActionProcessStep");
                OpenGovernanceClient handler = instanceHandler.getOpenGovernanceClient(userId, serverName, "updateNextActionProcessStep");
                handler.updateNextActionProcessStep(userId, nextProcessStepLinkGUID, requestBody.getGuard(), requestBody.getMandatoryGuard());
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateNextActionProcessStep", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateNextActionProcessStep", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public NextGovernanceActionProcessStepsResponse getNextProcessSteps(String serverName, String processStepGUID, int startFrom, int pageSize) {
        String methodName = "getNextGovernanceActionProcessSteps";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getNextGovernanceActionProcessSteps");
        NextGovernanceActionProcessStepsResponse response = new NextGovernanceActionProcessStepsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getNextGovernanceActionProcessSteps");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getNextGovernanceActionProcessSteps");
            OpenGovernanceClient handler = instanceHandler.getOpenGovernanceClient(userId, serverName, "getNextGovernanceActionProcessSteps");
            response.setElements(handler.getNextGovernanceActionProcessSteps(userId, processStepGUID, startFrom, pageSize));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getNextGovernanceActionProcessSteps", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeNextActionProcessStep(String serverName, String actionLinkGUID, NullRequestBody requestBody) {
        String methodName = "removeNextActionProcessStep";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "removeNextActionProcessStep");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "removeNextActionProcessStep");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeNextActionProcessStep");
            OpenGovernanceClient handler = instanceHandler.getOpenGovernanceClient(userId, serverName, "removeNextActionProcessStep");
            handler.removeNextActionProcessStep(userId, actionLinkGUID);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeNextActionProcessStep", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

