/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.actionauthor.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.commonservices.ffdc.rest.EffectiveTimeRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.FilterRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionProcessStepProperties;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionTypeProperties;
import org.odpi.openmetadata.frameworkservices.gaf.rest.FirstGovernanceActionProcessStepResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionProcessElementResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionProcessElementsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionProcessGraphResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionProcessStepResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionProcessStepsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionTypeResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.GovernanceActionTypesResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.NewGovernanceActionProcessRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.NextGovernanceActionProcessStepRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.NextGovernanceActionProcessStepsResponse;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateGovernanceActionProcessRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateGovernanceActionProcessStepRequestBody;
import org.odpi.openmetadata.frameworkservices.gaf.rest.UpdateGovernanceActionTypeRequestBody;
import org.odpi.openmetadata.viewservices.actionauthor.server.ActionAuthorRESTServices;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/api/open-metadata/action-author"})
@Tag(name="API: Action Author OMVS", description="Set up and maintain governance actions such as governance action processes and governance action types.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omvs/action-author/overview/"))
public class ActionAuthorResource {
    private final ActionAuthorRESTServices restAPI = new ActionAuthorRESTServices();

    @PostMapping(path={"/governance-action-types"})
    @Operation(summary="createGovernanceActionType", description="Create a new metadata element to represent a governance action type.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-type"))
    public GUIDResponse createGovernanceActionType(@PathVariable String serverName, @RequestBody GovernanceActionTypeProperties requestBody) {
        return this.restAPI.createGovernanceActionType(serverName, requestBody);
    }

    @PostMapping(path={"/governance-action-types/{governanceActionTypeGUID}/update"})
    @Operation(summary="updateGovernanceActionType", description="Create a new metadata element to represent a governance action type.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-type"))
    public VoidResponse updateGovernanceActionType(@PathVariable String serverName, @PathVariable String governanceActionTypeGUID, @RequestBody UpdateGovernanceActionTypeRequestBody requestBody) {
        return this.restAPI.updateGovernanceActionType(serverName, governanceActionTypeGUID, requestBody);
    }

    @PostMapping(path={"/governance-action-types/{governanceActionTypeGUID}/remove"})
    @Operation(summary="removeGovernanceActionType", description="Remove the metadata element representing a governance action type.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-type"))
    public VoidResponse removeGovernanceActionType(@PathVariable String serverName, @PathVariable String governanceActionTypeGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeGovernanceActionType(serverName, governanceActionTypeGUID, requestBody);
    }

    @PostMapping(path={"/governance-action-types/by-search-string"})
    @Operation(summary="findGovernanceActionTypes", description="Retrieve the list of governance action type metadata elements that contain the search string.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-type"))
    public GovernanceActionTypesResponse findGovernanceActionTypes(@PathVariable String serverName, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean startsWith, @RequestParam(required=false, defaultValue="false") boolean endsWith, @RequestParam(required=false, defaultValue="false") boolean ignoreCase, @RequestBody FilterRequestBody requestBody) {
        return this.restAPI.findGovernanceActionTypes(serverName, startsWith, endsWith, ignoreCase, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/governance-action-types/by-name"})
    @Operation(summary="getGovernanceActionTypesByName", description="Retrieve the list of governance action type metadata elements with a matching qualified or display name. There are no wildcards supported on this request.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-type"))
    public GovernanceActionTypesResponse getGovernanceActionTypesByName(@PathVariable String serverName, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody FilterRequestBody requestBody) {
        return this.restAPI.getGovernanceActionTypesByName(serverName, startFrom, pageSize, requestBody);
    }

    @GetMapping(path={"/governance-action-types/{governanceActionTypeGUID}"})
    @Operation(summary="getGovernanceActionTypeByGUID", description="Retrieve the governance action type metadata element with the supplied unique identifier.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-type"))
    public GovernanceActionTypeResponse getGovernanceActionTypeByGUID(@PathVariable String serverName, @PathVariable String governanceActionTypeGUID) {
        return this.restAPI.getGovernanceActionTypeByGUID(serverName, governanceActionTypeGUID);
    }

    @PostMapping(path={"/governance-action-processes"})
    @Operation(summary="createGovernanceActionProcess", description="Create a new metadata element to represent a governance action process.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public GUIDResponse createGovernanceActionProcess(@PathVariable String serverName, @RequestBody NewGovernanceActionProcessRequestBody requestBody) {
        return this.restAPI.createGovernanceActionProcess(serverName, requestBody);
    }

    @PostMapping(path={"/governance-action-processes/{processGUID}/update"})
    @Operation(summary="updateGovernanceActionProcess", description="Update the metadata element representing a governance action process.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public VoidResponse updateGovernanceActionProcess(@PathVariable String serverName, @PathVariable String processGUID, @RequestBody UpdateGovernanceActionProcessRequestBody requestBody) {
        return this.restAPI.updateGovernanceActionProcess(serverName, processGUID, requestBody);
    }

    @PostMapping(path={"/governance-action-processes/{processGUID}/publish"})
    @Operation(summary="publishGovernanceActionProcess", description="Update the zones for the governance action process (asset) so that it becomes visible to consumers. (The zones are set to the list of zones in the publishedZones option configured for each instance of an Open Metadata Access Service (OMAS)).", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-zone"))
    public VoidResponse publishGovernanceActionProcess(@PathVariable String serverName, @PathVariable String processGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.publishGovernanceActionProcess(serverName, processGUID, requestBody);
    }

    @PostMapping(path={"/governance-action-processes/{processGUID}/withdraw"})
    @Operation(summary="withdrawGovernanceActionProcess", description="Update the zones for the governance action process (asset) so that it is no longer visible to consumers. (The zones are set to the list of zones in the defaultZones option configured for each instance of an Open Metadata Access Service (OMAS). This is also the setting for the zones when the process is first created.)", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-zone"))
    public VoidResponse withdrawGovernanceActionProcess(@PathVariable String serverName, @PathVariable String processGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.withdrawGovernanceActionProcess(serverName, processGUID, requestBody);
    }

    @PostMapping(path={"/governance-action-processes/{processGUID}/remove"})
    @Operation(summary="removeGovernanceActionProcess", description="Remove the metadata element representing a governance action process.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public VoidResponse removeGovernanceActionProcess(@PathVariable String serverName, @PathVariable String processGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeGovernanceActionProcess(serverName, processGUID, requestBody);
    }

    @PostMapping(path={"/governance-action-processes/by-search-string"})
    @Operation(summary="findGovernanceActionProcesses", description="Retrieve the list of governance action process metadata elements that contain the search string.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public GovernanceActionProcessElementsResponse findGovernanceActionProcesses(@PathVariable String serverName, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean startsWith, @RequestParam(required=false, defaultValue="false") boolean endsWith, @RequestParam(required=false, defaultValue="false") boolean ignoreCase, @RequestBody FilterRequestBody requestBody) {
        return this.restAPI.findGovernanceActionProcesses(serverName, startsWith, endsWith, ignoreCase, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/governance-action-processes/by-name"})
    @Operation(summary="getGovernanceActionProcessesByName", description="Retrieve the list of governance action process metadata elements with a matching qualified or display name. There are no wildcards supported on this request.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public GovernanceActionProcessElementsResponse getGovernanceActionProcessesByName(@PathVariable String serverName, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody FilterRequestBody requestBody) {
        return this.restAPI.getGovernanceActionProcessesByName(serverName, startFrom, pageSize, requestBody);
    }

    @GetMapping(path={"/governance-action-processes/{processGUID}"})
    @Operation(summary="getGovernanceActionProcessByGUID", description="Retrieve the governance action process metadata element with the supplied unique identifier.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public GovernanceActionProcessElementResponse getGovernanceActionProcessByGUID(@PathVariable String serverName, @PathVariable String processGUID) {
        return this.restAPI.getGovernanceActionProcessByGUID(serverName, processGUID);
    }

    @PostMapping(path={"/governance-action-processes/{processGUID}/graph"})
    @Operation(summary="getGovernanceActionProcessGraph", description="Retrieve the governance action process metadata element with the supplied unique identifier along with the flow definition describing its implementation.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public GovernanceActionProcessGraphResponse getGovernanceActionProcessGraph(@PathVariable String serverName, @PathVariable String processGUID, @RequestBody(required=false) EffectiveTimeRequestBody requestBody) {
        return this.restAPI.getGovernanceActionProcessGraph(serverName, processGUID, requestBody);
    }

    @PostMapping(path={"/governance-action-process-steps"})
    @Operation(summary="createGovernanceActionProcessStep", description="Create a new metadata element to represent a governance action process step.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public GUIDResponse createGovernanceActionProcessStep(@PathVariable String serverName, @RequestBody GovernanceActionProcessStepProperties requestBody) {
        return this.restAPI.createGovernanceActionProcessStep(serverName, requestBody);
    }

    @PostMapping(path={"/governance-action-process-steps/{governanceActionTypeGUID}/update"})
    @Operation(summary="updateGovernanceActionProcessStep", description="Create a new metadata element to represent a governance action process step.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public VoidResponse updateGovernanceActionProcessStep(@PathVariable String serverName, @PathVariable String governanceActionTypeGUID, @RequestBody UpdateGovernanceActionProcessStepRequestBody requestBody) {
        return this.restAPI.updateGovernanceActionProcessStep(serverName, governanceActionTypeGUID, requestBody);
    }

    @PostMapping(path={"/governance-action-process-steps/{processStepGUID}/remove"})
    @Operation(summary="removeGovernanceActionProcessStep", description="Remove the metadata element representing a governance action process step.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public VoidResponse removeGovernanceActionProcessStep(@PathVariable String serverName, @PathVariable String processStepGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeGovernanceActionProcessStep(serverName, processStepGUID, requestBody);
    }

    @PostMapping(path={"/governance-action-process-steps/by-search-string"})
    @Operation(summary="findGovernanceActionProcessSteps", description="Retrieve the list of governance action process step metadata elements that contain the search string.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public GovernanceActionProcessStepsResponse findGovernanceActionProcessSteps(@PathVariable String serverName, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean startsWith, @RequestParam(required=false, defaultValue="false") boolean endsWith, @RequestParam(required=false, defaultValue="false") boolean ignoreCase, @RequestBody FilterRequestBody requestBody) {
        return this.restAPI.findGovernanceActionProcessSteps(serverName, startsWith, endsWith, ignoreCase, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/governance-action-process-steps/by-name"})
    @Operation(summary="getGovernanceActionProcessStepsByName", description="Retrieve the list of governance action process step metadata elements with a matching qualified or display name. There are no wildcards supported on this request.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public GovernanceActionProcessStepsResponse getGovernanceActionProcessStepsByName(@PathVariable String serverName, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody FilterRequestBody requestBody) {
        return this.restAPI.getGovernanceActionProcessStepsByName(serverName, startFrom, pageSize, requestBody);
    }

    @GetMapping(path={"/governance-action-process-steps/{processStepGUID}"})
    @Operation(summary="getGovernanceActionProcessStepByGUID", description="Retrieve the governance action process step metadata element with the supplied unique identifier.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public GovernanceActionProcessStepResponse getGovernanceActionProcessStepByGUID(@PathVariable String serverName, @PathVariable String processStepGUID) {
        return this.restAPI.getGovernanceActionProcessStepByGUID(serverName, processStepGUID);
    }

    @PostMapping(path={"/governance-action-processes/{processGUID}/first-process-step/{processStepGUID}"})
    @Operation(summary="setupFirstActionProcessStep", description="Set up a link between a governance action process and a governance action process step.  This defines the first step in the process.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public VoidResponse setupFirstActionProcessStep(@PathVariable String serverName, @PathVariable String processGUID, @PathVariable String processStepGUID, @RequestBody(required=false) FilterRequestBody requestBody) {
        return this.restAPI.setupFirstActionProcessStep(serverName, processGUID, processStepGUID, requestBody);
    }

    @GetMapping(path={"/governance-action-processes/{processGUID}/first-process-step"})
    @Operation(summary="getFirstActionProcessStep", description="Return the governance action process step that is the first step in a governance action process.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public FirstGovernanceActionProcessStepResponse getFirstActionProcessStep(@PathVariable String serverName, @PathVariable String processGUID) {
        return this.restAPI.getFirstActionProcessStep(serverName, processGUID);
    }

    @PostMapping(path={"/governance-action-processes/{processGUID}/first-process-step/remove"})
    @Operation(summary="removeFirstActionProcessStep", description="Remove the link between a governance process and that governance action process step that defines its first step.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public VoidResponse removeFirstProcessStep(@PathVariable String serverName, @PathVariable String processGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeFirstProcessStep(serverName, processGUID, requestBody);
    }

    @PostMapping(path={"/governance-action-process-steps/{currentProcessStepGUID}/next-process-steps/{nextProcessStepGUID}"})
    @Operation(summary="removeFirstActionProcessStep", description="Remove the link between a governance process and that governance action process step that defines its first step.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public GUIDResponse setupNextActionProcessStep(@PathVariable String serverName, @PathVariable String currentProcessStepGUID, @PathVariable String nextProcessStepGUID, @RequestBody NextGovernanceActionProcessStepRequestBody requestBody) {
        return this.restAPI.setupNextActionProcessStep(serverName, currentProcessStepGUID, nextProcessStepGUID, requestBody);
    }

    @PostMapping(path={"/governance-action-process-steps/next-process-steps/{nextProcessStepLinkGUID}/update"})
    @Operation(summary="updateNextActionProcessStep", description="Update the properties of the link between two governance action process steps that shows that one follows on from the other when a governance action process is executing.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public VoidResponse updateNextActionProcessStep(@PathVariable String serverName, @PathVariable String nextProcessStepLinkGUID, @RequestBody NextGovernanceActionProcessStepRequestBody requestBody) {
        return this.restAPI.updateNextActionProcessStep(serverName, nextProcessStepLinkGUID, requestBody);
    }

    @GetMapping(path={"/governance-action-process-steps/{processStepGUID}/next-process-steps"})
    @Operation(summary="getNextProcessSteps", description="Return the list of next process steps defined for the governance action process.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public NextGovernanceActionProcessStepsResponse getNextProcessSteps(@PathVariable String serverName, @PathVariable String processStepGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getNextProcessSteps(serverName, processStepGUID, startFrom, pageSize);
    }

    @PostMapping(path={"/governance-action-process-steps/next-process-step/{relationshipGUID}/remove"})
    @Operation(summary="removeNextActionProcessStep", description="Remove a follow-on step from a governance action process.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-action-process"))
    public VoidResponse removeNextActionProcessStep(@PathVariable String serverName, @PathVariable String relationshipGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeNextActionProcessStep(serverName, relationshipGUID, requestBody);
    }
}

