/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.configuration.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.List;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.EventBusConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.RepositoryServicesConfig;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class OMAGServerConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String defaultLocalServerType = "Open Metadata and Governance Server";
    private static final String defaultLocalOrganizationName = null;
    private static final String defaultLocalServerURL = "http://localhost:8080";
    private static final String defaultLocalServerUserId = "OMAGServer";
    private static final int defaultMaxPageSize = 1000;
    private String localServerName = null;
    private String localServerType = "Open Metadata and Governance Server";
    private String organizationName = defaultLocalOrganizationName;
    private String localServerURL = "http://localhost:8080";
    private String localServerUserId = "OMAGServer";
    private int maxPageSize = 1000;
    private EventBusConfig eventBusConfig = null;
    private List<AccessServiceConfig> accessServicesConfig = null;
    private RepositoryServicesConfig repositoryServicesConfig = null;

    public OMAGServerConfig() {
    }

    public OMAGServerConfig(OMAGServerConfig template) {
        this.localServerName = template.getLocalServerName();
        this.localServerType = template.getLocalServerType();
        this.localServerURL = template.getLocalServerURL();
        this.organizationName = template.getOrganizationName();
        this.maxPageSize = template.getMaxPageSize();
        this.accessServicesConfig = template.getAccessServicesConfig();
        this.repositoryServicesConfig = template.getRepositoryServicesConfig();
    }

    public String getLocalServerName() {
        return this.localServerName;
    }

    public void setLocalServerName(String localServerName) {
        this.localServerName = localServerName;
    }

    public String getLocalServerType() {
        return this.localServerType;
    }

    public void setLocalServerType(String localServerType) {
        this.localServerType = localServerType;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public String getLocalServerURL() {
        return this.localServerURL;
    }

    public void setLocalServerURL(String localServerURL) {
        this.localServerURL = localServerURL;
    }

    public String getLocalServerUserId() {
        return this.localServerUserId;
    }

    public void setLocalServerUserId(String localServerUserId) {
        this.localServerUserId = localServerUserId;
    }

    public int getMaxPageSize() {
        return this.maxPageSize;
    }

    public void setMaxPageSize(int maxPageSize) {
        this.maxPageSize = maxPageSize;
    }

    public EventBusConfig getEventBusConfig() {
        return this.eventBusConfig;
    }

    public void setEventBusConfig(EventBusConfig eventBusConfig) {
        this.eventBusConfig = eventBusConfig;
    }

    public List<AccessServiceConfig> getAccessServicesConfig() {
        return this.accessServicesConfig;
    }

    public void setAccessServicesConfig(List<AccessServiceConfig> accessServicesConfig) {
        this.accessServicesConfig = accessServicesConfig;
    }

    public RepositoryServicesConfig getRepositoryServicesConfig() {
        return this.repositoryServicesConfig;
    }

    public void setRepositoryServicesConfig(RepositoryServicesConfig repositoryServicesConfig) {
        this.repositoryServicesConfig = repositoryServicesConfig;
    }
}

