/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.configuration.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.adminservices.configuration.properties.AdminServicesConfigHeader;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class DiscoveryServerConfig
extends AdminServicesConfigHeader {
    private String accessServiceRootURL = null;
    private String accessServiceServerName = null;
    private List<String> discoveryEngineGUIDs = null;

    public DiscoveryServerConfig() {
    }

    public DiscoveryServerConfig(DiscoveryServerConfig template) {
        super(template);
        if (template != null) {
            this.accessServiceRootURL = template.getAccessServiceRootURL();
            this.accessServiceServerName = template.getAccessServiceServerName();
            this.discoveryEngineGUIDs = template.getDiscoveryEngineGUIDs();
        }
    }

    public String getAccessServiceRootURL() {
        return this.accessServiceRootURL;
    }

    public void setAccessServiceRootURL(String accessServiceRootURL) {
        this.accessServiceRootURL = accessServiceRootURL;
    }

    public String getAccessServiceServerName() {
        return this.accessServiceServerName;
    }

    public void setAccessServiceServerName(String accessServiceServerName) {
        this.accessServiceServerName = accessServiceServerName;
    }

    public List<String> getDiscoveryEngineGUIDs() {
        return this.discoveryEngineGUIDs;
    }

    public void setDiscoveryEngineGUIDs(List<String> discoveryEngineGUIDs) {
        this.discoveryEngineGUIDs = discoveryEngineGUIDs;
    }

    public String toString() {
        return "DiscoveryServerConfig{accessServiceRootURL='" + this.accessServiceRootURL + '\'' + ", accessServiceServerName='" + this.accessServiceServerName + '\'' + ", discoveryEngineGUIDs=" + this.discoveryEngineGUIDs + '}';
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        DiscoveryServerConfig that = (DiscoveryServerConfig)objectToCompare;
        return Objects.equals(this.getAccessServiceRootURL(), that.getAccessServiceRootURL()) && Objects.equals(this.getAccessServiceServerName(), that.getAccessServiceServerName()) && Objects.equals(this.getDiscoveryEngineGUIDs(), that.getDiscoveryEngineGUIDs());
    }

    public int hashCode() {
        return Objects.hash(this.getAccessServiceRootURL(), this.getAccessServiceServerName(), this.getDiscoveryEngineGUIDs());
    }
}

