/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.configuration.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.adminservices.configuration.properties.AdminServicesConfigHeader;
import org.odpi.openmetadata.adminservices.configuration.properties.OpenMetadataExchangeRule;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class LocalRepositoryConfig
extends AdminServicesConfigHeader {
    private String metadataCollectionId = null;
    private String metadataCollectionName = null;
    private Connection localRepositoryLocalConnection = null;
    private Connection localRepositoryRemoteConnection = null;
    private OpenMetadataExchangeRule eventsToSaveRule = null;
    private List<TypeDefSummary> selectedTypesToSave = null;
    private OpenMetadataExchangeRule eventsToSendRule = null;
    private List<TypeDefSummary> selectedTypesToSend = null;
    private Connection eventMapperConnection = null;

    public LocalRepositoryConfig() {
    }

    public LocalRepositoryConfig(LocalRepositoryConfig template) {
        super(template);
        if (template != null) {
            this.metadataCollectionId = template.getMetadataCollectionId();
            this.metadataCollectionName = template.getMetadataCollectionName();
            this.localRepositoryLocalConnection = template.getLocalRepositoryLocalConnection();
            this.localRepositoryRemoteConnection = template.getLocalRepositoryRemoteConnection();
            this.eventsToSaveRule = template.getEventsToSaveRule();
            this.selectedTypesToSave = template.getSelectedTypesToSave();
            this.eventsToSendRule = template.getEventsToSendRule();
            this.selectedTypesToSend = template.getSelectedTypesToSend();
            this.eventMapperConnection = template.getEventMapperConnection();
        }
    }

    public String getMetadataCollectionId() {
        return this.metadataCollectionId;
    }

    public void setMetadataCollectionId(String metadataCollectionId) {
        this.metadataCollectionId = metadataCollectionId;
    }

    public String getMetadataCollectionName() {
        return this.metadataCollectionName;
    }

    public void setMetadataCollectionName(String metadataCollectionName) {
        this.metadataCollectionName = metadataCollectionName;
    }

    public Connection getLocalRepositoryLocalConnection() {
        return this.localRepositoryLocalConnection;
    }

    public void setLocalRepositoryLocalConnection(Connection localRepositoryLocalConnection) {
        this.localRepositoryLocalConnection = localRepositoryLocalConnection;
    }

    public Connection getLocalRepositoryRemoteConnection() {
        return this.localRepositoryRemoteConnection;
    }

    public void setLocalRepositoryRemoteConnection(Connection localRepositoryRemoteConnection) {
        this.localRepositoryRemoteConnection = localRepositoryRemoteConnection;
    }

    public OpenMetadataExchangeRule getEventsToSaveRule() {
        return this.eventsToSaveRule;
    }

    public void setEventsToSaveRule(OpenMetadataExchangeRule eventsToSaveRule) {
        this.eventsToSaveRule = eventsToSaveRule;
    }

    public List<TypeDefSummary> getSelectedTypesToSave() {
        if (this.selectedTypesToSave == null) {
            return null;
        }
        if (this.selectedTypesToSave.isEmpty()) {
            return null;
        }
        ArrayList<TypeDefSummary> resultList = new ArrayList<TypeDefSummary>();
        for (TypeDefSummary typeDefSummary : this.selectedTypesToSave) {
            if (typeDefSummary == null) continue;
            resultList.add(new TypeDefSummary(typeDefSummary));
        }
        return resultList;
    }

    public void setSelectedTypesToSave(List<TypeDefSummary> selectedTypesToSave) {
        this.selectedTypesToSave = selectedTypesToSave;
    }

    public OpenMetadataExchangeRule getEventsToSendRule() {
        return this.eventsToSendRule;
    }

    public void setEventsToSendRule(OpenMetadataExchangeRule eventsToSendRule) {
        this.eventsToSendRule = eventsToSendRule;
    }

    public List<TypeDefSummary> getSelectedTypesToSend() {
        if (this.selectedTypesToSend == null) {
            return null;
        }
        if (this.selectedTypesToSend.isEmpty()) {
            return null;
        }
        ArrayList<TypeDefSummary> resultList = new ArrayList<TypeDefSummary>();
        for (TypeDefSummary typeDefSummary : this.selectedTypesToSend) {
            if (typeDefSummary == null) continue;
            resultList.add(new TypeDefSummary(typeDefSummary));
        }
        return resultList;
    }

    public void setSelectedTypesToSend(List<TypeDefSummary> selectedTypesToSend) {
        this.selectedTypesToSend = selectedTypesToSend;
    }

    public Connection getEventMapperConnection() {
        return this.eventMapperConnection;
    }

    public void setEventMapperConnection(Connection eventMapperConnection) {
        this.eventMapperConnection = eventMapperConnection;
    }

    public String toString() {
        return "LocalRepositoryConfig{metadataCollectionId='" + this.metadataCollectionId + '\'' + ", metadataCollectionName='" + this.metadataCollectionName + '\'' + ", localRepositoryLocalConnection=" + this.localRepositoryLocalConnection + ", localRepositoryRemoteConnection=" + this.localRepositoryRemoteConnection + ", eventsToSaveRule=" + this.eventsToSaveRule + ", selectedTypesToSave=" + this.selectedTypesToSave + ", eventsToSendRule=" + this.eventsToSendRule + ", selectedTypesToSend=" + this.selectedTypesToSend + ", eventMapperConnection=" + this.eventMapperConnection + '}';
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        LocalRepositoryConfig that = (LocalRepositoryConfig)objectToCompare;
        return Objects.equals(this.getMetadataCollectionId(), that.getMetadataCollectionId()) && Objects.equals(this.getMetadataCollectionName(), that.getMetadataCollectionName()) && Objects.equals(this.getLocalRepositoryLocalConnection(), that.getLocalRepositoryLocalConnection()) && Objects.equals(this.getLocalRepositoryRemoteConnection(), that.getLocalRepositoryRemoteConnection()) && this.getEventsToSaveRule() == that.getEventsToSaveRule() && Objects.equals(this.getSelectedTypesToSave(), that.getSelectedTypesToSave()) && this.getEventsToSendRule() == that.getEventsToSendRule() && Objects.equals(this.getSelectedTypesToSend(), that.getSelectedTypesToSend()) && Objects.equals(this.getEventMapperConnection(), that.getEventMapperConnection());
    }

    public int hashCode() {
        return Objects.hash(this.getMetadataCollectionId(), this.getMetadataCollectionName(), this.getLocalRepositoryLocalConnection(), this.getLocalRepositoryRemoteConnection(), this.getEventsToSaveRule(), this.getSelectedTypesToSave(), this.getEventsToSendRule(), this.getSelectedTypesToSend(), this.getEventMapperConnection());
    }
}

