/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.configuration.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.AdminServicesConfigHeader;
import org.odpi.openmetadata.adminservices.configuration.properties.ConformanceSuiteConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.DataEngineProxyConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.DataPlatformConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.DiscoveryServerConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.EventBusConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OpenLineageConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.RepositoryServicesConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.SecurityOfficerConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.SecuritySyncConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.StewardshipServicesConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.VirtualizationConfig;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class OMAGServerConfig
extends AdminServicesConfigHeader {
    public static final String VERSION_ONE = "V1.0";
    public static final String VERSION_TWO = "V2.0";
    public static final List<String> COMPATIBLE_VERSIONS = new ArrayList<String>(Arrays.asList("V2.0"));
    private static final String defaultLocalServerType = "Open Metadata and Governance Server";
    private static final String defaultLocalOrganizationName = null;
    private static final String defaultLocalServerURL = "http://localhost:8080";
    private static final String defaultLocalServerUserId = "OMAGServer";
    private static final int defaultMaxPageSize = 1000;
    private String versionId = null;
    private String localServerId = UUID.randomUUID().toString();
    private String localServerName = null;
    private String localServerType = "Open Metadata and Governance Server";
    private String organizationName = defaultLocalOrganizationName;
    private String localServerURL = "http://localhost:8080";
    private String localServerUserId = "OMAGServer";
    private String localServerPassword = null;
    private int maxPageSize = 1000;
    private Connection serverSecurityConnection = null;
    private EventBusConfig eventBusConfig = null;
    private List<AccessServiceConfig> accessServicesConfig = null;
    private RepositoryServicesConfig repositoryServicesConfig = null;
    private ConformanceSuiteConfig conformanceSuiteConfig = null;
    private DiscoveryServerConfig discoveryServerConfig = null;
    private OpenLineageConfig openLineageConfig = null;
    private StewardshipServicesConfig stewardshipServicesConfig = null;
    private SecuritySyncConfig securitySyncConfig = null;
    private SecurityOfficerConfig securityOfficerConfig = null;
    private List<String> auditTrail = null;
    private VirtualizationConfig virtualizationConfig = null;
    private DataEngineProxyConfig dataEngineProxyConfig = null;
    private DataPlatformConfig dataPlatformConfig = null;

    public OMAGServerConfig() {
    }

    public OMAGServerConfig(OMAGServerConfig template) {
        super(template);
        if (template != null) {
            this.versionId = template.getVersionId();
            this.localServerId = template.getLocalServerId();
            this.localServerName = template.getLocalServerName();
            this.localServerType = template.getLocalServerType();
            this.organizationName = template.getOrganizationName();
            this.localServerURL = template.getLocalServerURL();
            this.localServerUserId = template.getLocalServerUserId();
            this.localServerPassword = template.getLocalServerPassword();
            this.maxPageSize = template.getMaxPageSize();
            this.serverSecurityConnection = template.getServerSecurityConnection();
            this.eventBusConfig = template.getEventBusConfig();
            this.accessServicesConfig = template.getAccessServicesConfig();
            this.repositoryServicesConfig = template.getRepositoryServicesConfig();
            this.conformanceSuiteConfig = template.getConformanceSuiteConfig();
            this.discoveryServerConfig = template.getDiscoveryServerConfig();
            this.openLineageConfig = template.getOpenLineageConfig();
            this.stewardshipServicesConfig = template.getStewardshipServicesConfig();
            this.securitySyncConfig = template.getSecuritySyncConfig();
            this.securityOfficerConfig = template.getSecurityOfficerConfig();
            this.auditTrail = template.getAuditTrail();
            this.virtualizationConfig = template.getVirtualizationConfig();
            this.dataEngineProxyConfig = template.getDataEngineProxyConfig();
            this.dataPlatformConfig = template.getDataPlatformConfig();
        }
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public String getLocalServerId() {
        return this.localServerId;
    }

    public void setLocalServerId(String localServerId) {
        this.localServerId = localServerId;
    }

    public String getLocalServerName() {
        return this.localServerName;
    }

    public void setLocalServerName(String localServerName) {
        this.localServerName = localServerName;
    }

    public String getLocalServerType() {
        return this.localServerType;
    }

    public void setLocalServerType(String localServerType) {
        this.localServerType = localServerType;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public String getLocalServerURL() {
        return this.localServerURL;
    }

    public void setLocalServerURL(String localServerURL) {
        this.localServerURL = localServerURL;
    }

    public String getLocalServerUserId() {
        return this.localServerUserId;
    }

    public void setLocalServerUserId(String localServerUserId) {
        this.localServerUserId = localServerUserId;
    }

    public String getLocalServerPassword() {
        return this.localServerPassword;
    }

    public void setLocalServerPassword(String localServerPassword) {
        this.localServerPassword = localServerPassword;
    }

    public int getMaxPageSize() {
        return this.maxPageSize;
    }

    public void setMaxPageSize(int maxPageSize) {
        this.maxPageSize = maxPageSize;
    }

    public Connection getServerSecurityConnection() {
        return this.serverSecurityConnection;
    }

    public void setServerSecurityConnection(Connection serverSecurityConnection) {
        this.serverSecurityConnection = serverSecurityConnection;
    }

    public EventBusConfig getEventBusConfig() {
        return this.eventBusConfig;
    }

    public void setEventBusConfig(EventBusConfig eventBusConfig) {
        this.eventBusConfig = eventBusConfig;
    }

    public List<AccessServiceConfig> getAccessServicesConfig() {
        return this.accessServicesConfig;
    }

    public void setAccessServicesConfig(List<AccessServiceConfig> accessServicesConfig) {
        this.accessServicesConfig = accessServicesConfig;
    }

    public RepositoryServicesConfig getRepositoryServicesConfig() {
        return this.repositoryServicesConfig;
    }

    public void setRepositoryServicesConfig(RepositoryServicesConfig repositoryServicesConfig) {
        this.repositoryServicesConfig = repositoryServicesConfig;
    }

    public ConformanceSuiteConfig getConformanceSuiteConfig() {
        return this.conformanceSuiteConfig;
    }

    public void setConformanceSuiteConfig(ConformanceSuiteConfig conformanceSuiteConfig) {
        this.conformanceSuiteConfig = conformanceSuiteConfig;
    }

    public DiscoveryServerConfig getDiscoveryServerConfig() {
        return this.discoveryServerConfig;
    }

    public void setDiscoveryServerConfig(DiscoveryServerConfig discoveryServerConfig) {
        this.discoveryServerConfig = discoveryServerConfig;
    }

    public OpenLineageConfig getOpenLineageConfig() {
        return this.openLineageConfig;
    }

    public void setOpenLineageConfig(OpenLineageConfig openLineageConfig) {
        this.openLineageConfig = openLineageConfig;
    }

    public StewardshipServicesConfig getStewardshipServicesConfig() {
        return this.stewardshipServicesConfig;
    }

    public void setStewardshipServicesConfig(StewardshipServicesConfig stewardshipServicesConfig) {
        this.stewardshipServicesConfig = stewardshipServicesConfig;
    }

    public SecuritySyncConfig getSecuritySyncConfig() {
        return this.securitySyncConfig;
    }

    public void setSecuritySyncConfig(SecuritySyncConfig securitySyncConfig) {
        this.securitySyncConfig = securitySyncConfig;
    }

    public SecurityOfficerConfig getSecurityOfficerConfig() {
        return this.securityOfficerConfig;
    }

    public void setSecurityOfficerConfig(SecurityOfficerConfig securityOfficerConfig) {
        this.securityOfficerConfig = securityOfficerConfig;
    }

    public VirtualizationConfig getVirtualizationConfig() {
        return this.virtualizationConfig;
    }

    public void setDataEngineProxyConfig(DataEngineProxyConfig dataEngineProxyConfig) {
        this.dataEngineProxyConfig = dataEngineProxyConfig;
    }

    public DataEngineProxyConfig getDataEngineProxyConfig() {
        return this.dataEngineProxyConfig;
    }

    public void setVirtualizationConfig(VirtualizationConfig virtualizationConfig) {
        this.virtualizationConfig = virtualizationConfig;
    }

    public DataPlatformConfig getDataPlatformConfig() {
        return this.dataPlatformConfig;
    }

    public void setDataPlatformConfig(DataPlatformConfig dataPlatformConfig) {
        this.dataPlatformConfig = dataPlatformConfig;
    }

    public List<String> getAuditTrail() {
        return this.auditTrail;
    }

    public void setAuditTrail(List<String> auditTrail) {
        this.auditTrail = auditTrail;
    }

    public String toString() {
        return "OMAGServerConfig{localServerId='" + this.localServerId + '\'' + ", localServerName='" + this.localServerName + '\'' + ", localServerType='" + this.localServerType + '\'' + ", organizationName='" + this.organizationName + '\'' + ", localServerURL='" + this.localServerURL + '\'' + ", localServerUserId='" + this.localServerUserId + '\'' + ", maxPageSize=" + this.maxPageSize + ", eventBusConfig=" + this.eventBusConfig + ", accessServicesConfig=" + this.accessServicesConfig + ", repositoryServicesConfig=" + this.repositoryServicesConfig + ", discoveryServerConfig=" + this.discoveryServerConfig + ", openLineageConfig=" + this.openLineageConfig + ", stewardshipServicesConfig=" + this.stewardshipServicesConfig + ", securitySyncConfig=" + this.securitySyncConfig + ", securityOfficerConfig=" + this.securityOfficerConfig + ", dataEngineProxyConfig=" + this.dataEngineProxyConfig + ", dataPlatformConfig=" + this.dataPlatformConfig + ", auditTrail=" + this.auditTrail + '}';
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        OMAGServerConfig that = (OMAGServerConfig)objectToCompare;
        return this.getMaxPageSize() == that.getMaxPageSize() && Objects.equals(this.getLocalServerId(), that.getLocalServerId()) && Objects.equals(this.getLocalServerName(), that.getLocalServerName()) && Objects.equals(this.getLocalServerType(), that.getLocalServerType()) && Objects.equals(this.getOrganizationName(), that.getOrganizationName()) && Objects.equals(this.getLocalServerURL(), that.getLocalServerURL()) && Objects.equals(this.getLocalServerUserId(), that.getLocalServerUserId()) && Objects.equals(this.getEventBusConfig(), that.getEventBusConfig()) && Objects.equals(this.getAccessServicesConfig(), that.getAccessServicesConfig()) && Objects.equals(this.getRepositoryServicesConfig(), that.getRepositoryServicesConfig()) && Objects.equals(this.getDiscoveryServerConfig(), that.getDiscoveryServerConfig()) && Objects.equals(this.getOpenLineageConfig(), that.getOpenLineageConfig()) && Objects.equals(this.getStewardshipServicesConfig(), that.getStewardshipServicesConfig()) && Objects.equals(this.getSecuritySyncConfig(), that.getSecuritySyncConfig()) && Objects.equals(this.getSecurityOfficerConfig(), that.getSecurityOfficerConfig()) && Objects.equals(this.getVirtualizationConfig(), that.getVirtualizationConfig()) && Objects.equals(this.getDataEngineProxyConfig(), that.getDataEngineProxyConfig()) && Objects.equals(this.getDataPlatformConfig(), that.getDataPlatformConfig()) && Objects.equals(this.getAuditTrail(), that.getAuditTrail());
    }

    public int hashCode() {
        return Objects.hash(this.getLocalServerId(), this.getLocalServerName(), this.getLocalServerType(), this.getOrganizationName(), this.getLocalServerURL(), this.getLocalServerUserId(), this.getMaxPageSize(), this.getEventBusConfig(), this.getAccessServicesConfig(), this.getRepositoryServicesConfig(), this.getDiscoveryServerConfig(), this.getStewardshipServicesConfig(), this.getSecuritySyncConfig(), this.getSecurityOfficerConfig(), this.getAuditTrail(), this.getVirtualizationConfig(), this.getDataEngineProxyConfig(), this.getDataPlatformConfig());
    }
}

