/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.configuration.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.adminservices.configuration.properties.AdminServicesConfigHeader;
import org.odpi.openmetadata.adminservices.configuration.properties.OpenMetadataEventProtocolVersion;
import org.odpi.openmetadata.adminservices.configuration.properties.OpenMetadataExchangeRule;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class CohortConfig
extends AdminServicesConfigHeader {
    private static final long serialVersionUID = 1L;
    private String cohortName = null;
    private Connection cohortRegistryConnection = null;
    private Connection cohortOMRSTopicConnection = null;
    private OpenMetadataEventProtocolVersion cohortOMRSTopicProtocolVersion = null;
    private OpenMetadataExchangeRule eventsToProcessRule = null;
    private List<TypeDefSummary> selectedTypesToProcess = null;

    public CohortConfig() {
    }

    public CohortConfig(CohortConfig template) {
        super(template);
        if (template != null) {
            this.cohortName = template.getCohortName();
            this.cohortRegistryConnection = template.getCohortRegistryConnection();
            this.cohortOMRSTopicConnection = template.getCohortOMRSTopicConnection();
            this.cohortOMRSTopicProtocolVersion = template.getCohortOMRSTopicProtocolVersion();
            this.eventsToProcessRule = template.getEventsToProcessRule();
            this.selectedTypesToProcess = template.getSelectedTypesToProcess();
        }
    }

    public String getCohortName() {
        return this.cohortName;
    }

    public void setCohortName(String cohortName) {
        this.cohortName = cohortName;
    }

    public Connection getCohortRegistryConnection() {
        return this.cohortRegistryConnection;
    }

    public void setCohortRegistryConnection(Connection cohortRegistryConnection) {
        this.cohortRegistryConnection = cohortRegistryConnection;
    }

    public Connection getCohortOMRSTopicConnection() {
        return this.cohortOMRSTopicConnection;
    }

    public void setCohortOMRSTopicConnection(Connection cohortOMRSTopicConnection) {
        this.cohortOMRSTopicConnection = cohortOMRSTopicConnection;
    }

    public OpenMetadataEventProtocolVersion getCohortOMRSTopicProtocolVersion() {
        return this.cohortOMRSTopicProtocolVersion;
    }

    public void setCohortOMRSTopicProtocolVersion(OpenMetadataEventProtocolVersion cohortOMRSTopicProtocolVersion) {
        this.cohortOMRSTopicProtocolVersion = cohortOMRSTopicProtocolVersion;
    }

    public OpenMetadataExchangeRule getEventsToProcessRule() {
        return this.eventsToProcessRule;
    }

    public void setEventsToProcessRule(OpenMetadataExchangeRule eventsToProcessRule) {
        this.eventsToProcessRule = eventsToProcessRule;
    }

    public List<TypeDefSummary> getSelectedTypesToProcess() {
        if (this.selectedTypesToProcess == null) {
            return null;
        }
        if (this.selectedTypesToProcess.isEmpty()) {
            return null;
        }
        ArrayList<TypeDefSummary> resultList = new ArrayList<TypeDefSummary>();
        for (TypeDefSummary typeDefSummary : this.selectedTypesToProcess) {
            if (typeDefSummary == null) continue;
            resultList.add(new TypeDefSummary(typeDefSummary));
        }
        return resultList;
    }

    public void setSelectedTypesToProcess(List<TypeDefSummary> selectedTypesToProcess) {
        this.selectedTypesToProcess = selectedTypesToProcess;
    }

    public String toString() {
        return "CohortConfig{cohortName='" + this.cohortName + '\'' + ", cohortRegistryConnection=" + this.cohortRegistryConnection + ", cohortOMRSTopicConnection=" + this.cohortOMRSTopicConnection + ", cohortOMRSTopicProtocolVersion=" + this.cohortOMRSTopicProtocolVersion + ", eventsToProcessRule=" + this.eventsToProcessRule + ", selectedTypesToProcess=" + this.selectedTypesToProcess + '}';
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        CohortConfig that = (CohortConfig)objectToCompare;
        return Objects.equals(this.getCohortName(), that.getCohortName()) && Objects.equals(this.getCohortRegistryConnection(), that.getCohortRegistryConnection()) && Objects.equals(this.getCohortOMRSTopicConnection(), that.getCohortOMRSTopicConnection()) && this.getCohortOMRSTopicProtocolVersion() == that.getCohortOMRSTopicProtocolVersion() && this.getEventsToProcessRule() == that.getEventsToProcessRule() && Objects.equals(this.getSelectedTypesToProcess(), that.getSelectedTypesToProcess());
    }

    public int hashCode() {
        return Objects.hash(this.getCohortName(), this.getCohortRegistryConnection(), this.getCohortOMRSTopicConnection(), this.getCohortOMRSTopicProtocolVersion(), this.getEventsToProcessRule(), this.getSelectedTypesToProcess());
    }
}

