/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.configuration.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerClientConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.ServiceOperationalStatus;
import org.odpi.openmetadata.adminservices.configuration.registration.ViewServiceRegistration;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ViewServiceConfig
extends OMAGServerClientConfig {
    private static final long serialVersionUID = 1L;
    private int viewServiceId = 0;
    private String viewAdminClass = null;
    private String viewServiceName = null;
    private String viewServiceFullName = null;
    private String viewURLMarker = null;
    private String viewDescription = null;
    private String viewWiki = null;
    private ServiceOperationalStatus viewOperationalStatus = null;
    private Map<String, Object> viewOptions = null;

    public ViewServiceConfig() {
    }

    public ViewServiceConfig(ViewServiceConfig template) {
        super(template);
        if (template != null) {
            this.viewServiceId = template.getViewServiceId();
            this.viewAdminClass = template.getViewServiceAdminClass();
            this.viewServiceFullName = template.getViewServiceFullName();
            this.viewServiceName = template.getViewServiceName();
            this.viewDescription = template.getViewServiceDescription();
            this.viewWiki = template.getViewServiceWiki();
            this.viewOperationalStatus = template.getViewServiceOperationalStatus();
            this.viewOptions = template.getViewServiceOptions();
        }
    }

    public ViewServiceConfig(ViewServiceRegistration viewRegistration) {
        this.viewServiceId = viewRegistration.getViewServiceCode();
        this.viewServiceName = viewRegistration.getViewServiceName();
        this.viewURLMarker = viewRegistration.getViewServiceURLMarker();
        this.viewAdminClass = viewRegistration.getViewServiceAdminClassName();
        this.viewDescription = viewRegistration.getViewServiceDescription();
        this.viewWiki = viewRegistration.getViewServiceWiki();
        this.viewOperationalStatus = viewRegistration.getViewServiceOperationalStatus();
    }

    public int getViewServiceId() {
        return this.viewServiceId;
    }

    public void setViewServiceId(int viewId) {
        this.viewServiceId = viewId;
    }

    public String getViewServiceAdminClass() {
        return this.viewAdminClass;
    }

    public void setViewServiceAdminClass(String viewAdminClass) {
        this.viewAdminClass = viewAdminClass;
    }

    public String getViewServiceFullName() {
        return this.viewServiceFullName;
    }

    public void setViewServiceFullName(String viewServiceFullName) {
        this.viewServiceFullName = viewServiceFullName;
    }

    public String getViewServiceName() {
        return this.viewServiceName;
    }

    public void setViewServiceName(String viewServiceName) {
        this.viewServiceName = viewServiceName;
    }

    public String getViewServiceURLMarker() {
        return this.viewURLMarker;
    }

    public void setServiceURLMarker(String viewURLMarker) {
        this.viewURLMarker = viewURLMarker;
    }

    public String getViewServiceDescription() {
        return this.viewDescription;
    }

    public void setViewServiceDescription(String viewDescription) {
        this.viewDescription = viewDescription;
    }

    public String getViewServiceWiki() {
        return this.viewWiki;
    }

    public void setViewServiceWiki(String viewWiki) {
        this.viewWiki = viewWiki;
    }

    public ServiceOperationalStatus getViewServiceOperationalStatus() {
        return this.viewOperationalStatus;
    }

    public void setViewServiceOperationalStatus(ServiceOperationalStatus viewOperationalStatus) {
        this.viewOperationalStatus = viewOperationalStatus;
    }

    public Map<String, Object> getViewServiceOptions() {
        if (this.viewOptions == null) {
            return null;
        }
        if (this.viewOptions.isEmpty()) {
            return null;
        }
        return this.viewOptions;
    }

    public void setViewServiceOptions(Map<String, Object> viewOptions) {
        this.viewOptions = viewOptions;
    }

    @Override
    public String toString() {
        return "ViewServiceConfig{viewServiceId=" + this.viewServiceId + ", viewAdminClass='" + this.viewAdminClass + '\'' + ", viewServiceName='" + this.viewServiceName + '\'' + ", viewServiceFullName='" + this.viewServiceFullName + '\'' + ", viewURLMarker='" + this.viewURLMarker + '\'' + ", viewDescription='" + this.viewDescription + '\'' + ", viewWiki='" + this.viewWiki + '\'' + ", viewOperationalStatus=" + this.viewOperationalStatus + ", viewOptions=" + this.viewOptions + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        ViewServiceConfig that = (ViewServiceConfig)objectToCompare;
        return this.getViewServiceId() == that.getViewServiceId() && Objects.equals(this.getViewServiceAdminClass(), that.getViewServiceAdminClass()) && Objects.equals(this.getViewServiceName(), that.getViewServiceName()) && Objects.equals(this.getViewServiceFullName(), that.getViewServiceFullName()) && Objects.equals(this.getViewServiceURLMarker(), that.getViewServiceURLMarker()) && Objects.equals(this.getViewServiceDescription(), that.getViewServiceDescription()) && Objects.equals(this.getViewServiceWiki(), that.getViewServiceWiki()) && this.getViewServiceOperationalStatus() == that.getViewServiceOperationalStatus() && Objects.equals(this.getViewServiceOptions(), that.getViewServiceOptions());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getViewServiceId(), this.getViewServiceAdminClass(), this.getViewServiceName(), this.getViewServiceFullName(), this.getViewServiceURLMarker(), this.getViewServiceDescription(), this.getViewServiceWiki(), this.getViewServiceOperationalStatus(), this.getViewServiceOptions());
    }
}

