/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.configuration.registration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public enum CommonServicesDescription implements Serializable
{
    REPOSITORY_SERVICES(3000, "Open Metadata Repository Services (OMRS)", "repository-services", "Manages the synchronization, retrieval and maintenance of metadata stored in open metadata repositories", "https://egeria.odpi.org/open-metadata-implementation/repository-services/"),
    ADMIN_OPERATIONAL_SERVICES(3001, "OMAG Server Operational Services", "admin-services", "Management of services active in an Open Metadata and governance server (OMAG Server)", "https://egeria.odpi.org/open-metadata-implementation/admin-services"),
    OCF_METADATA_MANAGEMENT(3002, "Connected Asset Services", "connected-asset", "Common metadata services for the Open Connector Framework (OCF)", "https://egeria.odpi.org/open-metadata-implementation/common-services/ocf-metadata-management/"),
    OPEN_METADATA_SECURITY(3003, "Open Metadata Security Services", null, "Authorization services for Open Metadata and Governance", "https://egeria.odpi.org/open-metadata-implementation/common-services/metadata-security/");

    private static final long serialVersionUID = 1L;
    private int serviceCode;
    private String serviceName;
    private String serviceURLMarker;
    private String serviceDescription;
    private String serviceWiki;

    public static List<CommonServicesDescription> getGovernanceServersDescriptionList() {
        ArrayList<CommonServicesDescription> serviceDescriptionList = new ArrayList<CommonServicesDescription>();
        serviceDescriptionList.add(REPOSITORY_SERVICES);
        serviceDescriptionList.add(ADMIN_OPERATIONAL_SERVICES);
        serviceDescriptionList.add(OCF_METADATA_MANAGEMENT);
        serviceDescriptionList.add(OPEN_METADATA_SECURITY);
        return serviceDescriptionList;
    }

    private CommonServicesDescription(int serviceCode, String serviceName, String serviceURLMarker, String serviceDescription, String serviceWiki) {
        this.serviceCode = serviceCode;
        this.serviceName = serviceName;
        this.serviceURLMarker = serviceURLMarker;
        this.serviceDescription = serviceDescription;
        this.serviceWiki = serviceWiki;
    }

    public int getServiceCode() {
        return this.serviceCode;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServiceURLMarker() {
        return this.serviceURLMarker;
    }

    public String getServiceDescription() {
        return this.serviceDescription;
    }

    public String getServiceWiki() {
        return this.serviceWiki;
    }
}

