/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.configuration.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.adminservices.configuration.properties.IntegrationViewServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerClientConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.SolutionViewServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.ServiceOperationalStatus;
import org.odpi.openmetadata.adminservices.configuration.registration.ViewServiceRegistration;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=SolutionViewServiceConfig.class, name="SolutionViewServiceConfig"), @JsonSubTypes.Type(value=IntegrationViewServiceConfig.class, name="IntegrationViewServiceConfig")})
public class ViewServiceConfig
extends OMAGServerClientConfig {
    private static final long serialVersionUID = 1L;
    private int viewServiceId = 0;
    private String viewServiceAdminClass = null;
    private String viewServiceName = null;
    private String viewServiceFullName = null;
    private String viewServiceURLMarker = null;
    private String viewServiceDescription = null;
    private String viewServiceWiki = null;
    private ServiceOperationalStatus viewServiceOperationalStatus = null;
    private Map<String, Object> viewServiceOptions = null;

    public ViewServiceConfig() {
    }

    public ViewServiceConfig(ViewServiceConfig template) {
        super(template);
        if (template != null) {
            this.viewServiceId = template.getViewServiceId();
            this.viewServiceAdminClass = template.getViewServiceAdminClass();
            this.viewServiceFullName = template.getViewServiceFullName();
            this.viewServiceName = template.getViewServiceName();
            this.viewServiceDescription = template.getViewServiceDescription();
            this.viewServiceWiki = template.getViewServiceWiki();
            this.viewServiceOperationalStatus = template.getViewServiceOperationalStatus();
            this.viewServiceOptions = template.getViewServiceOptions();
        }
    }

    public ViewServiceConfig(ViewServiceRegistration viewRegistration) {
        this.viewServiceId = viewRegistration.getViewServiceCode();
        this.viewServiceName = viewRegistration.getViewServiceName();
        this.viewServiceFullName = viewRegistration.getViewServiceFullName();
        this.viewServiceURLMarker = viewRegistration.getViewServiceURLMarker();
        this.viewServiceAdminClass = viewRegistration.getViewServiceAdminClassName();
        this.viewServiceDescription = viewRegistration.getViewServiceDescription();
        this.viewServiceWiki = viewRegistration.getViewServiceWiki();
        this.viewServiceOperationalStatus = viewRegistration.getViewServiceOperationalStatus();
    }

    public int getViewServiceId() {
        return this.viewServiceId;
    }

    public void setViewServiceId(int viewId) {
        this.viewServiceId = viewId;
    }

    public String getViewServiceAdminClass() {
        return this.viewServiceAdminClass;
    }

    public void setViewServiceAdminClass(String viewServiceAdminClass) {
        this.viewServiceAdminClass = viewServiceAdminClass;
    }

    public String getViewServiceFullName() {
        return this.viewServiceFullName;
    }

    public void setViewServiceFullName(String viewServiceFullName) {
        this.viewServiceFullName = viewServiceFullName;
    }

    public String getViewServiceName() {
        return this.viewServiceName;
    }

    public void setViewServiceName(String viewServiceName) {
        this.viewServiceName = viewServiceName;
    }

    public String getViewServiceURLMarker() {
        return this.viewServiceURLMarker;
    }

    public void setServiceURLMarker(String viewServiceURLMarker) {
        this.viewServiceURLMarker = viewServiceURLMarker;
    }

    public String getViewServiceDescription() {
        return this.viewServiceDescription;
    }

    public void setViewServiceDescription(String viewServiceDescription) {
        this.viewServiceDescription = viewServiceDescription;
    }

    public String getViewServiceWiki() {
        return this.viewServiceWiki;
    }

    public void setViewServiceWiki(String viewServiceWiki) {
        this.viewServiceWiki = viewServiceWiki;
    }

    public ServiceOperationalStatus getViewServiceOperationalStatus() {
        return this.viewServiceOperationalStatus;
    }

    public void setViewServiceOperationalStatus(ServiceOperationalStatus viewServiceOperationalStatus) {
        this.viewServiceOperationalStatus = viewServiceOperationalStatus;
    }

    public Map<String, Object> getViewServiceOptions() {
        if (this.viewServiceOptions == null) {
            return null;
        }
        if (this.viewServiceOptions.isEmpty()) {
            return null;
        }
        return this.viewServiceOptions;
    }

    public void setViewServiceOptions(Map<String, Object> viewServiceOptions) {
        this.viewServiceOptions = viewServiceOptions;
    }

    @Override
    public String toString() {
        return "ViewServiceConfig{viewServiceId=" + this.viewServiceId + ", viewServiceAdminClass='" + this.viewServiceAdminClass + '\'' + ", viewServiceName='" + this.viewServiceName + '\'' + ", viewServiceFullName='" + this.viewServiceFullName + '\'' + ", viewServiceURLMarker='" + this.viewServiceURLMarker + '\'' + ", viewServiceDescription='" + this.viewServiceDescription + '\'' + ", viewServiceWiki='" + this.viewServiceWiki + '\'' + ", viewServiceOperationalStatus=" + this.viewServiceOperationalStatus + ", viewServiceOptions=" + this.viewServiceOptions + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        ViewServiceConfig that = (ViewServiceConfig)objectToCompare;
        return this.getViewServiceId() == that.getViewServiceId() && Objects.equals(this.getViewServiceAdminClass(), that.getViewServiceAdminClass()) && Objects.equals(this.getViewServiceName(), that.getViewServiceName()) && Objects.equals(this.getViewServiceFullName(), that.getViewServiceFullName()) && Objects.equals(this.getViewServiceURLMarker(), that.getViewServiceURLMarker()) && Objects.equals(this.getViewServiceDescription(), that.getViewServiceDescription()) && Objects.equals(this.getViewServiceWiki(), that.getViewServiceWiki()) && this.getViewServiceOperationalStatus() == that.getViewServiceOperationalStatus() && Objects.equals(this.getViewServiceOptions(), that.getViewServiceOptions());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getViewServiceId(), this.getViewServiceAdminClass(), this.getViewServiceName(), this.getViewServiceFullName(), this.getViewServiceURLMarker(), this.getViewServiceDescription(), this.getViewServiceWiki(), this.getViewServiceOperationalStatus(), this.getViewServiceOptions());
    }
}

