/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.configuration.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import java.util.UUID;
import org.odpi.openmetadata.adminservices.configuration.properties.AdminServicesConfigHeader;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class IntegrationConnectorConfig
extends AdminServicesConfigHeader {
    private static final long serialVersionUID = 1L;
    private String connectorId = UUID.randomUUID().toString();
    private String connectorName = null;
    private String connectorUserId = null;
    private Connection connection = null;
    private String metadataSourceQualifiedName = null;
    private long refreshTimeInterval = 0L;
    private boolean usesBlockingCalls = false;

    public IntegrationConnectorConfig() {
    }

    public IntegrationConnectorConfig(IntegrationConnectorConfig template) {
        super(template);
        if (template != null) {
            this.connectorId = template.getConnectorId();
            this.connectorName = template.getConnectorName();
            this.connectorUserId = template.getConnectorUserId();
            this.connection = template.getConnection();
            this.metadataSourceQualifiedName = template.getMetadataSourceQualifiedName();
            this.refreshTimeInterval = template.getRefreshTimeInterval();
            this.usesBlockingCalls = template.getUsesBlockingCalls();
        }
    }

    public String getConnectorId() {
        return this.connectorId;
    }

    public void setConnectorId(String connectorId) {
        this.connectorId = connectorId;
    }

    public String getConnectorName() {
        return this.connectorName;
    }

    public void setConnectorName(String connectorName) {
        this.connectorName = connectorName;
    }

    public String getConnectorUserId() {
        return this.connectorUserId;
    }

    public void setConnectorUserId(String connectorUserId) {
        this.connectorUserId = connectorUserId;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public String getMetadataSourceQualifiedName() {
        return this.metadataSourceQualifiedName;
    }

    public void setMetadataSourceQualifiedName(String metadataSourceQualifiedName) {
        this.metadataSourceQualifiedName = metadataSourceQualifiedName;
    }

    public long getRefreshTimeInterval() {
        return this.refreshTimeInterval;
    }

    public void setRefreshTimeInterval(long refreshTimeInterval) {
        this.refreshTimeInterval = refreshTimeInterval;
    }

    public boolean getUsesBlockingCalls() {
        return this.usesBlockingCalls;
    }

    public void setUsesBlockingCalls(boolean usesBlockingCalls) {
        this.usesBlockingCalls = usesBlockingCalls;
    }

    public String toString() {
        return "IntegrationConnectorConfig{connectorId='" + this.connectorId + '\'' + ", connectorName='" + this.connectorName + '\'' + ", connectorUserId='" + this.connectorUserId + '\'' + ", connection=" + this.connection + ", metadataSourceQualifiedName='" + this.metadataSourceQualifiedName + '\'' + ", refreshTimeInterval=" + this.refreshTimeInterval + ", usesBlockingCalls=" + this.usesBlockingCalls + '}';
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        IntegrationConnectorConfig that = (IntegrationConnectorConfig)objectToCompare;
        return this.refreshTimeInterval == that.refreshTimeInterval && this.usesBlockingCalls == that.usesBlockingCalls && Objects.equals(this.metadataSourceQualifiedName, that.metadataSourceQualifiedName) && Objects.equals(this.connectorId, that.connectorId) && Objects.equals(this.connectorName, that.connectorName) && Objects.equals(this.connectorUserId, that.connectorUserId) && Objects.equals(this.connection, that.connection);
    }

    public int hashCode() {
        return Objects.hash(this.connectorId, this.connectorName, this.connectorUserId, this.connection, this.metadataSourceQualifiedName, this.refreshTimeInterval, this.usesBlockingCalls);
    }
}

