/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.configuration.registration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public enum GovernanceServicesDescription implements Serializable
{
    SECURITY_SYNC_SERVICES(2001, "Security Sync Services", null, "Keep security enforcement engine up-to-date", "https://egeria.odpi.org/open-metadata-implementation/governance-servers/security-sync-services/"),
    OPEN_LINEAGE_SERVICES(2003, "Open Lineage Services", "open-lineage", "Store and query asset lineage", "https://egeria.odpi.org/open-metadata-implementation/governance-servers/open-lineage-services/"),
    VIRTUALIZATION_SERVICES(2004, "Virtualization Services", null, "Run virtualization services", "https://egeria.odpi.org/open-metadata-implementation/governance-servers/virtualization-services/"),
    CONFORMANCE_SUITE_SERVICES(2005, "Conformance Suite Services", "conformance-suite", "Run automated open metadata conformance suite services", "https://egeria.odpi.org/open-metadata-conformance-suite/"),
    SECURITY_OFFICER_SERVICES(2006, "Security Officer Services", null, "Manage security tags and other operational security settings", "https://egeria.odpi.org/open-metadata-implementation/governance-servers/security-officer-services/"),
    DATA_ENGINE_PROXY_SERVICES(2007, "Data Engine Proxy Services", null, "Integrate Data Engines that are not self-capable of integrating directly with the Data Engine OMAS", "https://egeria.odpi.org/open-metadata-implementation/governance-servers/data-engine-proxy-services/"),
    DATA_PLATFORM_SERVICES(2008, "Data Platform Services", null, "Publish metadata on data platforms that are not self-capable of integrating directly with the Data Platform OMAS", "https://egeria.odpi.org/open-metadata-implementation/governance-servers/data-platform-services/"),
    INTEGRATION_DAEMON_SERVICES(2009, "Integration Daemon Services", null, "Host one or more integration services that are exchanging metadata with third party technologies", "https://egeria.odpi.org/open-metadata-implementation/governance-servers/integration-daemon-services/"),
    ENGINE_HOST_SERVICES(2010, "Engine Host Services", null, "Host one or more engine services that are actively managing governance of open metadata and the digital landscape", "https://egeria.odpi.org/open-metadata-implementation/governance-servers/engine-host-services/");

    private static final long serialVersionUID = 1L;
    private int serviceCode;
    private String serviceName;
    private String serviceURLMarker;
    private String serviceDescription;
    private String serviceWiki;

    public static List<GovernanceServicesDescription> getGovernanceServersDescriptionList() {
        ArrayList<GovernanceServicesDescription> serviceDescriptionList = new ArrayList<GovernanceServicesDescription>();
        serviceDescriptionList.add(OPEN_LINEAGE_SERVICES);
        serviceDescriptionList.add(INTEGRATION_DAEMON_SERVICES);
        serviceDescriptionList.add(CONFORMANCE_SUITE_SERVICES);
        serviceDescriptionList.add(DATA_ENGINE_PROXY_SERVICES);
        return serviceDescriptionList;
    }

    public static Set<String> getGovernanceServersURLMarkers() {
        HashSet<String> urlMarkerSet = new HashSet<String>();
        for (GovernanceServicesDescription governanceServicesDescription : GovernanceServicesDescription.getGovernanceServersDescriptionList()) {
            String urlMarker = governanceServicesDescription.getServiceURLMarker();
            if (urlMarker == null) continue;
            urlMarkerSet.add(urlMarker);
        }
        return urlMarkerSet;
    }

    private GovernanceServicesDescription(int serviceCode, String serviceName, String serviceURLMarker, String serviceDescription, String serviceWiki) {
        this.serviceCode = serviceCode;
        this.serviceName = serviceName;
        this.serviceURLMarker = serviceURLMarker;
        this.serviceDescription = serviceDescription;
        this.serviceWiki = serviceWiki;
    }

    public int getServiceCode() {
        return this.serviceCode;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServiceURLMarker() {
        return this.serviceURLMarker;
    }

    public String getServiceDescription() {
        return this.serviceDescription;
    }

    public String getServiceWiki() {
        return this.serviceWiki;
    }
}

