/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.adminservices.configuration.properties.EngineConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerClientConfig;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class EngineServiceRequestBody
extends OMAGServerClientConfig {
    private static final long serialVersionUID = 1L;
    private Map<String, Object> engineServiceOptions = null;
    private List<EngineConfig> engines = null;

    public EngineServiceRequestBody() {
    }

    public EngineServiceRequestBody(EngineServiceRequestBody template) {
        super(template);
        if (template != null) {
            this.engines = template.getEngines();
            this.engineServiceOptions = template.getEngineServiceOptions();
        }
    }

    public List<EngineConfig> getEngines() {
        return this.engines;
    }

    public void setEngines(List<EngineConfig> engines) {
        this.engines = engines;
    }

    public Map<String, Object> getEngineServiceOptions() {
        if (this.engineServiceOptions == null) {
            return null;
        }
        if (this.engineServiceOptions.isEmpty()) {
            return null;
        }
        return this.engineServiceOptions;
    }

    public void setEngineServiceOptions(Map<String, Object> engineServiceOptions) {
        this.engineServiceOptions = engineServiceOptions;
    }

    @Override
    public String toString() {
        return "EngineServiceRequestBody{engineServiceOptions=" + this.engineServiceOptions + ", engines=" + this.engines + ", OMAGServerPlatformRootURL='" + this.getOMAGServerPlatformRootURL() + '\'' + ", OMAGServerName='" + this.getOMAGServerName() + '\'' + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        EngineServiceRequestBody that = (EngineServiceRequestBody)objectToCompare;
        return Objects.equals(this.engineServiceOptions, that.engineServiceOptions) && Objects.equals(this.engines, that.engines);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.engineServiceOptions, this.engines);
    }
}

