/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.configuration.registration;

import java.io.Serializable;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDevelopmentStatus;

public enum ViewServiceDescription implements Serializable
{
    GLOSSARY_AUTHOR(800, ComponentDevelopmentStatus.IN_DEVELOPMENT, "Glossary Author", "Glossary Author OMVS", "glossary-author", "View Service for glossary authoring.", "https://egeria-project.org/services/omvs/glossary-author/overview"),
    REPOSITORY_EXPLORER(801, ComponentDevelopmentStatus.TECHNICAL_PREVIEW, "Repository Explorer", "Repository Explorer OMVS", "rex", "Explore open metadata instances.", "https://egeria-project.org/services/omvs/rex/overview"),
    TYPE_EXPLORER(802, ComponentDevelopmentStatus.TECHNICAL_PREVIEW, "Type Explorer", "Type Explorer OMVS", "tex", "Explore the open metadata types in a repository or cohort.", "https://egeria-project.org/services/omvs/tex/overview"),
    DINO(803, ComponentDevelopmentStatus.TECHNICAL_PREVIEW, "Dynamic Infrastructure and Operations", "Dynamic Infrastructure and Operations OMVS", "dino", "Explore and operate an open metadata ecosystem.", "https://egeria-project.org/services/omvs/dino/overview"),
    SERVER_AUTHOR(804, ComponentDevelopmentStatus.IN_DEVELOPMENT, "Server Author", "Server Author OMVS", "server-author", "Author servers.", "https://egeria-project.org/services/omvs/server-author/overview/");

    private static final long serialVersionUID = 1L;
    private int viewServiceCode;
    private ComponentDevelopmentStatus viewServiceDevelopmentStatus;
    private String viewServiceName;
    private String viewServiceFullName;
    private String viewServiceURLMarker;
    private String viewServiceDescription;
    private String viewServiceWiki;

    private ViewServiceDescription(int viewServiceCode, ComponentDevelopmentStatus viewServiceDevelopmentStatus, String viewServiceName, String viewServiceFullName, String viewServiceURLMarker, String viewServiceDescription, String viewServiceWiki) {
        this.viewServiceCode = viewServiceCode;
        this.viewServiceDevelopmentStatus = viewServiceDevelopmentStatus;
        this.viewServiceName = viewServiceName;
        this.viewServiceFullName = viewServiceFullName;
        this.viewServiceURLMarker = viewServiceURLMarker;
        this.viewServiceDescription = viewServiceDescription;
        this.viewServiceWiki = viewServiceWiki;
    }

    public static ViewServiceDescription getViewServiceDefinition(int viewServiceCode) {
        for (ViewServiceDescription description : ViewServiceDescription.values()) {
            if (viewServiceCode != description.getViewServiceCode()) continue;
            return description;
        }
        return null;
    }

    public int getViewServiceCode() {
        return this.viewServiceCode;
    }

    public ComponentDevelopmentStatus getViewServiceDevelopmentStatus() {
        return this.viewServiceDevelopmentStatus;
    }

    public String getViewServiceName() {
        return this.viewServiceName;
    }

    public String getViewServiceFullName() {
        return this.viewServiceFullName;
    }

    public String getViewServiceURLMarker() {
        return this.viewServiceURLMarker;
    }

    public String getViewServiceDescription() {
        return this.viewServiceDescription;
    }

    public String getViewServiceWiki() {
        return this.viewServiceWiki;
    }
}

