/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.configuration.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.adminservices.configuration.properties.AdminServicesConfigHeader;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceRegistration;
import org.odpi.openmetadata.adminservices.configuration.registration.ServiceOperationalStatus;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDevelopmentStatus;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class AccessServiceConfig
extends AdminServicesConfigHeader {
    private static final long serialVersionUID = 1L;
    private int accessServiceId = 0;
    private ComponentDevelopmentStatus accessServiceDevelopmentStatus = null;
    private String accessServiceAdminClass = null;
    private String accessServiceName = null;
    private String accessServiceFullName = null;
    private String accessServiceURLMarker = null;
    private String accessServiceDescription = null;
    private String accessServiceWiki = null;
    private ServiceOperationalStatus accessServiceOperationalStatus = null;
    private Connection accessServiceInTopic = null;
    private Connection accessServiceOutTopic = null;
    private Map<String, Object> accessServiceOptions = null;

    public AccessServiceConfig() {
    }

    public AccessServiceConfig(AccessServiceConfig template) {
        super(template);
        if (template != null) {
            this.accessServiceId = template.getAccessServiceId();
            this.accessServiceDevelopmentStatus = template.getAccessServiceDevelopmentStatus();
            this.accessServiceAdminClass = template.getAccessServiceAdminClass();
            this.accessServiceName = template.getAccessServiceName();
            this.accessServiceFullName = template.getAccessServiceFullName();
            this.accessServiceDescription = template.getAccessServiceDescription();
            this.accessServiceURLMarker = template.getAccessServiceURLMarker();
            this.accessServiceWiki = template.getAccessServiceWiki();
            this.accessServiceOperationalStatus = template.getAccessServiceOperationalStatus();
            this.accessServiceInTopic = template.getAccessServiceInTopic();
            this.accessServiceOutTopic = template.getAccessServiceOutTopic();
            this.accessServiceOptions = template.getAccessServiceOptions();
        }
    }

    public AccessServiceConfig(AccessServiceRegistration accessServiceRegistration) {
        this.accessServiceId = accessServiceRegistration.getAccessServiceCode();
        this.accessServiceDevelopmentStatus = accessServiceRegistration.getAccessServiceDevelopmentStatus();
        this.accessServiceName = accessServiceRegistration.getAccessServiceName();
        this.accessServiceFullName = accessServiceRegistration.getAccessServiceFullName();
        this.accessServiceURLMarker = accessServiceRegistration.getAccessServiceURLMarker();
        this.accessServiceAdminClass = accessServiceRegistration.getAccessServiceAdminClassName();
        this.accessServiceDescription = accessServiceRegistration.getAccessServiceDescription();
        this.accessServiceWiki = accessServiceRegistration.getAccessServiceWiki();
        this.accessServiceOperationalStatus = accessServiceRegistration.getAccessServiceOperationalStatus();
    }

    public int getAccessServiceId() {
        return this.accessServiceId;
    }

    public void setAccessServiceId(int accessServiceId) {
        this.accessServiceId = accessServiceId;
    }

    public ComponentDevelopmentStatus getAccessServiceDevelopmentStatus() {
        return this.accessServiceDevelopmentStatus;
    }

    public void setAccessServiceDevelopmentStatus(ComponentDevelopmentStatus accessServiceDevelopmentStatus) {
        this.accessServiceDevelopmentStatus = accessServiceDevelopmentStatus;
    }

    public String getAccessServiceAdminClass() {
        return this.accessServiceAdminClass;
    }

    public void setAccessServiceAdminClass(String accessServiceAdminClass) {
        this.accessServiceAdminClass = accessServiceAdminClass;
    }

    public String getAccessServiceName() {
        return this.accessServiceName;
    }

    public void setAccessServiceFullName(String accessServiceFullName) {
        this.accessServiceFullName = accessServiceFullName;
    }

    public void setAccessServiceName(String accessServiceName) {
        this.accessServiceName = accessServiceName;
    }

    public String getAccessServiceFullName() {
        if (this.accessServiceFullName == null) {
            if (this.accessServiceName == null) {
                return null;
            }
            return this.accessServiceName + " OMAS";
        }
        return this.accessServiceFullName;
    }

    public String getAccessServiceURLMarker() {
        return this.accessServiceURLMarker;
    }

    public void setAccessServiceURLMarker(String accessServiceURLMarker) {
        this.accessServiceURLMarker = accessServiceURLMarker;
    }

    public String getAccessServiceDescription() {
        return this.accessServiceDescription;
    }

    public void setAccessServiceDescription(String accessServiceDescription) {
        this.accessServiceDescription = accessServiceDescription;
    }

    public String getAccessServiceWiki() {
        return this.accessServiceWiki;
    }

    public void setAccessServiceWiki(String accessServiceWiki) {
        this.accessServiceWiki = accessServiceWiki;
    }

    public ServiceOperationalStatus getAccessServiceOperationalStatus() {
        return this.accessServiceOperationalStatus;
    }

    public void setAccessServiceOperationalStatus(ServiceOperationalStatus accessServiceOperationalStatus) {
        this.accessServiceOperationalStatus = accessServiceOperationalStatus;
    }

    public Connection getAccessServiceInTopic() {
        return this.accessServiceInTopic;
    }

    public void setAccessServiceInTopic(Connection accessServiceInTopic) {
        this.accessServiceInTopic = accessServiceInTopic;
    }

    public Connection getAccessServiceOutTopic() {
        return this.accessServiceOutTopic;
    }

    public void setAccessServiceOutTopic(Connection accessServiceOutTopic) {
        this.accessServiceOutTopic = accessServiceOutTopic;
    }

    public Map<String, Object> getAccessServiceOptions() {
        if (this.accessServiceOptions == null) {
            return null;
        }
        if (this.accessServiceOptions.isEmpty()) {
            return null;
        }
        return this.accessServiceOptions;
    }

    public void setAccessServiceOptions(Map<String, Object> accessServiceOptions) {
        this.accessServiceOptions = accessServiceOptions;
    }

    public String toString() {
        return "AccessServiceConfig{accessServiceId=" + this.accessServiceId + ", accessServiceDevelopmentStatus=" + this.accessServiceDevelopmentStatus + ", accessServiceAdminClass='" + this.accessServiceAdminClass + "', accessServiceName='" + this.accessServiceName + "', accessServiceFullName='" + this.accessServiceFullName + "', accessServiceURLMarker='" + this.accessServiceURLMarker + "', accessServiceDescription='" + this.accessServiceDescription + "', accessServiceWiki='" + this.accessServiceWiki + "', accessServiceOperationalStatus=" + this.accessServiceOperationalStatus + ", accessServiceInTopic=" + this.accessServiceInTopic + ", accessServiceOutTopic=" + this.accessServiceOutTopic + ", accessServiceOptions=" + this.accessServiceOptions + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        AccessServiceConfig that = (AccessServiceConfig)objectToCompare;
        return this.accessServiceId == that.accessServiceId && this.accessServiceDevelopmentStatus == that.accessServiceDevelopmentStatus && Objects.equals(this.accessServiceAdminClass, that.accessServiceAdminClass) && Objects.equals(this.accessServiceName, that.accessServiceName) && Objects.equals(this.accessServiceFullName, that.accessServiceFullName) && Objects.equals(this.accessServiceURLMarker, that.accessServiceURLMarker) && Objects.equals(this.accessServiceDescription, that.accessServiceDescription) && Objects.equals(this.accessServiceWiki, that.accessServiceWiki) && this.accessServiceOperationalStatus == that.accessServiceOperationalStatus && Objects.equals(this.accessServiceInTopic, that.accessServiceInTopic) && Objects.equals(this.accessServiceOutTopic, that.accessServiceOutTopic) && Objects.equals(this.accessServiceOptions, that.accessServiceOptions);
    }

    public int hashCode() {
        return Objects.hash(this.accessServiceId, this.accessServiceDevelopmentStatus, this.accessServiceAdminClass, this.accessServiceName, this.accessServiceFullName, this.accessServiceURLMarker, this.accessServiceDescription, this.accessServiceWiki, this.accessServiceOperationalStatus, this.accessServiceInTopic, this.accessServiceOutTopic, this.accessServiceOptions);
    }
}

