/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.configuration.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.adminservices.configuration.properties.IntegrationConnectorConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerClientConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.PermittedSynchronization;
import org.odpi.openmetadata.adminservices.configuration.registration.ServiceOperationalStatus;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDevelopmentStatus;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class IntegrationServiceConfig
extends OMAGServerClientConfig {
    private static final long serialVersionUID = 1L;
    private int integrationServiceId = 0;
    private ComponentDevelopmentStatus integrationServiceDevelopmentStatus = null;
    private String integrationServiceContextManagerClass = null;
    private String integrationServiceName = null;
    private String integrationServiceFullName = null;
    private String integrationServiceURLMarker = null;
    private String integrationServiceDescription = null;
    private String integrationServiceWiki = null;
    private String integrationServicePartnerOMAS = null;
    private PermittedSynchronization defaultPermittedSynchronization = null;
    private ServiceOperationalStatus integrationServiceOperationalStatus = null;
    private Map<String, Object> integrationServiceOptions = null;
    private List<IntegrationConnectorConfig> integrationConnectorConfigs = null;

    public IntegrationServiceConfig() {
    }

    public IntegrationServiceConfig(IntegrationServiceConfig template) {
        super(template);
        if (template != null) {
            this.integrationServiceId = template.getIntegrationServiceId();
            this.integrationServiceDevelopmentStatus = template.getIntegrationServiceDevelopmentStatus();
            this.integrationServiceContextManagerClass = template.getIntegrationServiceContextManagerClass();
            this.integrationServiceName = template.getIntegrationServiceName();
            this.integrationServiceFullName = template.getIntegrationServiceFullName();
            this.integrationServiceURLMarker = template.getIntegrationServiceURLMarker();
            this.integrationServiceDescription = template.getIntegrationServiceDescription();
            this.integrationServiceWiki = template.getIntegrationServiceWiki();
            this.integrationServicePartnerOMAS = template.getIntegrationServicePartnerOMAS();
            this.defaultPermittedSynchronization = template.getDefaultPermittedSynchronization();
            this.integrationServiceOperationalStatus = template.getIntegrationServiceOperationalStatus();
            this.integrationServiceOptions = template.getIntegrationServiceOptions();
            this.integrationConnectorConfigs = template.getIntegrationConnectorConfigs();
        }
    }

    public int getIntegrationServiceId() {
        return this.integrationServiceId;
    }

    public void setIntegrationServiceId(int integrationServiceId) {
        this.integrationServiceId = integrationServiceId;
    }

    public ComponentDevelopmentStatus getIntegrationServiceDevelopmentStatus() {
        return this.integrationServiceDevelopmentStatus;
    }

    public void setIntegrationServiceDevelopmentStatus(ComponentDevelopmentStatus integrationServiceDevelopmentStatus) {
        this.integrationServiceDevelopmentStatus = integrationServiceDevelopmentStatus;
    }

    public String getIntegrationServiceContextManagerClass() {
        return this.integrationServiceContextManagerClass;
    }

    public void setIntegrationServiceContextManagerClass(String integrationServiceContextManagerClass) {
        this.integrationServiceContextManagerClass = integrationServiceContextManagerClass;
    }

    public String getIntegrationServiceName() {
        return this.integrationServiceName;
    }

    public void setIntegrationServiceFullName(String integrationServiceFullName) {
        this.integrationServiceFullName = integrationServiceFullName;
    }

    public void setIntegrationServiceName(String integrationServiceName) {
        this.integrationServiceName = integrationServiceName;
    }

    public String getIntegrationServiceFullName() {
        return this.integrationServiceFullName;
    }

    public String getIntegrationServiceURLMarker() {
        return this.integrationServiceURLMarker;
    }

    public void setIntegrationServiceURLMarker(String integrationServiceURLMarker) {
        this.integrationServiceURLMarker = integrationServiceURLMarker;
    }

    public String getIntegrationServiceDescription() {
        return this.integrationServiceDescription;
    }

    public void setIntegrationServiceDescription(String integrationServiceDescription) {
        this.integrationServiceDescription = integrationServiceDescription;
    }

    public String getIntegrationServiceWiki() {
        return this.integrationServiceWiki;
    }

    public void setIntegrationServiceWiki(String integrationServiceWiki) {
        this.integrationServiceWiki = integrationServiceWiki;
    }

    public String getIntegrationServicePartnerOMAS() {
        return this.integrationServicePartnerOMAS;
    }

    public void setIntegrationServicePartnerOMAS(String integrationServicePartnerOMAS) {
        this.integrationServicePartnerOMAS = integrationServicePartnerOMAS;
    }

    public PermittedSynchronization getDefaultPermittedSynchronization() {
        return this.defaultPermittedSynchronization;
    }

    public void setDefaultPermittedSynchronization(PermittedSynchronization defaultPermittedSynchronization) {
        this.defaultPermittedSynchronization = defaultPermittedSynchronization;
    }

    public ServiceOperationalStatus getIntegrationServiceOperationalStatus() {
        return this.integrationServiceOperationalStatus;
    }

    public void setIntegrationServiceOperationalStatus(ServiceOperationalStatus integrationServiceOperationalStatus) {
        this.integrationServiceOperationalStatus = integrationServiceOperationalStatus;
    }

    public List<IntegrationConnectorConfig> getIntegrationConnectorConfigs() {
        return this.integrationConnectorConfigs;
    }

    public void setIntegrationConnectorConfigs(List<IntegrationConnectorConfig> integrationConnectorConfigs) {
        this.integrationConnectorConfigs = integrationConnectorConfigs;
    }

    public Map<String, Object> getIntegrationServiceOptions() {
        if (this.integrationServiceOptions == null) {
            return null;
        }
        if (this.integrationServiceOptions.isEmpty()) {
            return null;
        }
        return this.integrationServiceOptions;
    }

    public void setIntegrationServiceOptions(Map<String, Object> integrationServiceOptions) {
        this.integrationServiceOptions = integrationServiceOptions;
    }

    @Override
    public String toString() {
        return "IntegrationServiceConfig{integrationServiceId=" + this.integrationServiceId + ", integrationServiceDevelopmentStatus=" + this.integrationServiceDevelopmentStatus + ", integrationServiceContextManagerClass='" + this.integrationServiceContextManagerClass + "', integrationServiceName='" + this.integrationServiceName + "', integrationServiceFullName='" + this.integrationServiceFullName + "', integrationServiceURLMarker='" + this.integrationServiceURLMarker + "', integrationServiceDescription='" + this.integrationServiceDescription + "', integrationServiceWiki='" + this.integrationServiceWiki + "', integrationServicePartnerOMAS='" + this.integrationServicePartnerOMAS + "', defaultPermittedSynchronization=" + this.defaultPermittedSynchronization + ", integrationServiceOperationalStatus=" + this.integrationServiceOperationalStatus + ", integrationServiceOptions=" + this.integrationServiceOptions + ", integrationConnectorConfigs=" + this.integrationConnectorConfigs + ", OMAGServerPlatformRootURL='" + this.getOMAGServerPlatformRootURL() + "', OMAGServerName='" + this.getOMAGServerName() + "'}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        IntegrationServiceConfig that = (IntegrationServiceConfig)objectToCompare;
        return this.integrationServiceId == that.integrationServiceId && this.integrationServiceDevelopmentStatus == that.integrationServiceDevelopmentStatus && Objects.equals(this.integrationServiceContextManagerClass, that.integrationServiceContextManagerClass) && Objects.equals(this.integrationServiceName, that.integrationServiceName) && Objects.equals(this.integrationServiceFullName, that.integrationServiceFullName) && Objects.equals(this.integrationServiceURLMarker, that.integrationServiceURLMarker) && Objects.equals(this.integrationServiceDescription, that.integrationServiceDescription) && Objects.equals(this.integrationServiceWiki, that.integrationServiceWiki) && Objects.equals(this.integrationServicePartnerOMAS, that.integrationServicePartnerOMAS) && this.defaultPermittedSynchronization == that.defaultPermittedSynchronization && this.integrationServiceOperationalStatus == that.integrationServiceOperationalStatus && Objects.equals(this.integrationServiceOptions, that.integrationServiceOptions) && Objects.equals(this.integrationConnectorConfigs, that.integrationConnectorConfigs);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.integrationServiceId, this.integrationServiceDevelopmentStatus, this.integrationServiceContextManagerClass, this.integrationServiceName, this.integrationServiceFullName, this.integrationServiceURLMarker, this.integrationServiceDescription, this.integrationServiceWiki, this.integrationServicePartnerOMAS, this.defaultPermittedSynchronization, this.integrationServiceOperationalStatus, this.integrationServiceOptions, this.integrationConnectorConfigs);
    }
}

