/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.configuration.registration;

import java.io.Serializable;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDevelopmentStatus;

public enum EngineServiceDescription implements Serializable
{
    ASSET_ANALYSIS_OMES(400, ComponentDevelopmentStatus.IN_DEVELOPMENT, "Asset Analysis", "Asset Analysis OMES", "asset-analysis", "Analyses the content of an asset's real world counterpart, generates annotations in an open discovery report that is attached to the asset in the open metadata repositories.", "https://egeria-project.org/services/omes/asset-analysis/overview/", "Discovery Engine OMAS"),
    GOVERNANCE_ACTION_OMES(401, ComponentDevelopmentStatus.IN_DEVELOPMENT, "Governance Action", "Governance Action OMES", "governance-action", "Executes requested governance action services to monitor, assess and maintain metadata and its real-world counterparts.", "https://egeria-project.org/services/omes/governance-action/overview/", "Governance Engine OMAS"),
    REPOSITORY_GOVERNANCE_OMES(402, ComponentDevelopmentStatus.IN_DEVELOPMENT, "Repository Governance", "Repository Governance OMES", "repository-governance", "Dynamically governance open metadata repositories in the connected cohorts.", "https://egeria-project.org/services/omes/repository-governance/overview/", "Open Metadata Repository Services (OMRS)");

    private static final long serialVersionUID = 1L;
    private final int engineServiceCode;
    private final ComponentDevelopmentStatus engineServiceDevelopmentStatus;
    private final String engineServiceName;
    private final String engineServiceFullName;
    private final String engineServiceURLMarker;
    private final String engineServiceDescription;
    private final String engineServiceWiki;
    private final String engineServicePartnerService;

    private EngineServiceDescription(int engineServiceCode, ComponentDevelopmentStatus engineServiceDevelopmentStatus, String engineServiceName, String engineServiceFullName, String engineServiceURLMarker, String engineServiceDescription, String engineServiceWiki, String engineServicePartnerService) {
        this.engineServiceCode = engineServiceCode;
        this.engineServiceDevelopmentStatus = engineServiceDevelopmentStatus;
        this.engineServiceName = engineServiceName;
        this.engineServiceFullName = engineServiceFullName;
        this.engineServiceURLMarker = engineServiceURLMarker;
        this.engineServiceDescription = engineServiceDescription;
        this.engineServiceWiki = engineServiceWiki;
        this.engineServicePartnerService = engineServicePartnerService;
    }

    public static EngineServiceDescription getEngineServiceDefinition(int engineServiceCode) {
        for (EngineServiceDescription description : EngineServiceDescription.values()) {
            if (engineServiceCode != description.getEngineServiceCode()) continue;
            return description;
        }
        return null;
    }

    public int getEngineServiceCode() {
        return this.engineServiceCode;
    }

    public ComponentDevelopmentStatus getEngineServiceDevelopmentStatus() {
        return this.engineServiceDevelopmentStatus;
    }

    public String getEngineServiceName() {
        return this.engineServiceName;
    }

    public String getEngineServiceFullName() {
        return this.engineServiceFullName;
    }

    public String getEngineServiceURLMarker() {
        return this.engineServiceURLMarker;
    }

    public String getEngineServiceDescription() {
        return this.engineServiceDescription;
    }

    public String getEngineServiceWiki() {
        return this.engineServiceWiki;
    }

    public String getEngineServicePartnerService() {
        return this.engineServicePartnerService;
    }
}

