/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.configuration.registration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDevelopmentStatus;

public enum CommonServicesDescription implements Serializable
{
    REPOSITORY_SERVICES(180, ComponentDevelopmentStatus.STABLE, "Open Metadata Repository Services (OMRS)", "repository-services", "Manages the synchronization, retrieval and maintenance of metadata stored in open metadata repositories", "https://egeria-project.org/services/omrs"),
    ADMIN_OPERATIONAL_SERVICES(181, ComponentDevelopmentStatus.STABLE, "OMAG Server Operational Services", "admin-services", "Management of services active in an Open Metadata and governance server (OMAG Server)", "https://egeria-project.org/services/admin-services/overview"),
    OCF_METADATA_MANAGEMENT(182, ComponentDevelopmentStatus.STABLE, "Connected Asset Services", "connected-asset", "Common metadata services for the Open Connector Framework (OCF)", "https://egeria-project.org/services/ocf-metadata-management"),
    OPEN_METADATA_SECURITY(183, ComponentDevelopmentStatus.STABLE, "Open Metadata Security Services", null, "Authorization services for Open Metadata and Governance", "https://egeria-project.org/services/metadata-security-services"),
    GAF_METADATA_MANAGEMENT(184, ComponentDevelopmentStatus.STABLE, "Open Metadata Store Services", "open-metadata-store", "Provides generic open metadata retrieval and management services for Open Metadata Access Services (OMASs).", "https://egeria-project.org/services/gaf-metadata-management"),
    PLATFORM_SERVICES(185, ComponentDevelopmentStatus.STABLE, "Platform Services", "platform-services", "Provides information about the registered services and connectors available in an OMAG Server Platform.", "https://egeria-project.org/services/platform-services/overview");

    private static final long serialVersionUID = 1L;
    private final int serviceCode;
    private final ComponentDevelopmentStatus serviceDevelopmentStatus;
    private final String serviceName;
    private final String serviceURLMarker;
    private final String serviceDescription;
    private final String serviceWiki;

    public static List<CommonServicesDescription> getGovernanceServersDescriptionList() {
        ArrayList<CommonServicesDescription> serviceDescriptionList = new ArrayList<CommonServicesDescription>();
        serviceDescriptionList.add(REPOSITORY_SERVICES);
        serviceDescriptionList.add(ADMIN_OPERATIONAL_SERVICES);
        serviceDescriptionList.add(OCF_METADATA_MANAGEMENT);
        serviceDescriptionList.add(GAF_METADATA_MANAGEMENT);
        serviceDescriptionList.add(OPEN_METADATA_SECURITY);
        serviceDescriptionList.add(PLATFORM_SERVICES);
        return serviceDescriptionList;
    }

    private CommonServicesDescription(int serviceCode, ComponentDevelopmentStatus serviceDevelopmentStatus, String serviceName, String serviceURLMarker, String serviceDescription, String serviceWiki) {
        this.serviceCode = serviceCode;
        this.serviceDevelopmentStatus = serviceDevelopmentStatus;
        this.serviceName = serviceName;
        this.serviceURLMarker = serviceURLMarker;
        this.serviceDescription = serviceDescription;
        this.serviceWiki = serviceWiki;
    }

    public int getServiceCode() {
        return this.serviceCode;
    }

    public ComponentDevelopmentStatus getServiceDevelopmentStatus() {
        return this.serviceDevelopmentStatus;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServiceURLMarker() {
        return this.serviceURLMarker;
    }

    public String getServiceDescription() {
        return this.serviceDescription;
    }

    public String getServiceWiki() {
        return this.serviceWiki;
    }
}

