/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.configuration.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.adminservices.configuration.properties.EngineConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerClientConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.EngineServiceRegistration;
import org.odpi.openmetadata.adminservices.configuration.registration.ServiceOperationalStatus;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDevelopmentStatus;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class EngineServiceConfig
extends OMAGServerClientConfig {
    private static final long serialVersionUID = 1L;
    private int engineServiceId = 0;
    private ComponentDevelopmentStatus engineServiceDevelopmentStatus = null;
    private String engineServiceName = null;
    private String engineServiceFullName = null;
    private String engineServiceURLMarker = null;
    private String engineServiceDescription = null;
    private String engineServiceWiki = null;
    private String engineServicePartnerOMAS = null;
    private Map<String, Object> engineServiceOptions = null;
    private List<EngineConfig> engines = null;
    private ServiceOperationalStatus engineServiceOperationalStatus = null;
    private String engineServiceAdminClass = null;

    public EngineServiceConfig() {
    }

    public EngineServiceConfig(EngineServiceConfig template) {
        super(template);
        if (template != null) {
            this.engineServiceId = template.getEngineServiceId();
            this.engineServiceDevelopmentStatus = template.getEngineServiceDevelopmentStatus();
            this.engineServiceAdminClass = template.getEngineServiceAdminClass();
            this.engineServiceName = template.getEngineServiceName();
            this.engineServiceFullName = template.getEngineServiceFullName();
            this.engineServiceURLMarker = template.getEngineServiceURLMarker();
            this.engineServiceDescription = template.getEngineServiceDescription();
            this.engineServiceWiki = template.getEngineServiceWiki();
            this.engineServicePartnerOMAS = template.getEngineServicePartnerOMAS();
            this.engineServiceOperationalStatus = template.getEngineServiceOperationalStatus();
            this.engineServiceOptions = template.getEngineServiceOptions();
            this.engines = template.getEngines();
        }
    }

    public EngineServiceConfig(EngineServiceRegistration template) {
        if (template != null) {
            this.engineServiceId = template.getEngineServiceId();
            this.engineServiceDevelopmentStatus = template.getEngineServiceDevelopmentStatus();
            this.engineServiceAdminClass = template.getEngineServiceAdminClass();
            this.engineServiceName = template.getEngineServiceName();
            this.engineServiceFullName = template.getEngineServiceFullName();
            this.engineServiceURLMarker = template.getEngineServiceURLMarker();
            this.engineServiceDescription = template.getEngineServiceDescription();
            this.engineServiceWiki = template.getEngineServiceWiki();
            this.engineServicePartnerOMAS = template.getEngineServicePartnerOMAS();
            this.engineServiceOperationalStatus = template.getEngineServiceOperationalStatus();
        }
    }

    public int getEngineServiceId() {
        return this.engineServiceId;
    }

    public void setEngineServiceId(int engineServiceId) {
        this.engineServiceId = engineServiceId;
    }

    public ComponentDevelopmentStatus getEngineServiceDevelopmentStatus() {
        return this.engineServiceDevelopmentStatus;
    }

    public void setEngineServiceDevelopmentStatus(ComponentDevelopmentStatus engineServiceDevelopmentStatus) {
        this.engineServiceDevelopmentStatus = engineServiceDevelopmentStatus;
    }

    public String getEngineServiceAdminClass() {
        return this.engineServiceAdminClass;
    }

    public void setEngineServiceAdminClass(String engineServiceAdminClass) {
        this.engineServiceAdminClass = engineServiceAdminClass;
    }

    public String getEngineServiceName() {
        return this.engineServiceName;
    }

    public void setEngineServiceFullName(String engineServiceFullName) {
        this.engineServiceFullName = engineServiceFullName;
    }

    public void setEngineServiceName(String engineServiceName) {
        this.engineServiceName = engineServiceName;
    }

    public String getEngineServiceFullName() {
        return this.engineServiceFullName;
    }

    public String getEngineServiceURLMarker() {
        return this.engineServiceURLMarker;
    }

    public void setEngineServiceURLMarker(String engineServiceURLMarker) {
        this.engineServiceURLMarker = engineServiceURLMarker;
    }

    public String getEngineServiceDescription() {
        return this.engineServiceDescription;
    }

    public void setEngineServiceDescription(String engineServiceDescription) {
        this.engineServiceDescription = engineServiceDescription;
    }

    public String getEngineServiceWiki() {
        return this.engineServiceWiki;
    }

    public void setEngineServiceWiki(String engineServiceWiki) {
        this.engineServiceWiki = engineServiceWiki;
    }

    public String getEngineServicePartnerOMAS() {
        return this.engineServicePartnerOMAS;
    }

    public void setEngineServicePartnerOMAS(String engineServicePartnerOMAS) {
        this.engineServicePartnerOMAS = engineServicePartnerOMAS;
    }

    public ServiceOperationalStatus getEngineServiceOperationalStatus() {
        return this.engineServiceOperationalStatus;
    }

    public void setEngineServiceOperationalStatus(ServiceOperationalStatus engineServiceOperationalStatus) {
        this.engineServiceOperationalStatus = engineServiceOperationalStatus;
    }

    public Map<String, Object> getEngineServiceOptions() {
        if (this.engineServiceOptions == null) {
            return null;
        }
        if (this.engineServiceOptions.isEmpty()) {
            return null;
        }
        return this.engineServiceOptions;
    }

    public void setEngineServiceOptions(Map<String, Object> engineServiceOptions) {
        this.engineServiceOptions = engineServiceOptions;
    }

    public List<EngineConfig> getEngines() {
        return this.engines;
    }

    public void setEngines(List<EngineConfig> engines) {
        this.engines = engines;
    }

    @Override
    public String toString() {
        return "EngineServiceConfig{engineServiceId=" + this.engineServiceId + ", engineServiceDevelopmentStatus=" + this.engineServiceDevelopmentStatus + ", engineServiceName='" + this.engineServiceName + "', engineServiceFullName='" + this.engineServiceFullName + "', engineServiceURLMarker='" + this.engineServiceURLMarker + "', engineServiceDescription='" + this.engineServiceDescription + "', engineServiceWiki='" + this.engineServiceWiki + "', engineServicePartnerOMAS='" + this.engineServicePartnerOMAS + "', engineServiceOptions=" + this.engineServiceOptions + ", engines=" + this.engines + ", engineServiceOperationalStatus=" + this.engineServiceOperationalStatus + ", engineServiceAdminClass='" + this.engineServiceAdminClass + "', OMAGServerPlatformRootURL='" + this.getOMAGServerPlatformRootURL() + "', OMAGServerName='" + this.getOMAGServerName() + "'}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        EngineServiceConfig that = (EngineServiceConfig)objectToCompare;
        return this.engineServiceId == that.engineServiceId && this.engineServiceDevelopmentStatus == that.engineServiceDevelopmentStatus && Objects.equals(this.engineServiceName, that.engineServiceName) && Objects.equals(this.engineServiceFullName, that.engineServiceFullName) && Objects.equals(this.engineServiceURLMarker, that.engineServiceURLMarker) && Objects.equals(this.engineServiceDescription, that.engineServiceDescription) && Objects.equals(this.engineServiceWiki, that.engineServiceWiki) && Objects.equals(this.engineServicePartnerOMAS, that.engineServicePartnerOMAS) && Objects.equals(this.engineServiceOptions, that.engineServiceOptions) && Objects.equals(this.engines, that.engines) && this.engineServiceOperationalStatus == that.engineServiceOperationalStatus && Objects.equals(this.engineServiceAdminClass, that.engineServiceAdminClass);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.engineServiceId, this.engineServiceDevelopmentStatus, this.engineServiceName, this.engineServiceFullName, this.engineServiceURLMarker, this.engineServiceDescription, this.engineServiceWiki, this.engineServicePartnerOMAS, this.engineServiceOptions, this.engines, this.engineServiceOperationalStatus, this.engineServiceAdminClass);
    }
}

