/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.configuration.registration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDevelopmentStatus;

public enum GovernanceServicesDescription implements Serializable
{
    OPEN_LINEAGE_SERVICES(190, ComponentDevelopmentStatus.STABLE, "Open Lineage Services", "open-lineage", "Store and query asset lineage", "https://egeria-project.org/services/open-lineage-services/"),
    CONFORMANCE_SUITE_SERVICES(191, ComponentDevelopmentStatus.STABLE, "Conformance Suite Services", "conformance-suite", "Run automated open metadata conformance suite services", "https://egeria-project.org/guides/cts/overview/"),
    DATA_ENGINE_PROXY_SERVICES(192, ComponentDevelopmentStatus.STABLE, "Data Engine Proxy Services", null, "Integrate Data Engines that are not self-capable of integrating directly with the Data Engine OMAS", "https://egeria-project.org/services/data-engine-proxy-services/"),
    INTEGRATION_DAEMON_SERVICES(193, ComponentDevelopmentStatus.TECHNICAL_PREVIEW, "Integration Daemon Services", null, "Host one or more integration services that are exchanging metadata with third party technologies", "https://egeria-project.org/services/integration-daemon-services/"),
    ENGINE_HOST_SERVICES(194, ComponentDevelopmentStatus.TECHNICAL_PREVIEW, "Engine Host Services", null, "Host one or more engine services that are actively managing governance of open metadata and the digital landscape", "https://egeria-project.org/services/engine-host-services/");

    private static final long serialVersionUID = 1L;
    private int serviceCode;
    private ComponentDevelopmentStatus serviceDevelopmentStatus;
    private String serviceName;
    private String serviceURLMarker;
    private String serviceDescription;
    private String serviceWiki;

    public static List<GovernanceServicesDescription> getGovernanceServersDescriptionList() {
        ArrayList<GovernanceServicesDescription> serviceDescriptionList = new ArrayList<GovernanceServicesDescription>();
        serviceDescriptionList.add(OPEN_LINEAGE_SERVICES);
        serviceDescriptionList.add(INTEGRATION_DAEMON_SERVICES);
        serviceDescriptionList.add(CONFORMANCE_SUITE_SERVICES);
        serviceDescriptionList.add(DATA_ENGINE_PROXY_SERVICES);
        return serviceDescriptionList;
    }

    public static Set<String> getGovernanceServersURLMarkers() {
        HashSet<String> urlMarkerSet = new HashSet<String>();
        for (GovernanceServicesDescription governanceServicesDescription : GovernanceServicesDescription.getGovernanceServersDescriptionList()) {
            String urlMarker = governanceServicesDescription.getServiceURLMarker();
            if (urlMarker == null) continue;
            urlMarkerSet.add(urlMarker);
        }
        return urlMarkerSet;
    }

    private GovernanceServicesDescription(int serviceCode, ComponentDevelopmentStatus serviceDevelopmentStatus, String serviceName, String serviceURLMarker, String serviceDescription, String serviceWiki) {
        this.serviceCode = serviceCode;
        this.serviceDevelopmentStatus = serviceDevelopmentStatus;
        this.serviceName = serviceName;
        this.serviceURLMarker = serviceURLMarker;
        this.serviceDescription = serviceDescription;
        this.serviceWiki = serviceWiki;
    }

    public int getServiceCode() {
        return this.serviceCode;
    }

    public ComponentDevelopmentStatus getServiceDevelopmentStatus() {
        return this.serviceDevelopmentStatus;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServiceURLMarker() {
        return this.serviceURLMarker;
    }

    public String getServiceDescription() {
        return this.serviceDescription;
    }

    public String getServiceWiki() {
        return this.serviceWiki;
    }
}

