/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.configuration.registration;

import java.io.Serializable;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.ServiceOperationalStatus;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDevelopmentStatus;

public class AccessServiceRegistrationEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String defaultTopicRoot = "omas.";
    private static final String defaultInTopicLeaf = ".inTopic";
    private static final String defaultOutTopicLeaf = ".outTopic";
    private int accessServiceCode;
    private ComponentDevelopmentStatus accessServiceDevelopmentStatus = null;
    private String accessServiceName;
    private String accessServiceFullName;
    private String accessServiceURLMarker;
    private String accessServiceDescription;
    private String accessServiceWiki;
    private ServiceOperationalStatus accessServiceOperationalStatus;
    private String accessServiceAdminClassName;

    public AccessServiceRegistrationEntry(int accessServiceCode, ComponentDevelopmentStatus accessServiceDevelopmentStatus, String accessServiceName, String accessServiceFullName, String accessServiceURLMarker, String accessServiceDescription, String accessServiceWiki, ServiceOperationalStatus accessServiceOperationalStatus, String accessServiceAdminClassName) {
        this.accessServiceCode = accessServiceCode;
        this.accessServiceDevelopmentStatus = accessServiceDevelopmentStatus;
        this.accessServiceName = accessServiceName;
        this.accessServiceFullName = accessServiceFullName;
        this.accessServiceURLMarker = accessServiceURLMarker;
        this.accessServiceDescription = accessServiceDescription;
        this.accessServiceWiki = accessServiceWiki;
        this.accessServiceOperationalStatus = accessServiceOperationalStatus;
        this.accessServiceAdminClassName = accessServiceAdminClassName;
    }

    public AccessServiceRegistrationEntry(AccessServiceDescription accessServiceDescription, ServiceOperationalStatus accessServiceOperationalStatus, String accessServiceAdminClassName) {
        this(accessServiceDescription.getAccessServiceCode(), accessServiceDescription.getAccessServiceDevelopmentStatus(), accessServiceDescription.getAccessServiceName(), accessServiceDescription.getAccessServiceFullName(), accessServiceDescription.getAccessServiceURLMarker(), accessServiceDescription.getAccessServiceDescription(), accessServiceDescription.getAccessServiceWiki(), accessServiceOperationalStatus, accessServiceAdminClassName);
    }

    public AccessServiceRegistrationEntry() {
    }

    public int getAccessServiceCode() {
        return this.accessServiceCode;
    }

    public void setAccessServiceCode(int accessServiceCode) {
        this.accessServiceCode = accessServiceCode;
    }

    public ComponentDevelopmentStatus getAccessServiceDevelopmentStatus() {
        return this.accessServiceDevelopmentStatus;
    }

    public void setAccessServiceDevelopmentStatus(ComponentDevelopmentStatus accessServiceDevelopmentStatus) {
        this.accessServiceDevelopmentStatus = accessServiceDevelopmentStatus;
    }

    public String getAccessServiceName() {
        return this.accessServiceName;
    }

    public void setAccessServiceName(String accessServiceName) {
        this.accessServiceName = accessServiceName;
    }

    public String getAccessServiceFullName() {
        return this.accessServiceFullName;
    }

    public void setAccessServiceFullName(String accessServiceFullName) {
        this.accessServiceFullName = accessServiceFullName;
    }

    public String getAccessServiceURLMarker() {
        return this.accessServiceURLMarker;
    }

    public void setServiceURLMarker(String accessServiceURLMarker) {
        this.accessServiceURLMarker = accessServiceURLMarker;
    }

    public String getAccessServiceDescription() {
        return this.accessServiceDescription;
    }

    public void setAccessServiceDescription(String accessServiceDescription) {
        this.accessServiceDescription = accessServiceDescription;
    }

    public String getAccessServiceWiki() {
        return this.accessServiceWiki;
    }

    public void setAccessServiceWiki(String accessServiceWiki) {
        this.accessServiceWiki = accessServiceWiki;
    }

    public ServiceOperationalStatus getAccessServiceOperationalStatus() {
        return this.accessServiceOperationalStatus;
    }

    public void setAccessServiceOperationalStatus(ServiceOperationalStatus accessServiceOperationalStatus) {
        this.accessServiceOperationalStatus = accessServiceOperationalStatus;
    }

    public String getAccessServiceAdminClassName() {
        return this.accessServiceAdminClassName;
    }

    public void setAccessServiceAdminClassName(String accessServiceAdminClassName) {
        this.accessServiceAdminClassName = accessServiceAdminClassName;
    }

    public String getAccessServiceInTopic() {
        return defaultTopicRoot + this.accessServiceURLMarker.replaceAll("-", "") + defaultInTopicLeaf;
    }

    public String getAccessServiceOutTopic() {
        return defaultTopicRoot + this.accessServiceURLMarker.replaceAll("-", "") + defaultOutTopicLeaf;
    }
}

