/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.configuration.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.AdminServicesConfigHeader;
import org.odpi.openmetadata.adminservices.configuration.properties.ConformanceSuiteConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.DataEngineProxyConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.EngineHostServicesConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.EventBusConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.IntegrationGroupConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.IntegrationServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OpenLineageServerConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.RepositoryServicesConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.ViewServiceConfig;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class OMAGServerConfig
extends AdminServicesConfigHeader {
    private static final long serialVersionUID = 1L;
    public static final String VERSION_ONE = "V1.0";
    public static final String VERSION_TWO = "V2.0";
    public static final List<String> COMPATIBLE_VERSIONS = new ArrayList<String>(Arrays.asList("V2.0"));
    public static final String defaultLocalServerType = "Open Metadata and Governance Server";
    private static final String defaultLocalOrganizationName = null;
    private static final String defaultLocalServerURL = "https://localhost:9443";
    private static final String defaultLocalServerUserId = "OMAGServer";
    private static final int defaultMaxPageSize = 1000;
    private String versionId = null;
    private String localServerId = UUID.randomUUID().toString();
    private String localServerName = null;
    private String localServerDescription = null;
    private String localServerType = null;
    private String organizationName = defaultLocalOrganizationName;
    private String localServerURL = "https://localhost:9443";
    private String localServerUserId = "OMAGServer";
    private String localServerPassword = null;
    private int maxPageSize = 1000;
    private Connection serverSecurityConnection = null;
    private EventBusConfig eventBusConfig = null;
    private List<AccessServiceConfig> accessServicesConfig = null;
    private List<IntegrationServiceConfig> integrationServicesConfig = null;
    private List<IntegrationGroupConfig> dynamicIntegrationGroupsConfig = null;
    private List<ViewServiceConfig> viewServicesConfig = null;
    private RepositoryServicesConfig repositoryServicesConfig = null;
    private ConformanceSuiteConfig conformanceSuiteConfig = null;
    private EngineHostServicesConfig engineHostServicesConfig = null;
    private OpenLineageServerConfig openLineageServerConfig = null;
    private DataEngineProxyConfig dataEngineProxyConfig = null;
    private List<String> auditTrail = null;

    public OMAGServerConfig() {
    }

    public OMAGServerConfig(OMAGServerConfig template) {
        super(template);
        if (template != null) {
            this.versionId = template.getVersionId();
            this.localServerId = template.getLocalServerId();
            this.localServerName = template.getLocalServerName();
            this.localServerDescription = template.getLocalServerDescription();
            this.localServerType = template.getLocalServerType();
            this.organizationName = template.getOrganizationName();
            this.localServerURL = template.getLocalServerURL();
            this.localServerUserId = template.getLocalServerUserId();
            this.localServerPassword = template.getLocalServerPassword();
            this.maxPageSize = template.getMaxPageSize();
            this.serverSecurityConnection = template.getServerSecurityConnection();
            this.eventBusConfig = template.getEventBusConfig();
            this.accessServicesConfig = template.getAccessServicesConfig();
            this.integrationServicesConfig = template.getIntegrationServicesConfig();
            this.dynamicIntegrationGroupsConfig = template.getDynamicIntegrationGroupsConfig();
            this.engineHostServicesConfig = template.getEngineHostServicesConfig();
            this.viewServicesConfig = template.getViewServicesConfig();
            this.repositoryServicesConfig = template.getRepositoryServicesConfig();
            this.conformanceSuiteConfig = template.getConformanceSuiteConfig();
            this.openLineageServerConfig = template.getOpenLineageServerConfig();
            this.dataEngineProxyConfig = template.getDataEngineProxyConfig();
            this.auditTrail = template.getAuditTrail();
        }
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public String getLocalServerId() {
        return this.localServerId;
    }

    public void setLocalServerId(String localServerId) {
        this.localServerId = localServerId;
    }

    public String getLocalServerDescription() {
        return this.localServerDescription;
    }

    public void setLocalServerDescription(String localServerDescription) {
        this.localServerDescription = localServerDescription;
    }

    public String getLocalServerName() {
        return this.localServerName;
    }

    public void setLocalServerName(String localServerName) {
        this.localServerName = localServerName;
    }

    public String getLocalServerType() {
        return this.localServerType;
    }

    public void setLocalServerType(String localServerType) {
        this.localServerType = localServerType;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public String getLocalServerURL() {
        return this.localServerURL;
    }

    public void setLocalServerURL(String localServerURL) {
        this.localServerURL = localServerURL;
    }

    public String getLocalServerUserId() {
        return this.localServerUserId;
    }

    public void setLocalServerUserId(String localServerUserId) {
        this.localServerUserId = localServerUserId;
    }

    public String getLocalServerPassword() {
        return this.localServerPassword;
    }

    public void setLocalServerPassword(String localServerPassword) {
        this.localServerPassword = localServerPassword;
    }

    public int getMaxPageSize() {
        return this.maxPageSize;
    }

    public void setMaxPageSize(int maxPageSize) {
        this.maxPageSize = maxPageSize;
    }

    public Connection getServerSecurityConnection() {
        return this.serverSecurityConnection;
    }

    public void setServerSecurityConnection(Connection serverSecurityConnection) {
        this.serverSecurityConnection = serverSecurityConnection;
    }

    public EventBusConfig getEventBusConfig() {
        return this.eventBusConfig;
    }

    public void setEventBusConfig(EventBusConfig eventBusConfig) {
        this.eventBusConfig = eventBusConfig;
    }

    public List<AccessServiceConfig> getAccessServicesConfig() {
        return this.accessServicesConfig;
    }

    public void setAccessServicesConfig(List<AccessServiceConfig> accessServicesConfig) {
        this.accessServicesConfig = accessServicesConfig;
    }

    public List<IntegrationServiceConfig> getIntegrationServicesConfig() {
        return this.integrationServicesConfig;
    }

    public void setIntegrationServicesConfig(List<IntegrationServiceConfig> integrationServicesConfig) {
        this.integrationServicesConfig = integrationServicesConfig;
    }

    public List<IntegrationGroupConfig> getDynamicIntegrationGroupsConfig() {
        return this.dynamicIntegrationGroupsConfig;
    }

    public void setDynamicIntegrationGroupsConfig(List<IntegrationGroupConfig> dynamicIntegrationGroupsConfig) {
        this.dynamicIntegrationGroupsConfig = dynamicIntegrationGroupsConfig;
    }

    public List<ViewServiceConfig> getViewServicesConfig() {
        return this.viewServicesConfig;
    }

    public void setViewServicesConfig(List<ViewServiceConfig> viewServicesConfig) {
        this.viewServicesConfig = viewServicesConfig;
    }

    public RepositoryServicesConfig getRepositoryServicesConfig() {
        return this.repositoryServicesConfig;
    }

    public void setRepositoryServicesConfig(RepositoryServicesConfig repositoryServicesConfig) {
        this.repositoryServicesConfig = repositoryServicesConfig;
    }

    public ConformanceSuiteConfig getConformanceSuiteConfig() {
        return this.conformanceSuiteConfig;
    }

    public void setConformanceSuiteConfig(ConformanceSuiteConfig conformanceSuiteConfig) {
        this.conformanceSuiteConfig = conformanceSuiteConfig;
    }

    public EngineHostServicesConfig getEngineHostServicesConfig() {
        return this.engineHostServicesConfig;
    }

    public void setEngineHostServicesConfig(EngineHostServicesConfig engineHostServicesConfig) {
        this.engineHostServicesConfig = engineHostServicesConfig;
    }

    public OpenLineageServerConfig getOpenLineageServerConfig() {
        return this.openLineageServerConfig;
    }

    public void setOpenLineageServerConfig(OpenLineageServerConfig openLineageServerConfig) {
        this.openLineageServerConfig = openLineageServerConfig;
    }

    public void setDataEngineProxyConfig(DataEngineProxyConfig dataEngineProxyConfig) {
        this.dataEngineProxyConfig = dataEngineProxyConfig;
    }

    public DataEngineProxyConfig getDataEngineProxyConfig() {
        return this.dataEngineProxyConfig;
    }

    public List<String> getAuditTrail() {
        return this.auditTrail;
    }

    public void setAuditTrail(List<String> auditTrail) {
        this.auditTrail = auditTrail;
    }

    public String toString() {
        return "OMAGServerConfig{versionId='" + this.versionId + "', localServerId='" + this.localServerId + "', localServerName='" + this.localServerName + "', localServerType='" + this.localServerType + "', organizationName='" + this.organizationName + "', localServerURL='" + this.localServerURL + "', localServerUserId='" + this.localServerUserId + "', localServerPassword='" + this.localServerPassword + "', maxPageSize=" + this.maxPageSize + ", serverSecurityConnection=" + this.serverSecurityConnection + ", eventBusConfig=" + this.eventBusConfig + ", accessServicesConfig=" + this.accessServicesConfig + ", integrationServicesConfig=" + this.integrationServicesConfig + ", engineHostServicesConfig=" + this.engineHostServicesConfig + ", viewServicesConfig=" + this.viewServicesConfig + ", repositoryServicesConfig=" + this.repositoryServicesConfig + ", conformanceSuiteConfig=" + this.conformanceSuiteConfig + ", openLineageServerConfig=" + this.openLineageServerConfig + ", dataEngineProxyConfig=" + this.dataEngineProxyConfig + ", auditTrail=" + this.auditTrail + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        OMAGServerConfig that = (OMAGServerConfig)objectToCompare;
        return this.getMaxPageSize() == that.getMaxPageSize() && Objects.equals(this.getVersionId(), that.getVersionId()) && Objects.equals(this.getLocalServerId(), that.getLocalServerId()) && Objects.equals(this.getLocalServerName(), that.getLocalServerName()) && Objects.equals(this.getLocalServerDescription(), that.getLocalServerDescription()) && Objects.equals(this.getLocalServerType(), that.getLocalServerType()) && Objects.equals(this.getOrganizationName(), that.getOrganizationName()) && Objects.equals(this.getLocalServerURL(), that.getLocalServerURL()) && Objects.equals(this.getLocalServerUserId(), that.getLocalServerUserId()) && Objects.equals(this.getLocalServerPassword(), that.getLocalServerPassword()) && Objects.equals(this.getServerSecurityConnection(), that.getServerSecurityConnection()) && Objects.equals(this.getEventBusConfig(), that.getEventBusConfig()) && Objects.equals(this.getAccessServicesConfig(), that.getAccessServicesConfig()) && Objects.equals(this.getIntegrationServicesConfig(), that.getIntegrationServicesConfig()) && Objects.equals(this.getEngineHostServicesConfig(), that.getEngineHostServicesConfig()) && Objects.equals(this.getViewServicesConfig(), that.getViewServicesConfig()) && Objects.equals(this.getRepositoryServicesConfig(), that.getRepositoryServicesConfig()) && Objects.equals(this.getConformanceSuiteConfig(), that.getConformanceSuiteConfig()) && Objects.equals(this.getOpenLineageServerConfig(), that.getOpenLineageServerConfig()) && Objects.equals(this.getDataEngineProxyConfig(), that.getDataEngineProxyConfig()) && Objects.equals(this.getAuditTrail(), that.getAuditTrail());
    }

    public int hashCode() {
        return Objects.hash(this.getVersionId(), this.getLocalServerId(), this.getLocalServerName(), this.getLocalServerDescription(), this.getLocalServerType(), this.getOrganizationName(), this.getLocalServerURL(), this.getLocalServerUserId(), this.getLocalServerPassword(), this.getMaxPageSize(), this.getServerSecurityConnection(), this.getEventBusConfig(), this.getAccessServicesConfig(), this.getIntegrationServicesConfig(), this.getEngineHostServicesConfig(), this.getViewServicesConfig(), this.getRepositoryServicesConfig(), this.getConformanceSuiteConfig(), this.getOpenLineageServerConfig(), this.getDataEngineProxyConfig(), this.getAuditTrail());
    }
}

