/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.configuration.registration;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.CommonServicesDescription;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDevelopmentStatus;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.DeployedImplementationType;

public enum EngineServiceDescription {
    ASSET_ANALYSIS_OMES(400, ComponentDevelopmentStatus.DEPRECATED, "Asset Analysis", "Asset Analysis OMES", "asset-analysis", "Analyses the content of an asset's real world counterpart (resource), generates annotations in a discovery analysis report that is attached to the asset in the open metadata repositories.", "https://egeria-project.org/services/omes/asset-analysis/overview/", AccessServiceDescription.DISCOVERY_ENGINE_OMAS.getAccessServiceFullName(), null, null, null, null),
    GOVERNANCE_ACTION_OMES(401, ComponentDevelopmentStatus.STABLE, "Governance Action", "Governance Action OMES", "governance-action", "Executes requested governance action services to monitor, assess and maintain metadata and its real-world counterparts.", "https://egeria-project.org/services/omes/governance-action/overview/", AccessServiceDescription.GOVERNANCE_ENGINE_OMAS.getAccessServiceFullName(), DeployedImplementationType.GOVERNANCE_ACTION_ENGINE.getAssociatedTypeName(), DeployedImplementationType.GOVERNANCE_ACTION_SERVICE_CONNECTOR.getAssociatedTypeName(), DeployedImplementationType.GOVERNANCE_ACTION_ENGINE.getDeployedImplementationType(), DeployedImplementationType.GOVERNANCE_ACTION_SERVICE_CONNECTOR.getDeployedImplementationType()),
    REPOSITORY_GOVERNANCE_OMES(402, ComponentDevelopmentStatus.IN_DEVELOPMENT, "Repository Governance", "Repository Governance OMES", "repository-governance", "Dynamically govern open metadata repositories in the connected cohorts.", "https://egeria-project.org/services/omes/repository-governance/overview/", CommonServicesDescription.REPOSITORY_SERVICES.getServiceName(), DeployedImplementationType.REPOSITORY_GOVERNANCE_ENGINE.getAssociatedTypeName(), DeployedImplementationType.REPOSITORY_GOVERNANCE_SERVICE_CONNECTOR.getAssociatedTypeName(), DeployedImplementationType.REPOSITORY_GOVERNANCE_ENGINE.getDeployedImplementationType(), DeployedImplementationType.REPOSITORY_GOVERNANCE_SERVICE_CONNECTOR.getDeployedImplementationType()),
    CONTEXT_EVENT_OMES(403, ComponentDevelopmentStatus.IN_DEVELOPMENT, "Context Event", "Context Event OMES", "context-event", "Executes requested context event services to monitor, assess and maintain context events.", "https://egeria-project.org/services/omes/context-event/overview/", AccessServiceDescription.GOVERNANCE_ENGINE_OMAS.getAccessServiceFullName(), DeployedImplementationType.CONTEXT_EVENT_ENGINE.getAssociatedTypeName(), DeployedImplementationType.CONTEXT_EVENT_SERVICE_CONNECTOR.getAssociatedTypeName(), DeployedImplementationType.CONTEXT_EVENT_ENGINE.getDeployedImplementationType(), DeployedImplementationType.CONTEXT_EVENT_SERVICE_CONNECTOR.getDeployedImplementationType()),
    SURVEY_ACTION_OMES(404, ComponentDevelopmentStatus.STABLE, "Survey Action", "Survey Action OMES", "survey-action", "Analyses the content of an asset's real world counterpart (resource), generates annotations in a survey report that is attached to the asset in the open metadata repositories.", "https://egeria-project.org/services/omes/survey-action/overview/", AccessServiceDescription.ASSET_OWNER_OMAS.getAccessServiceFullName(), DeployedImplementationType.SURVEY_ACTION_ENGINE.getAssociatedTypeName(), DeployedImplementationType.SURVEY_ACTION_SERVICE_CONNECTOR.getAssociatedTypeName(), DeployedImplementationType.SURVEY_ACTION_ENGINE.getDeployedImplementationType(), DeployedImplementationType.SURVEY_ACTION_SERVICE_CONNECTOR.getDeployedImplementationType());

    private final int engineServiceCode;
    private final ComponentDevelopmentStatus engineServiceDevelopmentStatus;
    private final String engineServiceName;
    private final String engineServiceFullName;
    private final String engineServiceURLMarker;
    private final String engineServiceDescription;
    private final String engineServiceWiki;
    private final String engineServicePartnerService;
    private final String hostedGovernanceEngineType;
    private final String hostedGovernanceServiceType;
    private final String hostedGovernanceEngineDeployedImplementationType;
    private final String hostedGovernanceServiceDeployedImplementationType;

    private EngineServiceDescription(int engineServiceCode, ComponentDevelopmentStatus engineServiceDevelopmentStatus, String engineServiceName, String engineServiceFullName, String engineServiceURLMarker, String engineServiceDescription, String engineServiceWiki, String engineServicePartnerService, String hostedGovernanceEngineType, String hostedGovernanceServiceType, String hostedGovernanceEngineDeployedImplementationType, String hostedGovernanceServiceDeployedImplementationType) {
        this.engineServiceCode = engineServiceCode;
        this.engineServiceDevelopmentStatus = engineServiceDevelopmentStatus;
        this.engineServiceName = engineServiceName;
        this.engineServiceFullName = engineServiceFullName;
        this.engineServiceURLMarker = engineServiceURLMarker;
        this.engineServiceDescription = engineServiceDescription;
        this.engineServiceWiki = engineServiceWiki;
        this.engineServicePartnerService = engineServicePartnerService;
        this.hostedGovernanceEngineType = hostedGovernanceEngineType;
        this.hostedGovernanceServiceType = hostedGovernanceServiceType;
        this.hostedGovernanceEngineDeployedImplementationType = hostedGovernanceEngineDeployedImplementationType;
        this.hostedGovernanceServiceDeployedImplementationType = hostedGovernanceServiceDeployedImplementationType;
    }

    public static EngineServiceDescription getEngineServiceDefinition(int engineServiceCode) {
        for (EngineServiceDescription description : EngineServiceDescription.values()) {
            if (engineServiceCode != description.getEngineServiceCode()) continue;
            return description;
        }
        return null;
    }

    public static List<String> getEngineServiceNames() {
        ArrayList<String> engineServiceNames = new ArrayList<String>();
        for (EngineServiceDescription serviceDescription : EngineServiceDescription.values()) {
            engineServiceNames.add(serviceDescription.getEngineServiceFullName());
        }
        return engineServiceNames;
    }

    public int getEngineServiceCode() {
        return this.engineServiceCode;
    }

    public ComponentDevelopmentStatus getEngineServiceDevelopmentStatus() {
        return this.engineServiceDevelopmentStatus;
    }

    public String getEngineServiceName() {
        return this.engineServiceName;
    }

    public String getEngineServiceFullName() {
        return this.engineServiceFullName;
    }

    public String getEngineServiceURLMarker() {
        return this.engineServiceURLMarker;
    }

    public String getEngineServiceDescription() {
        return this.engineServiceDescription;
    }

    public String getEngineServiceWiki() {
        return this.engineServiceWiki;
    }

    public String getEngineServicePartnerService() {
        return this.engineServicePartnerService;
    }

    public String getHostedGovernanceEngineType() {
        return this.hostedGovernanceEngineType;
    }

    public String getHostedGovernanceServiceType() {
        return this.hostedGovernanceServiceType;
    }

    public String getHostedGovernanceEngineDeployedImplementationType() {
        return this.hostedGovernanceEngineDeployedImplementationType;
    }

    public String getHostedGovernanceServiceDeployedImplementationType() {
        return this.hostedGovernanceServiceDeployedImplementationType;
    }
}

