/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.configuration.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.adminservices.configuration.properties.AdminServicesConfigHeader;
import org.odpi.openmetadata.adminservices.configuration.properties.OpenMetadataEventProtocolVersion;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class EnterpriseAccessConfig
extends AdminServicesConfigHeader {
    private String enterpriseMetadataCollectionName = null;
    private String enterpriseMetadataCollectionId = null;
    private Connection enterpriseOMRSTopicConnection = null;
    private OpenMetadataEventProtocolVersion enterpriseOMRSTopicProtocolVersion = null;
    private Connection remoteEnterpriseOMRSTopicConnection = null;

    public EnterpriseAccessConfig() {
    }

    public EnterpriseAccessConfig(EnterpriseAccessConfig template) {
        super(template);
        if (template != null) {
            this.enterpriseMetadataCollectionName = template.getEnterpriseMetadataCollectionName();
            this.enterpriseMetadataCollectionId = template.getEnterpriseMetadataCollectionId();
            this.enterpriseOMRSTopicConnection = template.getEnterpriseOMRSTopicConnection();
            this.enterpriseOMRSTopicProtocolVersion = template.getEnterpriseOMRSTopicProtocolVersion();
            this.remoteEnterpriseOMRSTopicConnection = template.getRemoteEnterpriseOMRSTopicConnection();
        }
    }

    public EnterpriseAccessConfig(String enterpriseMetadataCollectionName, String enterpriseMetadataCollectionId, Connection enterpriseOMRSTopicConnection, OpenMetadataEventProtocolVersion enterpriseOMRSTopicProtocolVersion, Connection remoteEnterpriseOMRSTopicConnection) {
        this.enterpriseMetadataCollectionName = enterpriseMetadataCollectionName;
        this.enterpriseMetadataCollectionId = enterpriseMetadataCollectionId;
        this.enterpriseOMRSTopicConnection = enterpriseOMRSTopicConnection;
        this.enterpriseOMRSTopicProtocolVersion = enterpriseOMRSTopicProtocolVersion;
        this.remoteEnterpriseOMRSTopicConnection = remoteEnterpriseOMRSTopicConnection;
    }

    public String getEnterpriseMetadataCollectionName() {
        return this.enterpriseMetadataCollectionName;
    }

    public void setEnterpriseMetadataCollectionName(String enterpriseMetadataCollectionName) {
        this.enterpriseMetadataCollectionName = enterpriseMetadataCollectionName;
    }

    public String getEnterpriseMetadataCollectionId() {
        return this.enterpriseMetadataCollectionId;
    }

    public void setEnterpriseMetadataCollectionId(String enterpriseMetadataCollectionId) {
        this.enterpriseMetadataCollectionId = enterpriseMetadataCollectionId;
    }

    public Connection getEnterpriseOMRSTopicConnection() {
        return this.enterpriseOMRSTopicConnection;
    }

    public void setEnterpriseOMRSTopicConnection(Connection enterpriseOMRSTopicConnection) {
        this.enterpriseOMRSTopicConnection = enterpriseOMRSTopicConnection;
    }

    public OpenMetadataEventProtocolVersion getEnterpriseOMRSTopicProtocolVersion() {
        return this.enterpriseOMRSTopicProtocolVersion;
    }

    public void setEnterpriseOMRSTopicProtocolVersion(OpenMetadataEventProtocolVersion enterpriseOMRSTopicProtocolVersion) {
        this.enterpriseOMRSTopicProtocolVersion = enterpriseOMRSTopicProtocolVersion;
    }

    public Connection getRemoteEnterpriseOMRSTopicConnection() {
        return this.remoteEnterpriseOMRSTopicConnection;
    }

    public void setRemoteEnterpriseOMRSTopicConnection(Connection remoteEnterpriseOMRSTopicConnection) {
        this.remoteEnterpriseOMRSTopicConnection = remoteEnterpriseOMRSTopicConnection;
    }

    public String toString() {
        return "EnterpriseAccessConfig{enterpriseMetadataCollectionName='" + this.enterpriseMetadataCollectionName + "', enterpriseMetadataCollectionId='" + this.enterpriseMetadataCollectionId + "', enterpriseOMRSTopicConnection=" + this.enterpriseOMRSTopicConnection + ", enterpriseOMRSTopicProtocolVersion=" + this.enterpriseOMRSTopicProtocolVersion + ", remoteEnterpriseOMRSTopicConnection=" + this.remoteEnterpriseOMRSTopicConnection + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        EnterpriseAccessConfig that = (EnterpriseAccessConfig)objectToCompare;
        return Objects.equals(this.enterpriseMetadataCollectionName, that.enterpriseMetadataCollectionName) && Objects.equals(this.enterpriseMetadataCollectionId, that.enterpriseMetadataCollectionId) && Objects.equals(this.enterpriseOMRSTopicConnection, that.enterpriseOMRSTopicConnection) && this.enterpriseOMRSTopicProtocolVersion == that.enterpriseOMRSTopicProtocolVersion && Objects.equals(this.remoteEnterpriseOMRSTopicConnection, that.remoteEnterpriseOMRSTopicConnection);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.enterpriseMetadataCollectionName, this.enterpriseMetadataCollectionId, this.enterpriseOMRSTopicConnection, this.enterpriseOMRSTopicProtocolVersion, this.remoteEnterpriseOMRSTopicConnection});
    }
}

