/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.configuration.registration;

import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.CommonServicesDescription;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDevelopmentStatus;

public enum ViewServiceDescription {
    GLOSSARY_AUTHOR(800, ComponentDevelopmentStatus.DEPRECATED, "Glossary Author", "Glossary Author OMVS", "glossary-author", "View Service for glossary authoring.", "https://egeria-project.org/services/omvs/glossary-author/overview", AccessServiceDescription.SUBJECT_AREA_OMAS.getAccessServiceFullName()),
    REPOSITORY_EXPLORER(801, ComponentDevelopmentStatus.DEPRECATED, "Repository Explorer", "Repository Explorer OMVS", "rex", "Explore open metadata instances.", "https://egeria-project.org/services/omvs/rex/overview", CommonServicesDescription.REPOSITORY_SERVICES.getServiceName()),
    TYPE_EXPLORER(802, ComponentDevelopmentStatus.DEPRECATED, "Type Explorer", "Type Explorer OMVS", "tex", "Explore the open metadata types in a repository or cohort.", "https://egeria-project.org/services/omvs/tex/overview", CommonServicesDescription.REPOSITORY_SERVICES.getServiceName()),
    DINO(803, ComponentDevelopmentStatus.DEPRECATED, "Dynamic Infrastructure and Operations", "Dynamic Infrastructure and Operations OMVS", "dino", "Explore and operate an open metadata ecosystem.", "https://egeria-project.org/services/omvs/dino/overview", CommonServicesDescription.SERVER_OPERATIONS.getServiceName()),
    SERVER_AUTHOR(804, ComponentDevelopmentStatus.DEPRECATED, "Server Author", "Server Author OMVS", "server-author", "Author server configuration.", "https://egeria-project.org/services/omvs/server-author/overview/", CommonServicesDescription.ADMINISTRATION_SERVICES.getServiceName()),
    GLOSSARY_BROWSER(805, ComponentDevelopmentStatus.STABLE, "Glossary Browser", "Glossary Browser OMVS", "glossary-browser", "View glossary terms and categories within a glossary.", "https://egeria-project.org/services/omvs/glossary-browser/overview/", AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceFullName()),
    GLOSSARY_MANAGER(806, ComponentDevelopmentStatus.STABLE, "Glossary Manager", "Glossary Manager OMVS", "glossary-manager", "Create glossary terms and organize them into categories as part of a controlled workflow process. It supports the editing glossary and multiple states.", "https://egeria-project.org/services/omvs/glossary-manager/overview/", AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceFullName()),
    MY_PROFILE(807, ComponentDevelopmentStatus.STABLE, "My Profile", "My Profile OMVS", "my-profile", "Manage information about the logged on user as well as their preferences.", "https://egeria-project.org/services/omvs/my-profile/overview/", AccessServiceDescription.COMMUNITY_PROFILE_OMAS.getAccessServiceFullName()),
    ASSET_CATALOG(808, ComponentDevelopmentStatus.STABLE, "Asset Catalog", "Asset Catalog OMVS", "asset-catalog", "Search and understand your assets.", "https://egeria-project.org/services/omvs/asset-catalog/overview/", AccessServiceDescription.ASSET_CONSUMER_OMAS.getAccessServiceFullName()),
    COLLECTION_MANAGER(809, ComponentDevelopmentStatus.STABLE, "Collection Manager", "Collection Manager OMVS", "collection-manager", "Build collections of asset and other metadata.", "https://egeria-project.org/services/omvs/collection-manager/overview/", AccessServiceDescription.DIGITAL_SERVICE_OMAS.getAccessServiceFullName()),
    AUTOMATED_CURATION(810, ComponentDevelopmentStatus.STABLE, "Automated Curation", "Automated Curation OMVS", "automated-curation", "Manage Egeria's automation services.", "https://egeria-project.org/services/omvs/automated-curation/overview/", AccessServiceDescription.ASSET_OWNER_OMAS.getAccessServiceFullName()),
    FEEDBACK_MANAGER(811, ComponentDevelopmentStatus.STABLE, "Feedback Manager", "Feedback Manager OMVS", "feedback-manager", "Work with note logs, comments, informal tags, ratings/reviews and likes.", "https://egeria-project.org/services/omvs/feedback-manager/overview/", AccessServiceDescription.ASSET_CONSUMER_OMAS.getAccessServiceFullName()),
    ACTION_AUTHOR(812, ComponentDevelopmentStatus.STABLE, "Action Author", "Action Author OMVS", "action-author", "Maintain definitions of governance actions such as governance action processes and governance action types.", "https://egeria-project.org/services/omvs/action-author/overview/", AccessServiceDescription.GOVERNANCE_PROGRAM_OMAS.getAccessServiceFullName()),
    PROJECT_MANAGER(813, ComponentDevelopmentStatus.STABLE, "Project Manager", "Project Manager OMVS", "project-manager", "Set up and manage projects.", "https://egeria-project.org/services/omvs/project-manager/overview/", AccessServiceDescription.PROJECT_MANAGEMENT_OMAS.getAccessServiceFullName()),
    DATA_DISCOVERY(814, ComponentDevelopmentStatus.IN_DEVELOPMENT, "Data Discovery", "Data Discovery OMVS", "data-discovery", "Define and search for new data resources.", "https://egeria-project.org/services/omvs/data-discovery/overview/", AccessServiceDescription.ASSET_CONSUMER_OMAS.getAccessServiceFullName()),
    TEMPLATE_MANAGER(815, ComponentDevelopmentStatus.STABLE, "Template Manager", "Template Manager OMVS", "template-manager", "Retrieve and refine the templates for use during cataloguing.", "https://egeria-project.org/services/omvs/template-manager/overview/", AccessServiceDescription.DIGITAL_ARCHITECTURE_OMAS.getAccessServiceFullName()),
    REFERENCE_DATA(816, ComponentDevelopmentStatus.IN_DEVELOPMENT, "Reference Data", "Reference Data OMVS", "reference-data", "Work with code tables and associated reference data.", "https://egeria-project.org/services/omvs/reference-data/overview/", AccessServiceDescription.DIGITAL_ARCHITECTURE_OMAS.getAccessServiceFullName()),
    VALID_METADATA(817, ComponentDevelopmentStatus.STABLE, "Valid Metadata", "Valid Metadata OMVS", "valid-metadata", "Maintain and query valid values for metadata.", "https://egeria-project.org/services/omvs/valid-metadata/overview/", AccessServiceDescription.DIGITAL_ARCHITECTURE_OMAS.getAccessServiceFullName()),
    CLASSIFICATION_MANAGER(818, ComponentDevelopmentStatus.STABLE, "Classification Manager", "Classification Manager OMVS", "classification-manager", "Maintain classifications and relationships used to organize open metadata elements.", "https://egeria-project.org/services/omvs/valid-metadata/overview/", AccessServiceDescription.ASSET_MANAGER_OMAS.getAccessServiceFullName()),
    DEVOPS_PIPELINE(819, ComponentDevelopmentStatus.IN_DEVELOPMENT, "DevOps Pipeline", "DevOps Pipeline OMVS", "devops-pipeline", "Maintain the metadata about the assets managed by a devops pipeline.", "https://egeria-project.org/services/omvs/devops-pipeline/overview/", AccessServiceDescription.IT_INFRASTRUCTURE_OMAS.getAccessServiceFullName()),
    SECURITY_OFFICER(820, ComponentDevelopmentStatus.IN_DEVELOPMENT, "Security Officer", "Security Officer OMVS", "security-officer", "Set up and review rules and security tags to protect data and systems.", "https://egeria-project.org/services/omvs/security-officer/overview/", AccessServiceDescription.SECURITY_MANAGER_OMAS.getAccessServiceFullName()),
    PRIVACY_OFFICER(821, ComponentDevelopmentStatus.IN_DEVELOPMENT, "Privacy Officer", "Privacy Officer OMVS", "privacy-officer", "Manage the governance of privacy.", "https://egeria-project.org/services/omvs/privacy-officer/overview/", AccessServiceDescription.GOVERNANCE_PROGRAM_OMAS.getAccessServiceFullName()),
    DATA_OFFICER(822, ComponentDevelopmentStatus.IN_DEVELOPMENT, "Data Officer", "Data Officer OMVS", "data-officer", "Manage the governance of data.", "https://egeria-project.org/services/omvs/data-officer/overview/", AccessServiceDescription.GOVERNANCE_PROGRAM_OMAS.getAccessServiceFullName()),
    PEOPLE_ORGANIZER(823, ComponentDevelopmentStatus.IN_DEVELOPMENT, "People Organizer", "People Organizer OMVS", "people-organizer", "Describe teams, roles and organizational structure.", "https://egeria-project.org/services/omvs/people-organizer/overview/", AccessServiceDescription.COMMUNITY_PROFILE_OMAS.getAccessServiceFullName()),
    RUNTIME_MANAGER(824, ComponentDevelopmentStatus.STABLE, "Runtime Manager", "Runtime Manager OMVS", "runtime-manager", "Retrieve configuration and status from platforms and servers.", "https://egeria-project.org/services/omvs/runtime-manager/overview/", AccessServiceDescription.IT_INFRASTRUCTURE_OMAS.getAccessServiceFullName()),
    GOVERNANCE_OFFICER(825, ComponentDevelopmentStatus.IN_DEVELOPMENT, "Governance Officer", "Governance Officer OMVS", "governance-officer", "Maintain governance definitions used to define any governance domain.", "https://egeria-project.org/services/omvs/governance-officer/overview/", AccessServiceDescription.GOVERNANCE_PROGRAM_OMAS.getAccessServiceFullName()),
    DATA_DESIGNER(826, ComponentDevelopmentStatus.IN_DEVELOPMENT, "Data Designer", "Data Designer OMVS", "data-designer", "Create schema definitions to describe the structure of data.", "https://egeria-project.org/services/omvs/data-designer/overview/", AccessServiceDescription.DATA_MANAGER_OMAS.getAccessServiceFullName()),
    METADATA_EXPLORER(827, ComponentDevelopmentStatus.STABLE, "Metadata Explorer", "Metadata Explorer OMVS", "metadata-explorer", "Provides generic search, query and retrieval operations for open metadata.", "https://egeria-project.org/services/omvs/metadata-explorer/overview/", AccessServiceDescription.ASSET_CONSUMER_OMAS.getAccessServiceFullName()),
    NOTIFICATION_MANAGER(828, ComponentDevelopmentStatus.IN_DEVELOPMENT, "Notification Manager", "Notification Manager OMVS", "notification-manager", "Manages the definitions of notifications.  This includes the definition of the trigger for the notification, the style of notification and the recipient.", "https://egeria-project.org/services/omvs/notification-manager/overview/", AccessServiceDescription.STEWARDSHIP_ACTION_OMAS.getAccessServiceFullName());

    private final int viewServiceCode;
    private final ComponentDevelopmentStatus viewServiceDevelopmentStatus;
    private final String viewServiceName;
    private final String viewServiceFullName;
    private final String viewServiceURLMarker;
    private final String viewServiceDescription;
    private final String viewServiceWiki;
    private final String viewServicePartnerService;

    private ViewServiceDescription(int viewServiceCode, ComponentDevelopmentStatus viewServiceDevelopmentStatus, String viewServiceName, String viewServiceFullName, String viewServiceURLMarker, String viewServiceDescription, String viewServiceWiki, String viewServicePartnerService) {
        this.viewServiceCode = viewServiceCode;
        this.viewServiceDevelopmentStatus = viewServiceDevelopmentStatus;
        this.viewServiceName = viewServiceName;
        this.viewServiceFullName = viewServiceFullName;
        this.viewServiceURLMarker = viewServiceURLMarker;
        this.viewServiceDescription = viewServiceDescription;
        this.viewServiceWiki = viewServiceWiki;
        this.viewServicePartnerService = viewServicePartnerService;
    }

    public static ViewServiceDescription getViewServiceDefinition(int viewServiceCode) {
        for (ViewServiceDescription description : ViewServiceDescription.values()) {
            if (viewServiceCode != description.getViewServiceCode()) continue;
            return description;
        }
        return null;
    }

    public int getViewServiceCode() {
        return this.viewServiceCode;
    }

    public ComponentDevelopmentStatus getViewServiceDevelopmentStatus() {
        return this.viewServiceDevelopmentStatus;
    }

    public String getViewServiceName() {
        return this.viewServiceName;
    }

    public String getViewServiceFullName() {
        return this.viewServiceFullName;
    }

    public String getViewServiceURLMarker() {
        return this.viewServiceURLMarker;
    }

    public String getViewServiceDescription() {
        return this.viewServiceDescription;
    }

    public String getViewServiceWiki() {
        return this.viewServiceWiki;
    }

    public String getViewServicePartnerService() {
        return this.viewServicePartnerService;
    }
}

