/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.configuration.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.adminservices.configuration.properties.AdminServicesConfigHeader;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RepositoryPerformanceWorkbenchConfig
extends AdminServicesConfigHeader {
    private String tutRepositoryServerName = null;
    private int instancesPerType = 50;
    private int maxSearchResults = 10;
    private int waitBetweenScenarios = 60;
    private List<String> profilesToSkip = Collections.emptyList();
    private List<String> methodsToSkip = Collections.emptyList();

    public RepositoryPerformanceWorkbenchConfig() {
    }

    public RepositoryPerformanceWorkbenchConfig(RepositoryPerformanceWorkbenchConfig template) {
        super(template);
        if (template != null) {
            this.tutRepositoryServerName = template.getTutRepositoryServerName();
            this.maxSearchResults = template.getMaxSearchResults();
            this.waitBetweenScenarios = template.getWaitBetweenScenarios();
            this.profilesToSkip = template.getProfilesToSkip();
            this.methodsToSkip = template.getMethodsToSkip();
        }
    }

    public String getTutRepositoryServerName() {
        return this.tutRepositoryServerName;
    }

    public void setTutRepositoryServerName(String tutRepositoryServerName) {
        this.tutRepositoryServerName = tutRepositoryServerName;
    }

    public int getInstancesPerType() {
        return this.instancesPerType;
    }

    public void setInstancesPerType(int instancesPerType) {
        this.instancesPerType = instancesPerType;
    }

    public int getMaxSearchResults() {
        return this.maxSearchResults;
    }

    public void setMaxSearchResults(int maxSearchResults) {
        this.maxSearchResults = maxSearchResults;
    }

    public int getWaitBetweenScenarios() {
        return this.waitBetweenScenarios;
    }

    public void setWaitBetweenScenarios(int waitBetweenScenarios) {
        this.waitBetweenScenarios = waitBetweenScenarios;
    }

    public List<String> getProfilesToSkip() {
        return this.profilesToSkip;
    }

    public void setProfilesToSkip(List<String> profilesToSkip) {
        this.profilesToSkip = profilesToSkip;
    }

    public List<String> getMethodsToSkip() {
        return this.methodsToSkip;
    }

    public void setMethodsToSkip(List<String> methodsToSkip) {
        this.methodsToSkip = methodsToSkip;
    }

    public String toString() {
        return "ConformanceSuiteConfig{tutRepositoryServerName='" + this.tutRepositoryServerName + "'instancesPerType='" + this.instancesPerType + "'maxSearchResults='" + this.maxSearchResults + "'waitBetweenScenarios='" + this.waitBetweenScenarios + "'profilesToSkip=" + String.valueOf(this.profilesToSkip) + "methodsToSkip=" + String.valueOf(this.methodsToSkip) + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        RepositoryPerformanceWorkbenchConfig that = (RepositoryPerformanceWorkbenchConfig)objectToCompare;
        return Objects.equals(this.getTutRepositoryServerName(), that.getTutRepositoryServerName()) && Objects.equals(this.getInstancesPerType(), that.getInstancesPerType()) && Objects.equals(this.getMaxSearchResults(), that.getMaxSearchResults()) && Objects.equals(this.getWaitBetweenScenarios(), that.getWaitBetweenScenarios()) && Objects.equals(this.getProfilesToSkip(), that.getProfilesToSkip()) && Objects.equals(this.getMethodsToSkip(), that.getMethodsToSkip());
    }

    public int hashCode() {
        return Objects.hash(this.getTutRepositoryServerName(), this.getInstancesPerType(), this.getMaxSearchResults(), this.getWaitBetweenScenarios(), this.getProfilesToSkip(), this.getMethodsToSkip());
    }
}

