/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.adminservices.configuration.registration.ServerTypeClassification;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ServerTypeClassificationSummary {
    private String serverTypeName;
    private String serverTypeDescription;
    private ServerTypeClassificationSummary serverSuperType;
    private String serverTypeWiki;

    public ServerTypeClassificationSummary() {
    }

    public ServerTypeClassificationSummary(ServerTypeClassificationSummary template) {
        if (template != null) {
            this.serverTypeName = template.getServerTypeName();
            this.serverTypeDescription = template.getServerTypeDescription();
            this.serverSuperType = template.getServerSuperType();
            this.serverTypeWiki = template.getServerTypeWiki();
        }
    }

    public ServerTypeClassificationSummary(ServerTypeClassification enumClassification) {
        if (enumClassification != null) {
            this.serverTypeName = enumClassification.getServerTypeName();
            this.serverTypeDescription = enumClassification.getServerTypeDescription();
            this.serverTypeWiki = enumClassification.getServerTypeWiki();
            if (enumClassification.getSuperType() != null) {
                this.serverSuperType = new ServerTypeClassificationSummary(enumClassification.getSuperType());
            }
        }
    }

    public String getServerTypeName() {
        return this.serverTypeName;
    }

    public void setServerTypeName(String serverTypeName) {
        this.serverTypeName = serverTypeName;
    }

    public String getServerTypeDescription() {
        return this.serverTypeDescription;
    }

    public void setServerTypeDescription(String serverTypeDescription) {
        this.serverTypeDescription = serverTypeDescription;
    }

    public ServerTypeClassificationSummary getServerSuperType() {
        return this.serverSuperType;
    }

    public void setServerSuperType(ServerTypeClassificationSummary serverSuperType) {
        this.serverSuperType = serverSuperType;
    }

    public String getServerTypeWiki() {
        return this.serverTypeWiki;
    }

    public void setServerTypeWiki(String serverTypeWiki) {
        this.serverTypeWiki = serverTypeWiki;
    }

    public String toString() {
        return "ServerTypeClassificationSummary{serverTypeName='" + this.serverTypeName + "', serverTypeDescription='" + this.serverTypeDescription + "', serverSuperType=" + String.valueOf(this.serverSuperType) + ", serverTypeWiki='" + this.serverTypeWiki + "'}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        ServerTypeClassificationSummary that = (ServerTypeClassificationSummary)objectToCompare;
        return Objects.equals(this.getServerTypeName(), that.getServerTypeName()) && Objects.equals(this.getServerTypeDescription(), that.getServerTypeDescription()) && Objects.equals(this.getServerSuperType(), that.getServerSuperType()) && Objects.equals(this.getServerTypeWiki(), that.getServerTypeWiki());
    }

    public int hashCode() {
        return Objects.hash(this.getServerTypeName(), this.getServerTypeDescription(), this.getServerSuperType(), this.getServerTypeWiki());
    }
}

