/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices;

import org.odpi.openmetadata.adminservices.AdminServicesRESTClient;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class ConfigurationManagementClient {
    private String serverName;
    private String serverPlatformRootURL;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private RESTExceptionHandler exceptionHandler = new RESTExceptionHandler();
    private AdminServicesRESTClient restClient;

    public ConfigurationManagementClient(String serverName, String serverPlatformRootURL) throws OMAGInvalidParameterException {
        String methodName = "Client Constructor";
        try {
            this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformRootURL, serverName, "Client Constructor");
            this.serverName = serverName;
            this.serverPlatformRootURL = serverPlatformRootURL;
            this.restClient = new AdminServicesRESTClient(serverName, serverPlatformRootURL);
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error);
        }
    }

    public ConfigurationManagementClient(String serverName, String serverPlatformRootURL, String userId, String password) throws OMAGInvalidParameterException {
        String methodName = "Client Constructor (with security)";
        try {
            this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformRootURL, serverName, "Client Constructor (with security)");
            this.serverName = serverName;
            this.serverPlatformRootURL = serverPlatformRootURL;
            this.restClient = new AdminServicesRESTClient(serverName, serverPlatformRootURL, userId, password);
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error);
        }
    }

    public void setOMAGServerConfig(String userId, OMAGServerConfig uiServerConfig) throws OMAGNotAuthorizedException, OMAGConfigurationErrorException, OMAGInvalidParameterException {
        String methodName = "deployOMAGServerConfig";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/configuration";
        try {
            VoidResponse restResult = this.restClient.callVoidPostRESTCall("deployOMAGServerConfig", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/configuration", uiServerConfig, new Object[]{userId, this.serverName});
            this.exceptionHandler.detectAndThrowInvalidParameterException("deployOMAGServerConfig", (FFDCResponseBase)restResult);
            this.exceptionHandler.detectAndThrowUserNotAuthorizedException("deployOMAGServerConfig", (FFDCResponseBase)restResult);
            this.exceptionHandler.detectAndThrowPropertyServerException("deployOMAGServerConfig", (FFDCResponseBase)restResult);
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error);
        }
        catch (UserNotAuthorizedException error) {
            throw new OMAGNotAuthorizedException(error);
        }
        catch (PropertyServerException error) {
            throw new OMAGConfigurationErrorException(error);
        }
    }
}

