/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.client;

import org.odpi.openmetadata.adminservices.ffdc.OMAGAdminErrorCode;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AdminClientRESTExceptionHandler
extends RESTExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(AdminClientRESTExceptionHandler.class);

    AdminClientRESTExceptionHandler() {
    }

    void detectAndThrowAdminExceptions(String methodName, FFDCResponseBase restResult) throws OMAGInvalidParameterException, OMAGNotAuthorizedException, OMAGConfigurationErrorException {
        String invalidParameterExceptionClassName = OMAGInvalidParameterException.class.getName();
        String userNotAuthorizedExceptionClassName = OMAGNotAuthorizedException.class.getName();
        if (restResult != null) {
            String exceptionClassName = restResult.getExceptionClassName();
            if (exceptionClassName != null) {
                log.error("FFDC Response: {}", (Object)restResult.toString());
                if (exceptionClassName.equals(invalidParameterExceptionClassName)) {
                    this.throwOMAGInvalidParameterException(methodName, restResult);
                } else if (exceptionClassName.equals(userNotAuthorizedExceptionClassName)) {
                    this.throwOMAGNotAuthorizedException(methodName, restResult);
                } else {
                    this.throwOMAGConfigurationException(methodName, restResult);
                }
            } else {
                log.debug("FFDC Response: {}", (Object)restResult.toString());
            }
        }
    }

    private void throwOMAGInvalidParameterException(String methodName, FFDCResponseBase restResult) throws OMAGInvalidParameterException {
        OMAGInvalidParameterException error = new OMAGInvalidParameterException(restResult.getRelatedHTTPCode(), ((Object)((Object)this)).getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction());
        log.error("Invalid parameter Exception", (Throwable)error);
        throw error;
    }

    private void throwOMAGNotAuthorizedException(String methodName, FFDCResponseBase restResult) throws OMAGNotAuthorizedException {
        OMAGNotAuthorizedException error = new OMAGNotAuthorizedException(restResult.getRelatedHTTPCode(), ((Object)((Object)this)).getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction());
        log.error("User Not Authorized Exception", (Throwable)error);
        throw error;
    }

    private void throwOMAGConfigurationException(String methodName, FFDCResponseBase restResult) throws OMAGConfigurationErrorException {
        OMAGConfigurationErrorException error = new OMAGConfigurationErrorException(restResult.getRelatedHTTPCode(), ((Object)((Object)this)).getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction());
        log.error("Configuration Error Exception", (Throwable)error);
        throw error;
    }

    public void logRESTCallException(String serverPlatformURLRoot, String methodName, Throwable error) throws OMAGConfigurationErrorException {
        OMAGAdminErrorCode errorCode = OMAGAdminErrorCode.CLIENT_SIDE_REST_API_ERROR;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName, serverPlatformURLRoot, error.getMessage()});
        throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
    }
}

