/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.client;

import org.odpi.openmetadata.adminservices.client.AdminServicesRESTClient;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.adminservices.rest.OMAGServerConfigResponse;
import org.odpi.openmetadata.adminservices.rest.URLRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;

public class ConfigurationManagementClient {
    private String serverName;
    private String serverPlatformRootURL;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private AdminServicesRESTClient restClient;

    public ConfigurationManagementClient(String serverName, String serverPlatformRootURL) throws OMAGInvalidParameterException {
        String methodName = "Client Constructor";
        try {
            this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformRootURL, serverName, "Client Constructor");
            this.serverName = serverName;
            this.serverPlatformRootURL = serverPlatformRootURL;
            this.restClient = new AdminServicesRESTClient(serverName, serverPlatformRootURL);
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error);
        }
    }

    public ConfigurationManagementClient(String serverName, String serverPlatformRootURL, String userId, String password) throws OMAGInvalidParameterException {
        String methodName = "Client Constructor (with security)";
        try {
            this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformRootURL, serverName, "Client Constructor (with security)");
            this.serverName = serverName;
            this.serverPlatformRootURL = serverPlatformRootURL;
            this.restClient = new AdminServicesRESTClient(serverName, serverPlatformRootURL, userId, password);
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error);
        }
    }

    public void setOMAGServerConfig(String userId, OMAGServerConfig serverConfig) throws OMAGNotAuthorizedException, OMAGConfigurationErrorException, OMAGInvalidParameterException {
        String methodName = "setOMAGServerConfig";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/configuration";
        this.restClient.callVoidPostRESTCall("setOMAGServerConfig", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/configuration", serverConfig, userId, this.serverName);
    }

    public void deployOMAGServerConfig(String userId, String serverName, String destinationPlatformURLRoot) throws OMAGNotAuthorizedException, OMAGConfigurationErrorException, OMAGInvalidParameterException {
        String methodName = "deployOMAGServerConfig";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/configuration/deploy";
        URLRequestBody requestBody = new URLRequestBody();
        requestBody.setUrlRoot(destinationPlatformURLRoot);
        this.restClient.callVoidPostRESTCall("deployOMAGServerConfig", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/configuration/deploy", requestBody, userId, serverName);
    }

    public OMAGServerConfig getOMAGServerConfig(String userId, String serverName) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "getOMAGServerConfig";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/configuration";
        OMAGServerConfigResponse restResult = this.restClient.callOMAGServerConfigGetRESTCall("getOMAGServerConfig", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/configuration", userId, serverName);
        return restResult.getOMAGServerConfig();
    }
}

