/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.client;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adminservices.client.AdminServicesRESTClient;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.ffdc.OMAGAdminErrorCode;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.adminservices.rest.ConnectionResponse;
import org.odpi.openmetadata.adminservices.rest.OMAGServerConfigResponse;
import org.odpi.openmetadata.adminservices.rest.ServerTypeClassificationResponse;
import org.odpi.openmetadata.adminservices.rest.ServerTypeClassificationSummary;
import org.odpi.openmetadata.adminservices.rest.URLRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;

public abstract class OMAGServerConfigurationClient {
    protected String adminUserId;
    protected String serverName;
    protected String serverPlatformRootURL;
    protected InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    protected AdminServicesRESTClient restClient;
    protected NullRequestBody nullRequestBody = new NullRequestBody();

    OMAGServerConfigurationClient(String adminUserId, String serverName, String serverPlatformRootURL) throws OMAGInvalidParameterException {
        String methodName = "Client Constructor";
        try {
            this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformRootURL, serverName, "Client Constructor");
            this.invalidParameterHandler.validateUserId(adminUserId, "Client Constructor");
            this.adminUserId = adminUserId;
            this.serverName = serverName;
            this.serverPlatformRootURL = serverPlatformRootURL;
            this.restClient = new AdminServicesRESTClient(serverName, serverPlatformRootURL);
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error);
        }
    }

    OMAGServerConfigurationClient(String adminUserId, String serverName, String serverPlatformRootURL, String connectionUserId, String connectionPassword) throws OMAGInvalidParameterException {
        String methodName = "Client Constructor (with security)";
        try {
            this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformRootURL, serverName, "Client Constructor (with security)");
            this.invalidParameterHandler.validateUserId(adminUserId, "Client Constructor (with security)");
            this.adminUserId = adminUserId;
            this.serverName = serverName;
            this.serverPlatformRootURL = serverPlatformRootURL;
            this.restClient = new AdminServicesRESTClient(serverName, serverPlatformRootURL, connectionUserId, connectionPassword);
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error);
        }
    }

    public ServerTypeClassificationSummary getServerClassification() throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "getServerClassification";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/server-type-classification";
        ServerTypeClassificationResponse response = this.restClient.callServerClassificationGetRESTCall("getServerClassification", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/server-type-classification", this.adminUserId, this.serverName);
        return response.getServerTypeClassification();
    }

    public void setServerURLRoot(String serverURLRoot) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "setServerURLRoot";
        String parameterName = "serverURLRoot";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/server-url-root-for-caller";
        try {
            this.invalidParameterHandler.validateName(serverURLRoot, "serverURLRoot", "setServerURLRoot");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error);
        }
        URLRequestBody requestBody = new URLRequestBody();
        requestBody.setUrlRoot(serverURLRoot);
        this.restClient.callVoidPostRESTCall("setServerURLRoot", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/server-url-root-for-caller", requestBody, this.adminUserId, this.serverName);
    }

    public void setEventBus(String connectorProvider, String topicURLRoot, Map<String, Object> configurationProperties) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "setEventBus";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/event-bus?connectorProvider={2}&topicURLRoot={3}";
        Map<String, Object> requestBody = configurationProperties;
        if (requestBody == null) {
            requestBody = new HashMap<String, Object>();
        }
        this.restClient.callVoidPostRESTCall("setEventBus", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/event-bus?connectorProvider={2}&topicURLRoot={3}", requestBody, this.adminUserId, this.serverName, connectorProvider, topicURLRoot);
    }

    public void setServerType(String serverType) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "setServerType";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/server-type?typeName={2}";
        NullRequestBody requestBody = new NullRequestBody();
        this.restClient.callVoidPostRESTCall("setServerType", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/server-type?typeName={2}", requestBody, this.adminUserId, this.serverName, serverType);
    }

    public void setOrganizationName(String organizationName) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "setOrganizationName";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/organization-name?name={2}";
        NullRequestBody requestBody = new NullRequestBody();
        this.restClient.callVoidPostRESTCall("setOrganizationName", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/organization-name?name={2}", requestBody, this.adminUserId, this.serverName, organizationName);
    }

    public void setServerUserId(String serverUserId) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "setServerUserId";
        String parameterName = "serverUserId";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/server-user-id?id={2}";
        try {
            this.invalidParameterHandler.validateName(serverUserId, "serverUserId", "setServerUserId");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error);
        }
        NullRequestBody requestBody = new NullRequestBody();
        this.restClient.callVoidPostRESTCall("setServerUserId", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/server-user-id?id={2}", requestBody, this.adminUserId, this.serverName, serverUserId);
    }

    public void setServerPassword(String serverPassword) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "setServerPassword";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/server-user-password?password={2}";
        NullRequestBody requestBody = new NullRequestBody();
        this.restClient.callVoidPostRESTCall("setServerPassword", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/server-user-password?password={2}", requestBody, this.adminUserId, this.serverName, serverPassword);
    }

    public void setMaxPageSize(int maxPageSize) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "setMaxPageSize";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/max-page-size?limit={2}";
        if (maxPageSize < 0) {
            OMAGAdminErrorCode errorCode = OMAGAdminErrorCode.BAD_MAX_PAGE_SIZE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{this.serverName, Integer.toString(maxPageSize)});
            throw new OMAGInvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "setMaxPageSize", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        this.restClient.callVoidPostRESTCall("setMaxPageSize", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/max-page-size?limit={2}", this.nullRequestBody, this.adminUserId, this.serverName, Integer.toString(maxPageSize));
    }

    public void setDefaultAuditLog() throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "setDefaultAuditLog";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/audit-log-destinations/default";
        this.restClient.callVoidPostRESTCall("setDefaultAuditLog", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/audit-log-destinations/default", this.nullRequestBody, this.adminUserId, this.serverName);
    }

    public void addConsoleAuditLogDestination(List<String> supportedSeverities) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "addConsoleAuditLogDestination";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/audit-log-destinations/console";
        this.restClient.callVoidPostRESTCall("addConsoleAuditLogDestination", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/audit-log-destinations/console", supportedSeverities, this.adminUserId, this.serverName);
    }

    public void addSLF4JAuditLogDestination(List<String> supportedSeverities) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "addSLF4JAuditLogDestination";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/audit-log-destinations/slf4j";
        this.restClient.callVoidPostRESTCall("addSLF4JAuditLogDestination", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/audit-log-destinations/slf4j", supportedSeverities, this.adminUserId, this.serverName);
    }

    public void addFileAuditLogDestination(List<String> supportedSeverities) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "addFileAuditLogDestination";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/audit-log-destinations/files";
        this.restClient.callVoidPostRESTCall("addFileAuditLogDestination", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/audit-log-destinations/files", supportedSeverities, this.adminUserId, this.serverName);
    }

    public void addEventTopicAuditLogDestination(List<String> supportedSeverities) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "addEventTopicAuditLogDestination";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/audit-log-destinations/event-topic";
        this.restClient.callVoidPostRESTCall("addEventTopicAuditLogDestination", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/audit-log-destinations/event-topic", supportedSeverities, this.adminUserId, this.serverName);
    }

    public void addAuditLogDestination(Connection connection) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "addEventTopicAuditLogDestination";
        String parameterName = "connection";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/audit-log-destinations/connection";
        try {
            this.invalidParameterHandler.validateConnection(connection, "connection", "addEventTopicAuditLogDestination");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error);
        }
        this.restClient.callVoidPostRESTCall("addEventTopicAuditLogDestination", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/audit-log-destinations/connection", connection, this.adminUserId, this.serverName);
    }

    public void clearAuditLogDestinations() throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "clearAuditLogDestinations";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/audit-log-destinations";
        this.restClient.callVoidDeleteRESTCall("clearAuditLogDestinations", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/audit-log-destinations", this.adminUserId, this.serverName);
    }

    public void setServerSecurityConnection(Connection connection) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "setConfigurationStoreConnection";
        String parameterName = "connection";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/security/connection";
        try {
            this.invalidParameterHandler.validateConnection(connection, "connection", "setConfigurationStoreConnection");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error);
        }
        this.restClient.callVoidPostRESTCall("setConfigurationStoreConnection", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/security/connection", connection, this.adminUserId, this.serverName);
    }

    public void clearServerSecurityConnection() throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "clearServerSecurityConnection";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/security/connection";
        this.restClient.callVoidDeleteRESTCall("clearServerSecurityConnection", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/security/connection", this.adminUserId, this.serverName);
    }

    public Connection getServerSecurityConnection() throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "getServerSecurityConnection";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/security/connection";
        ConnectionResponse restResult = this.restClient.callConnectionGetRESTCall("getServerSecurityConnection", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/security/connection", this.adminUserId, this.serverName);
        return restResult.getConnection();
    }

    public void setOMAGServerConfig(OMAGServerConfig serverConfig) throws OMAGNotAuthorizedException, OMAGConfigurationErrorException, OMAGInvalidParameterException {
        String methodName = "setOMAGServerConfig";
        String parameterName = "serverConfig";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/configuration";
        try {
            this.invalidParameterHandler.validateObject((Object)serverConfig, "serverConfig", "setOMAGServerConfig");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error);
        }
        this.restClient.callVoidPostRESTCall("setOMAGServerConfig", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/configuration", serverConfig, this.adminUserId, this.serverName);
    }

    public void deployOMAGServerConfig(String destinationPlatformURLRoot) throws OMAGNotAuthorizedException, OMAGConfigurationErrorException, OMAGInvalidParameterException {
        String methodName = "deployOMAGServerConfig";
        String parameterName = "destinationPlatformURLRoot";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/configuration/deploy";
        try {
            this.invalidParameterHandler.validateName(destinationPlatformURLRoot, "destinationPlatformURLRoot", "deployOMAGServerConfig");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error);
        }
        URLRequestBody requestBody = new URLRequestBody();
        requestBody.setUrlRoot(destinationPlatformURLRoot);
        this.restClient.callVoidPostRESTCall("deployOMAGServerConfig", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/configuration/deploy", requestBody, this.adminUserId, this.serverName);
    }

    public OMAGServerConfig getOMAGServerConfig() throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "getOMAGServerConfig";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/configuration";
        OMAGServerConfigResponse restResult = this.restClient.callOMAGServerConfigGetRESTCall("getOMAGServerConfig", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/configuration", this.adminUserId, this.serverName);
        return restResult.getOMAGServerConfig();
    }
}

