/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.client;

import java.util.Map;
import org.odpi.openmetadata.adminservices.client.CohortMemberConfigurationClient;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;

public class RepositoryProxyConfigurationClient
extends CohortMemberConfigurationClient {
    public RepositoryProxyConfigurationClient(String adminUserId, String serverName, String serverPlatformRootURL) throws OMAGInvalidParameterException {
        super(adminUserId, serverName, serverPlatformRootURL);
    }

    public RepositoryProxyConfigurationClient(String adminUserId, String serverName, String serverPlatformRootURL, String connectionUserId, String connectionPassword) throws OMAGInvalidParameterException {
        super(adminUserId, serverName, serverPlatformRootURL, connectionUserId, connectionPassword);
    }

    public void setRepositoryConnection(Connection connection) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "setRepositoryConnection";
        String parameterName = "connection";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/local-repository/mode/repository-proxy/connection";
        try {
            this.invalidParameterHandler.validateConnection(connection, "connection", "setRepositoryConnection");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error);
        }
        this.restClient.callVoidPostRESTCall("setRepositoryConnection", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/local-repository/mode/repository-proxy/connection", connection, this.adminUserId, this.serverName);
    }

    public void setRepositoryConnection(String connectorProvider, Map<String, Object> additionalProperties) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "setRepositoryConnection";
        String parameterName = "connectorProvider";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/local-repository/mode/repository-proxy/details?connectorProvider={2}";
        try {
            this.invalidParameterHandler.validateName(connectorProvider, "connectorProvider", "setRepositoryConnection");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error);
        }
        this.restClient.callVoidPostRESTCall("setRepositoryConnection", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/local-repository/mode/repository-proxy/details?connectorProvider={2}", additionalProperties, this.adminUserId, this.serverName, connectorProvider);
    }

    public void setEventMapperConnection(Connection connection) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "setEventMapperConnection";
        String parameterName = "connection";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/local-repository/event-mapper-connection";
        try {
            this.invalidParameterHandler.validateConnection(connection, "connection", "setEventMapperConnection");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error);
        }
        this.restClient.callVoidPostRESTCall("setEventMapperConnection", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/local-repository/event-mapper-connection", connection, this.adminUserId, this.serverName);
    }

    public void setEventMapperConnection(String connectorProvider, String eventSource, Map<String, Object> additionalProperties) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "setEventMapperConnection";
        String connectorProviderParameterName = "connectorProvider";
        String eventSourceParameterName = "eventSource";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/local-repository/event-mapper-details?connectorProvider={2}&eventSource={3}";
        try {
            this.invalidParameterHandler.validateName(connectorProvider, "connectorProvider", "setEventMapperConnection");
            this.invalidParameterHandler.validateName(eventSource, "eventSource", "setEventMapperConnection");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error);
        }
        this.restClient.callVoidPostRESTCall("setEventMapperConnection", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/local-repository/event-mapper-details?connectorProvider={2}&eventSource={3}", additionalProperties, this.adminUserId, this.serverName, connectorProvider, eventSource);
    }
}

