/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.client;

import java.util.List;
import org.odpi.openmetadata.adminservices.client.EngineHostConfigurationClient;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerClientConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.StewardshipEngineServicesConfig;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.adminservices.rest.StewardshipEngineServicesConfigResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;

public class StewardshipServerConfigurationClient
extends EngineHostConfigurationClient {
    public StewardshipServerConfigurationClient(String adminUserId, String serverName, String serverPlatformRootURL) throws OMAGInvalidParameterException {
        super(adminUserId, serverName, serverPlatformRootURL);
    }

    public StewardshipServerConfigurationClient(String adminUserId, String serverName, String serverPlatformRootURL, String connectionUserId, String connectionPassword) throws OMAGInvalidParameterException {
        super(adminUserId, serverName, serverPlatformRootURL, connectionUserId, connectionPassword);
    }

    public void setClientConfig(OMAGServerClientConfig clientConfig) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "setClientConfig";
        String configParameterName = "clientConfig";
        String urlParameterName = "clientConfig.serverPlatformURLRoot";
        String serverNameParameterName = "clientConfig.serverName";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/stewardship-engine-services/client-config";
        try {
            this.invalidParameterHandler.validateObject((Object)clientConfig, "clientConfig", "setClientConfig");
            this.invalidParameterHandler.validateName(clientConfig.getOMAGServerPlatformRootURL(), "clientConfig.serverPlatformURLRoot", "setClientConfig");
            this.invalidParameterHandler.validateName(clientConfig.getOMAGServerName(), "clientConfig.serverName", "setClientConfig");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error);
        }
        this.restClient.callVoidPostRESTCall("setClientConfig", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/stewardship-engine-services/client-config", clientConfig, this.adminUserId, this.serverName);
    }

    public void setStewardshipEngines(List<String> stewardshipEngines) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "setStewardshipEngines";
        String parameterName = "stewardshipEngines";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/stewardship-engine-services/stewardship-engines";
        try {
            this.invalidParameterHandler.validateObject(stewardshipEngines, "stewardshipEngines", "setStewardshipEngines");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error);
        }
        this.restClient.callVoidPostRESTCall("setStewardshipEngines", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/stewardship-engine-services/stewardship-engines", stewardshipEngines, this.adminUserId, this.serverName);
    }

    public void setStewardshipEngineServicesConfig(StewardshipEngineServicesConfig servicesConfig) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "setStewardshipEngineServicesConfig";
        String parameterName = "servicesConfig";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/stewardship-engine-services";
        try {
            this.invalidParameterHandler.validateObject((Object)servicesConfig, "servicesConfig", "setStewardshipEngineServicesConfig");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error);
        }
        this.restClient.callVoidPostRESTCall("setStewardshipEngineServicesConfig", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/stewardship-engine-services", servicesConfig, this.adminUserId, this.serverName);
    }

    public StewardshipEngineServicesConfig getStewardshipEngineServicesConfig() throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "getStewardshipEngineServicesConfig";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/stewardship-engine-services";
        StewardshipEngineServicesConfigResponse response = this.restClient.callStewardshipServerConfigGetRESTCall("getStewardshipEngineServicesConfig", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/stewardship-engine-services", this.adminUserId, this.serverName);
        if (response != null) {
            return response.getConfig();
        }
        return null;
    }

    public void clearStewardshipEngineServicesConfig() throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "clearStewardshipEngineServicesConfig";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/stewardship-engine-services";
        this.restClient.callVoidDeleteRESTCall("clearStewardshipEngineServicesConfig", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/stewardship-engine-services", this.adminUserId, this.serverName);
    }
}

