/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.client;

import java.util.List;
import org.odpi.openmetadata.adminservices.client.EngineHostConfigurationClient;
import org.odpi.openmetadata.adminservices.configuration.properties.DiscoveryEngineServicesConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerClientConfig;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.adminservices.rest.DiscoveryEngineServicesConfigResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;

public class DiscoveryServerConfigurationClient
extends EngineHostConfigurationClient {
    public DiscoveryServerConfigurationClient(String adminUserId, String serverName, String serverPlatformRootURL) throws OMAGInvalidParameterException {
        super(adminUserId, serverName, serverPlatformRootURL);
    }

    public DiscoveryServerConfigurationClient(String adminUserId, String serverName, String serverPlatformRootURL, String connectionUserId, String connectionPassword) throws OMAGInvalidParameterException {
        super(adminUserId, serverName, serverPlatformRootURL, connectionUserId, connectionPassword);
    }

    public void setClientConfig(OMAGServerClientConfig clientConfig) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "setClientConfig";
        String configParameterName = "clientConfig";
        String urlParameterName = "clientConfig.serverPlatformURLRoot";
        String serverNameParameterName = "clientConfig.serverName";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/discovery-engine-services/client-config";
        try {
            this.invalidParameterHandler.validateObject((Object)clientConfig, "clientConfig", "setClientConfig");
            this.invalidParameterHandler.validateName(clientConfig.getOMAGServerPlatformRootURL(), "clientConfig.serverPlatformURLRoot", "setClientConfig");
            this.invalidParameterHandler.validateName(clientConfig.getOMAGServerName(), "clientConfig.serverName", "setClientConfig");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
        this.restClient.callVoidPostRESTCall("setClientConfig", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/discovery-engine-services/client-config", clientConfig, this.adminUserId, this.serverName);
    }

    public void setDiscoveryEngines(List<String> discoveryEngines) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "setDiscoveryEngines";
        String parameterName = "discoveryEngines";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/discovery-engine-services/discovery-engines";
        try {
            this.invalidParameterHandler.validateObject(discoveryEngines, "discoveryEngines", "setDiscoveryEngines");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
        this.restClient.callVoidPostRESTCall("setDiscoveryEngines", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/discovery-engine-services/discovery-engines", discoveryEngines, this.adminUserId, this.serverName);
    }

    public void setDiscoveryEngineServicesConfig(DiscoveryEngineServicesConfig servicesConfig) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "setDiscoveryEngineServicesConfig";
        String parameterName = "servicesConfig";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/discovery-engine-services";
        try {
            this.invalidParameterHandler.validateObject((Object)servicesConfig, "servicesConfig", "setDiscoveryEngineServicesConfig");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
        this.restClient.callVoidPostRESTCall("setDiscoveryEngineServicesConfig", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/discovery-engine-services", servicesConfig, this.adminUserId, this.serverName);
    }

    public DiscoveryEngineServicesConfig getDiscoveryEngineServicesConfig() throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "getDiscoveryEngineServicesConfig";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/discovery-engine-services";
        DiscoveryEngineServicesConfigResponse response = this.restClient.callDiscoveryServerConfigGetRESTCall("getDiscoveryEngineServicesConfig", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/discovery-engine-services", this.adminUserId, this.serverName);
        if (response != null) {
            return response.getConfig();
        }
        return null;
    }

    public void clearDiscoveryEngineServicesConfig() throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "clearDiscoveryEngineServicesConfig";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/discovery-engine-services";
        this.restClient.callVoidDeleteRESTCall("clearDiscoveryEngineServicesConfig", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/discovery-engine-services", this.adminUserId, this.serverName);
    }
}

