/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.client;

import java.util.Map;
import org.odpi.openmetadata.adminservices.client.MetadataAccessPointConfigurationClient;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;

public class MetadataServerConfigurationClient
extends MetadataAccessPointConfigurationClient {
    public MetadataServerConfigurationClient(String adminUserId, String serverName, String serverPlatformRootURL) throws OMAGInvalidParameterException {
        super(adminUserId, serverName, serverPlatformRootURL);
    }

    public MetadataServerConfigurationClient(String adminUserId, String serverName, String serverPlatformRootURL, String connectionUserId, String connectionPassword) throws OMAGInvalidParameterException {
        super(adminUserId, serverName, serverPlatformRootURL, connectionUserId, connectionPassword);
    }

    public void setInMemLocalRepository() throws OMAGNotAuthorizedException, OMAGConfigurationErrorException, OMAGInvalidParameterException {
        String methodName = "setInMemLocalRepository";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/local-repository/mode/in-memory-repository";
        this.restClient.callVoidPostRESTCall("setInMemLocalRepository", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/local-repository/mode/in-memory-repository", this.nullRequestBody, this.adminUserId, this.serverName);
    }

    public void setGraphLocalRepository(Map<String, Object> storageProperties) throws OMAGNotAuthorizedException, OMAGConfigurationErrorException, OMAGInvalidParameterException {
        String methodName = "setGraphLocalRepository";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/local-repository/mode/local-graph-repository";
        this.restClient.callVoidPostRESTCall("setGraphLocalRepository", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/local-repository/mode/local-graph-repository", storageProperties, this.adminUserId, this.serverName);
    }

    public void setReadOnlyLocalRepository() throws OMAGNotAuthorizedException, OMAGConfigurationErrorException, OMAGInvalidParameterException {
        String methodName = "setReadOnlyLocalRepository";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/local-repository/mode/read-only-repository";
        this.restClient.callVoidPostRESTCall("setReadOnlyLocalRepository", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/local-repository/mode/read-only-repository", this.nullRequestBody, this.adminUserId, this.serverName);
    }
}

