/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.client;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adminservices.client.OMAGServerConfigurationClient;
import org.odpi.openmetadata.adminservices.configuration.properties.ViewServiceConfig;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.adminservices.rest.ViewServiceRequestBody;
import org.odpi.openmetadata.adminservices.rest.ViewServicesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGService;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGServicesResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;

public class ViewServerConfigurationClient
extends OMAGServerConfigurationClient {
    ViewServerConfigurationClient(String adminUserId, String serverName, String serverPlatformRootURL) throws OMAGInvalidParameterException {
        super(adminUserId, serverName, serverPlatformRootURL);
    }

    ViewServerConfigurationClient(String adminUserId, String serverName, String serverPlatformRootURL, String connectionUserId, String connectionPassword) throws OMAGInvalidParameterException {
        super(adminUserId, serverName, serverPlatformRootURL, connectionUserId, connectionPassword);
    }

    public List<RegisteredOMAGService> getConfiguredViewServices() throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "getConfiguredViewServices";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/view-services";
        RegisteredOMAGServicesResponse restResult = this.restClient.callRegisteredOMAGServicesGetRESTCall("getConfiguredViewServices", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/view-services", this.adminUserId, this.serverName);
        return restResult.getServices();
    }

    public List<ViewServiceConfig> getViewServicesConfiguration() throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "getViewServicesConfiguration";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/view-services/configuration";
        ViewServicesResponse restResult = this.restClient.callViewServicesGetRESTCall("getViewServicesConfiguration", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/view-services/configuration", this.adminUserId, this.serverName);
        return restResult.getServices();
    }

    public void configureViewService(String partnerOMASServerURLRoot, String partnerOMASServerName, String serviceURLMarker, Map<String, Object> viewServiceOptions) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "configureViewService";
        String parameterName = "serviceURLMarker";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/view-services/{2}";
        try {
            this.invalidParameterHandler.validateName(serviceURLMarker, "serviceURLMarker", "configureViewService");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
        ViewServiceRequestBody requestBody = new ViewServiceRequestBody();
        requestBody.setOMAGServerPlatformRootURL(partnerOMASServerURLRoot);
        requestBody.setOMAGServerName(partnerOMASServerName);
        requestBody.setViewServiceOptions(viewServiceOptions);
        this.restClient.callVoidPostRESTCall("configureViewService", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/view-services/{2}", requestBody, this.adminUserId, this.serverName, serviceURLMarker);
    }

    public void configureAllViewService(String partnerOMASServerURLRoot, String partnerOMASServerName, Map<String, Object> viewServiceOptions) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "configureAllViewService";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/view-services";
        ViewServiceRequestBody requestBody = new ViewServiceRequestBody();
        requestBody.setOMAGServerPlatformRootURL(partnerOMASServerURLRoot);
        requestBody.setOMAGServerName(partnerOMASServerName);
        requestBody.setViewServiceOptions(viewServiceOptions);
        this.restClient.callVoidPostRESTCall("configureAllViewService", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/view-services", requestBody, this.adminUserId, this.serverName);
    }

    public void setViewServicesConfig(List<ViewServiceConfig> viewServicesConfig) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "setViewServicesConfig";
        String configName = "viewServicesConfig";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/view-services/configuration";
        try {
            this.invalidParameterHandler.validateObject(viewServicesConfig, "viewServicesConfig", "setViewServicesConfig");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
        this.restClient.callVoidPostRESTCall("setViewServicesConfig", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/view-services/configuration", viewServicesConfig, this.adminUserId, this.serverName);
    }

    public void clearAllViewServices() throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "clearAllViewServices";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/view-services";
        this.restClient.callVoidDeleteRESTCall("clearAllViewServices", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/view-services", this.adminUserId, this.serverName);
    }
}

