/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.client;

import org.odpi.openmetadata.adapters.connectors.restclients.RESTClientConnector;
import org.odpi.openmetadata.adapters.connectors.restclients.RESTClientFactory;
import org.odpi.openmetadata.adminservices.client.AdminClientRESTExceptionHandler;
import org.odpi.openmetadata.adminservices.ffdc.OMAGAdminErrorCode;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.adminservices.rest.AccessServicesResponse;
import org.odpi.openmetadata.adminservices.rest.ConnectionResponse;
import org.odpi.openmetadata.adminservices.rest.DiscoveryEngineServicesConfigResponse;
import org.odpi.openmetadata.adminservices.rest.EngineHostServicesResponse;
import org.odpi.openmetadata.adminservices.rest.EngineServiceConfigResponse;
import org.odpi.openmetadata.adminservices.rest.IntegrationServiceConfigResponse;
import org.odpi.openmetadata.adminservices.rest.IntegrationServicesResponse;
import org.odpi.openmetadata.adminservices.rest.OMAGServerConfigResponse;
import org.odpi.openmetadata.adminservices.rest.OMAGServerConfigsResponse;
import org.odpi.openmetadata.adminservices.rest.ServerTypeClassificationResponse;
import org.odpi.openmetadata.adminservices.rest.StewardshipEngineServicesConfigResponse;
import org.odpi.openmetadata.adminservices.rest.ViewServicesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGServicesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.StringMapResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.StringResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;

class AdminServicesRESTClient {
    private String serverPlatformURLRoot;
    private AdminClientRESTExceptionHandler exceptionHandler = new AdminClientRESTExceptionHandler();
    private RESTClientConnector clientConnector;

    AdminServicesRESTClient(String serverName, String serverPlatformURLRoot) throws OMAGInvalidParameterException {
        String methodName = "RESTClient(no authentication)";
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        RESTClientFactory factory = new RESTClientFactory(serverName, serverPlatformURLRoot);
        try {
            this.clientConnector = factory.getClientConnector();
        }
        catch (Exception error) {
            throw new OMAGInvalidParameterException(OMAGAdminErrorCode.NULL_LOCAL_SERVER_NAME.getMessageDefinition(new String[]{serverName, error.getMessage()}), this.getClass().getName(), "RESTClient(no authentication)", (Throwable)error);
        }
    }

    AdminServicesRESTClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws OMAGInvalidParameterException {
        String methodName = "RESTClient(userId and password)";
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        RESTClientFactory factory = new RESTClientFactory(serverName, serverPlatformURLRoot, userId, password);
        try {
            this.clientConnector = factory.getClientConnector();
        }
        catch (Exception error) {
            throw new OMAGInvalidParameterException(OMAGAdminErrorCode.NULL_LOCAL_SERVER_NAME.getMessageDefinition(new String[]{serverName, error.getMessage()}), this.getClass().getName(), "RESTClient(userId and password)", (Throwable)error);
        }
    }

    VoidResponse callVoidPostRESTCall(String methodName, String urlTemplate, Object requestBody, Object ... params) throws OMAGInvalidParameterException, OMAGNotAuthorizedException, OMAGConfigurationErrorException {
        VoidResponse restResult = this.callPostRESTCall(methodName, VoidResponse.class, urlTemplate, requestBody, params);
        this.exceptionHandler.detectAndThrowAdminExceptions((FFDCResponseBase)restResult);
        return restResult;
    }

    VoidResponse callVoidDeleteRESTCall(String methodName, String urlTemplate, Object ... params) throws OMAGInvalidParameterException, OMAGNotAuthorizedException, OMAGConfigurationErrorException {
        VoidResponse restResult = this.callPostRESTCall(methodName, VoidResponse.class, urlTemplate, null, params);
        this.exceptionHandler.detectAndThrowAdminExceptions((FFDCResponseBase)restResult);
        return restResult;
    }

    StringResponse callStringGetRESTCall(String methodName, String urlTemplate, Object ... params) throws OMAGInvalidParameterException, OMAGNotAuthorizedException, OMAGConfigurationErrorException {
        StringResponse restResult = this.callGetRESTCall(methodName, StringResponse.class, urlTemplate, params);
        this.exceptionHandler.detectAndThrowAdminExceptions((FFDCResponseBase)restResult);
        return restResult;
    }

    GUIDResponse callGUIDGetRESTCall(String methodName, String urlTemplate, Object ... params) throws OMAGInvalidParameterException, OMAGNotAuthorizedException, OMAGConfigurationErrorException {
        GUIDResponse restResult = this.callGetRESTCall(methodName, GUIDResponse.class, urlTemplate, params);
        this.exceptionHandler.detectAndThrowAdminExceptions((FFDCResponseBase)restResult);
        return restResult;
    }

    StringMapResponse callStringMapGetRESTCall(String methodName, String urlTemplate, Object ... params) throws OMAGInvalidParameterException, OMAGNotAuthorizedException, OMAGConfigurationErrorException {
        StringMapResponse restResult = this.callGetRESTCall(methodName, StringMapResponse.class, urlTemplate, params);
        this.exceptionHandler.detectAndThrowAdminExceptions((FFDCResponseBase)restResult);
        return restResult;
    }

    OMAGServerConfigResponse callOMAGServerConfigGetRESTCall(String methodName, String urlTemplate, Object ... params) throws OMAGInvalidParameterException, OMAGNotAuthorizedException, OMAGConfigurationErrorException {
        OMAGServerConfigResponse restResult = this.callGetRESTCall(methodName, OMAGServerConfigResponse.class, urlTemplate, params);
        this.exceptionHandler.detectAndThrowAdminExceptions((FFDCResponseBase)restResult);
        return restResult;
    }

    OMAGServerConfigsResponse callGetAllServerConfigurationsRESTCall(String methodName, String urlTemplate, Object ... params) throws OMAGInvalidParameterException, OMAGNotAuthorizedException, OMAGConfigurationErrorException {
        OMAGServerConfigsResponse restResult = this.callGetRESTCall(methodName, OMAGServerConfigsResponse.class, urlTemplate, params);
        this.exceptionHandler.detectAndThrowAdminExceptions((FFDCResponseBase)restResult);
        return restResult;
    }

    ConnectionResponse callConnectionGetRESTCall(String methodName, String urlTemplate, Object ... params) throws OMAGInvalidParameterException, OMAGNotAuthorizedException, OMAGConfigurationErrorException {
        ConnectionResponse restResult = this.callGetRESTCall(methodName, ConnectionResponse.class, urlTemplate, params);
        this.exceptionHandler.detectAndThrowAdminExceptions((FFDCResponseBase)restResult);
        return restResult;
    }

    ServerTypeClassificationResponse callServerClassificationGetRESTCall(String methodName, String urlTemplate, Object ... params) throws OMAGInvalidParameterException, OMAGNotAuthorizedException, OMAGConfigurationErrorException {
        ServerTypeClassificationResponse restResult = this.callGetRESTCall(methodName, ServerTypeClassificationResponse.class, urlTemplate, params);
        this.exceptionHandler.detectAndThrowAdminExceptions((FFDCResponseBase)restResult);
        return restResult;
    }

    DiscoveryEngineServicesConfigResponse callDiscoveryServerConfigGetRESTCall(String methodName, String urlTemplate, Object ... params) throws OMAGInvalidParameterException, OMAGNotAuthorizedException, OMAGConfigurationErrorException {
        DiscoveryEngineServicesConfigResponse restResult = this.callGetRESTCall(methodName, DiscoveryEngineServicesConfigResponse.class, urlTemplate, params);
        this.exceptionHandler.detectAndThrowAdminExceptions((FFDCResponseBase)restResult);
        return restResult;
    }

    StewardshipEngineServicesConfigResponse callStewardshipServerConfigGetRESTCall(String methodName, String urlTemplate, Object ... params) throws OMAGInvalidParameterException, OMAGNotAuthorizedException, OMAGConfigurationErrorException {
        StewardshipEngineServicesConfigResponse restResult = this.callGetRESTCall(methodName, StewardshipEngineServicesConfigResponse.class, urlTemplate, params);
        this.exceptionHandler.detectAndThrowAdminExceptions((FFDCResponseBase)restResult);
        return restResult;
    }

    RegisteredOMAGServicesResponse callRegisteredOMAGServicesGetRESTCall(String methodName, String urlTemplate, Object ... params) throws OMAGInvalidParameterException, OMAGNotAuthorizedException, OMAGConfigurationErrorException {
        RegisteredOMAGServicesResponse restResult = this.callGetRESTCall(methodName, RegisteredOMAGServicesResponse.class, urlTemplate, params);
        this.exceptionHandler.detectAndThrowAdminExceptions((FFDCResponseBase)restResult);
        return restResult;
    }

    AccessServicesResponse callAccessServicesGetRESTCall(String methodName, String urlTemplate, Object ... params) throws OMAGInvalidParameterException, OMAGNotAuthorizedException, OMAGConfigurationErrorException {
        AccessServicesResponse restResult = this.callGetRESTCall(methodName, AccessServicesResponse.class, urlTemplate, params);
        this.exceptionHandler.detectAndThrowAdminExceptions((FFDCResponseBase)restResult);
        return restResult;
    }

    EngineHostServicesResponse callEngineHostServicesGetRESTCall(String methodName, String urlTemplate, Object ... params) throws OMAGInvalidParameterException, OMAGNotAuthorizedException, OMAGConfigurationErrorException {
        EngineHostServicesResponse restResult = this.callGetRESTCall(methodName, EngineHostServicesResponse.class, urlTemplate, params);
        this.exceptionHandler.detectAndThrowAdminExceptions((FFDCResponseBase)restResult);
        return restResult;
    }

    EngineServiceConfigResponse callEngineServiceConfigGetRESTCall(String methodName, String urlTemplate, Object ... params) throws OMAGInvalidParameterException, OMAGNotAuthorizedException, OMAGConfigurationErrorException {
        EngineServiceConfigResponse restResult = this.callGetRESTCall(methodName, EngineServiceConfigResponse.class, urlTemplate, params);
        this.exceptionHandler.detectAndThrowAdminExceptions((FFDCResponseBase)restResult);
        return restResult;
    }

    IntegrationServicesResponse callIntegrationServicesGetRESTCall(String methodName, String urlTemplate, Object ... params) throws OMAGInvalidParameterException, OMAGNotAuthorizedException, OMAGConfigurationErrorException {
        IntegrationServicesResponse restResult = this.callGetRESTCall(methodName, IntegrationServicesResponse.class, urlTemplate, params);
        this.exceptionHandler.detectAndThrowAdminExceptions((FFDCResponseBase)restResult);
        return restResult;
    }

    IntegrationServiceConfigResponse callIntegrationServiceConfigGetRESTCall(String methodName, String urlTemplate, Object ... params) throws OMAGInvalidParameterException, OMAGNotAuthorizedException, OMAGConfigurationErrorException {
        IntegrationServiceConfigResponse restResult = this.callGetRESTCall(methodName, IntegrationServiceConfigResponse.class, urlTemplate, params);
        this.exceptionHandler.detectAndThrowAdminExceptions((FFDCResponseBase)restResult);
        return restResult;
    }

    ViewServicesResponse callViewServicesGetRESTCall(String methodName, String urlTemplate, Object ... params) throws OMAGInvalidParameterException, OMAGNotAuthorizedException, OMAGConfigurationErrorException {
        ViewServicesResponse restResult = this.callGetRESTCall(methodName, ViewServicesResponse.class, urlTemplate, params);
        this.exceptionHandler.detectAndThrowAdminExceptions((FFDCResponseBase)restResult);
        return restResult;
    }

    protected <T> T callGetRESTCallNoParams(String methodName, Class<T> returnClass, String urlTemplate) throws OMAGConfigurationErrorException {
        try {
            return (T)this.clientConnector.callGetRESTCall(methodName, returnClass, urlTemplate, new Object[0]);
        }
        catch (Exception error) {
            this.exceptionHandler.logRESTCallException(this.serverPlatformURLRoot, methodName, error);
            return null;
        }
    }

    protected <T> T callGetRESTCall(String methodName, Class<T> returnClass, String urlTemplate, Object ... params) throws OMAGConfigurationErrorException {
        try {
            return (T)this.clientConnector.callGetRESTCall(methodName, returnClass, urlTemplate, params);
        }
        catch (Exception error) {
            this.exceptionHandler.logRESTCallException(this.serverPlatformURLRoot, methodName, error);
            return null;
        }
    }

    protected <T> T callPostRESTCallNoParams(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody) throws OMAGConfigurationErrorException {
        try {
            return (T)this.clientConnector.callPostRESTCallNoParams(methodName, returnClass, urlTemplate, requestBody);
        }
        catch (Exception error) {
            this.exceptionHandler.logRESTCallException(this.serverPlatformURLRoot, methodName, error);
            return null;
        }
    }

    protected <T> T callPostRESTCall(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody, Object ... params) throws OMAGConfigurationErrorException {
        try {
            return (T)this.clientConnector.callPostRESTCall(methodName, returnClass, urlTemplate, requestBody, params);
        }
        catch (Exception error) {
            this.exceptionHandler.logRESTCallException(this.serverPlatformURLRoot, methodName, error);
            return null;
        }
    }

    protected <T> T callDeleteRESTCallNoParams(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody) throws OMAGConfigurationErrorException {
        try {
            return (T)this.clientConnector.callDeleteRESTCallNoParams(methodName, returnClass, urlTemplate, requestBody);
        }
        catch (Exception error) {
            this.exceptionHandler.logRESTCallException(this.serverPlatformURLRoot, methodName, error);
            return null;
        }
    }

    protected <T> T callDeleteRESTCall(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody, Object ... params) throws OMAGConfigurationErrorException {
        try {
            return (T)this.clientConnector.callDeleteRESTCall(methodName, returnClass, urlTemplate, requestBody, params);
        }
        catch (Exception error) {
            this.exceptionHandler.logRESTCallException(this.serverPlatformURLRoot, methodName, error);
            return null;
        }
    }
}

