/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.client;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adminservices.client.GovernanceServerConfigurationClient;
import org.odpi.openmetadata.adminservices.configuration.properties.EngineConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.EngineHostServicesConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.EngineServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerClientConfig;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.adminservices.rest.EngineHostServicesResponse;
import org.odpi.openmetadata.adminservices.rest.EngineServiceConfigResponse;
import org.odpi.openmetadata.adminservices.rest.EngineServiceRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGService;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGServicesResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;

public class EngineHostConfigurationClient
extends GovernanceServerConfigurationClient {
    public EngineHostConfigurationClient(String adminUserId, String serverName, String serverPlatformRootURL) throws OMAGInvalidParameterException {
        super(adminUserId, serverName, serverPlatformRootURL);
    }

    public EngineHostConfigurationClient(String adminUserId, String serverName, String serverPlatformRootURL, String connectionUserId, String connectionPassword) throws OMAGInvalidParameterException {
        super(adminUserId, serverName, serverPlatformRootURL, connectionUserId, connectionPassword);
    }

    public List<RegisteredOMAGService> getRegisteredEngineServices() throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "getRegisteredEngineServices";
        String urlTemplate = "/open-metadata/platform-services/users/{0}/server-platform/registered-services/engine-services";
        RegisteredOMAGServicesResponse restResult = this.restClient.callRegisteredOMAGServicesGetRESTCall("getRegisteredEngineServices", this.serverPlatformRootURL + "/open-metadata/platform-services/users/{0}/server-platform/registered-services/engine-services", this.adminUserId);
        return restResult.getServices();
    }

    public List<RegisteredOMAGService> getConfiguredEngineServices() throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "getConfiguredEngineServices";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/engine-services";
        RegisteredOMAGServicesResponse restResult = this.restClient.callRegisteredOMAGServicesGetRESTCall("getConfiguredEngineServices", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/engine-services", this.adminUserId, this.serverName);
        return restResult.getServices();
    }

    public EngineHostServicesConfig getEngineHostServicesConfiguration() throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "getEngineHostServicesConfiguration";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/engine-host-services/configuration";
        EngineHostServicesResponse restResult = this.restClient.callEngineHostServicesGetRESTCall("getEngineHostServicesConfiguration", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/engine-host-services/configuration", this.adminUserId, this.serverName);
        return restResult.getServices();
    }

    public EngineServiceConfig getEngineServiceConfiguration(String serviceURLMarker) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "getEngineServiceConfiguration";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/engine-services/{2}/configuration";
        EngineServiceConfigResponse restResult = this.restClient.callEngineServiceConfigGetRESTCall("getEngineServiceConfiguration", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/engine-services/{2}/configuration", this.adminUserId, this.serverName, serviceURLMarker);
        return restResult.getConfig();
    }

    public void setEngineDefinitionsClientConfig(OMAGServerClientConfig clientConfig) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "setEngineDefinitionsClientConfig";
        String configParameterName = "clientConfig";
        String urlParameterName = "clientConfig.serverPlatformURLRoot";
        String serverNameParameterName = "clientConfig.serverName";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/engine-definitions/client-config";
        try {
            this.invalidParameterHandler.validateObject((Object)clientConfig, "clientConfig", "setEngineDefinitionsClientConfig");
            this.invalidParameterHandler.validateName(clientConfig.getOMAGServerPlatformRootURL(), "clientConfig.serverPlatformURLRoot", "setEngineDefinitionsClientConfig");
            this.invalidParameterHandler.validateName(clientConfig.getOMAGServerName(), "clientConfig.serverName", "setEngineDefinitionsClientConfig");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
        this.restClient.callVoidPostRESTCall("setEngineDefinitionsClientConfig", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/engine-definitions/client-config", clientConfig, this.adminUserId, this.serverName);
    }

    public void configureEngineService(String partnerOMASServerURLRoot, String partnerOMASServerName, String serviceURLMarker, Map<String, Object> engineServiceOptions, List<EngineConfig> engines) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "configureEngineService";
        String parameterName = "serviceURLMarker";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/engine-services/{2}";
        try {
            this.invalidParameterHandler.validateName(serviceURLMarker, "serviceURLMarker", "configureEngineService");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
        EngineServiceRequestBody requestBody = new EngineServiceRequestBody();
        requestBody.setOMAGServerPlatformRootURL(partnerOMASServerURLRoot);
        requestBody.setOMAGServerName(partnerOMASServerName);
        requestBody.setEngineServiceOptions(engineServiceOptions);
        requestBody.setEngines(engines);
        this.restClient.callVoidPostRESTCall("configureEngineService", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/engine-services/{2}", engineServiceOptions, this.adminUserId, this.serverName, serviceURLMarker);
    }

    public void configureEngineService(EngineServiceConfig serviceConfig) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "configureEngineService";
        String configName = "serviceConfig";
        String parameterName = "serviceURLMarker";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/engine-services/configuration";
        try {
            this.invalidParameterHandler.validateObject((Object)serviceConfig, "serviceConfig", "configureEngineService");
            this.invalidParameterHandler.validateName(serviceConfig.getEngineServiceURLMarker(), "serviceURLMarker", "configureEngineService");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
        this.restClient.callVoidPostRESTCall("configureEngineService", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/engine-services/configuration", serviceConfig, this.adminUserId, this.serverName);
    }

    public void setEngineServicesConfig(List<EngineServiceConfig> engineServicesConfig) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "setEngineHostServicesConfig";
        String configName = "engineServicesConfig";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/engine-services/configuration/all";
        try {
            this.invalidParameterHandler.validateObject(engineServicesConfig, "engineServicesConfig", "setEngineHostServicesConfig");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
        this.restClient.callVoidPostRESTCall("setEngineHostServicesConfig", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/engine-services/configuration/all", engineServicesConfig, this.adminUserId, this.serverName);
    }

    public void setEngineHostServicesConfig(EngineHostServicesConfig engineHostServicesConfig) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "setEngineHostServicesConfig";
        String configName = "engineHostServicesConfig";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/engine-host-services";
        try {
            this.invalidParameterHandler.validateObject((Object)engineHostServicesConfig, "engineHostServicesConfig", "setEngineHostServicesConfig");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
        this.restClient.callVoidPostRESTCall("setEngineHostServicesConfig", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/engine-host-services", engineHostServicesConfig, this.adminUserId, this.serverName);
    }

    public void clearEngineHostServices() throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "clearEngineHostServices";
        String urlTemplate = "open-metadata/admin-services/users/{0}/servers/{1}/engine-host-services";
        this.restClient.callVoidDeleteRESTCall("clearEngineHostServices", this.serverPlatformRootURL + "open-metadata/admin-services/users/{0}/servers/{1}/engine-host-services", this.adminUserId, this.serverName);
    }

    public void clearEngineDefinitionsClientConfig() throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "clearEngineDefinitionsClientConfig";
        String urlTemplate = "open-metadata/admin-services/users/{0}/servers/{1}/engine-definitions/client-config";
        this.restClient.callVoidDeleteRESTCall("clearEngineDefinitionsClientConfig", this.serverPlatformRootURL + "open-metadata/admin-services/users/{0}/servers/{1}/engine-definitions/client-config", this.adminUserId, this.serverName);
    }

    public void clearAllEngineServices() throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "clearAllEngineServices";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/engine-services";
        this.restClient.callVoidDeleteRESTCall("clearAllEngineServices", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/engine-services", this.adminUserId, this.serverName);
    }

    public void clearEngineService(String serviceURLMarker) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "clearEngineService";
        String parameterName = "serviceURLMarker";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/engine-services/{2}";
        try {
            this.invalidParameterHandler.validateName(serviceURLMarker, "serviceURLMarker", "clearEngineService");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
        this.restClient.callVoidDeleteRESTCall("clearEngineService", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/engine-services/{2}", this.adminUserId, this.serverName);
    }
}

