/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.client;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adminservices.client.GovernanceServerConfigurationClient;
import org.odpi.openmetadata.adminservices.configuration.properties.IntegrationConnectorConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.IntegrationServiceConfig;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.adminservices.rest.IntegrationServiceConfigResponse;
import org.odpi.openmetadata.adminservices.rest.IntegrationServiceRequestBody;
import org.odpi.openmetadata.adminservices.rest.IntegrationServicesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGService;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGServicesResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;

public class IntegrationDaemonConfigurationClient
extends GovernanceServerConfigurationClient {
    public IntegrationDaemonConfigurationClient(String adminUserId, String serverName, String serverPlatformRootURL) throws OMAGInvalidParameterException {
        super(adminUserId, serverName, serverPlatformRootURL);
    }

    public IntegrationDaemonConfigurationClient(String adminUserId, String serverName, String serverPlatformRootURL, String connectionUserId, String connectionPassword) throws OMAGInvalidParameterException {
        super(adminUserId, serverName, serverPlatformRootURL, connectionUserId, connectionPassword);
    }

    public List<RegisteredOMAGService> getRegisteredIntegrationServices() throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "getRegisteredIntegrationServices";
        String urlTemplate = "/open-metadata/platform-services/users/{0}/server-platform/registered-services/integration-services";
        RegisteredOMAGServicesResponse restResult = this.restClient.callRegisteredOMAGServicesGetRESTCall("getRegisteredIntegrationServices", this.serverPlatformRootURL + "/open-metadata/platform-services/users/{0}/server-platform/registered-services/integration-services", this.adminUserId);
        return restResult.getServices();
    }

    public List<RegisteredOMAGService> getConfiguredIntegrationServices() throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "getConfiguredIntegrationServices";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/integration-services";
        RegisteredOMAGServicesResponse restResult = this.restClient.callRegisteredOMAGServicesGetRESTCall("getConfiguredIntegrationServices", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/integration-services", this.adminUserId, this.serverName);
        return restResult.getServices();
    }

    public List<IntegrationServiceConfig> getIntegrationServicesConfiguration() throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "getIntegrationServicesConfiguration";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/integration-services/configuration";
        IntegrationServicesResponse restResult = this.restClient.callIntegrationServicesGetRESTCall("getIntegrationServicesConfiguration", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/integration-services/configuration", this.adminUserId, this.serverName);
        return restResult.getServices();
    }

    public IntegrationServiceConfig getIntegrationServiceConfiguration(String serviceURLMarker) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "getIntegrationServiceConfiguration";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/integration-services/{2}/configuration";
        IntegrationServiceConfigResponse restResult = this.restClient.callIntegrationServiceConfigGetRESTCall("getIntegrationServiceConfiguration", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/integration-services/{2}/configuration", this.adminUserId, this.serverName, serviceURLMarker);
        return restResult.getConfig();
    }

    public void configureIntegrationService(String partnerOMASServerURLRoot, String partnerOMASServerName, String serviceURLMarker, Map<String, Object> integrationServiceOptions, List<IntegrationConnectorConfig> integrationConnectorConfigs) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "configureIntegrationService";
        String parameterName = "serviceURLMarker";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/integration-services/{2}";
        try {
            this.invalidParameterHandler.validateName(serviceURLMarker, "serviceURLMarker", "configureIntegrationService");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
        IntegrationServiceRequestBody requestBody = new IntegrationServiceRequestBody();
        requestBody.setOMAGServerPlatformRootURL(partnerOMASServerURLRoot);
        requestBody.setOMAGServerName(partnerOMASServerName);
        requestBody.setIntegrationServiceOptions(integrationServiceOptions);
        requestBody.setIntegrationConnectorConfigs(integrationConnectorConfigs);
        this.restClient.callVoidPostRESTCall("configureIntegrationService", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/integration-services/{2}", integrationServiceOptions, this.adminUserId, this.serverName, serviceURLMarker);
    }

    public void disableIntegrationService(String serviceURLMarker) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "disableIntegrationService";
        String parameterName = "serviceURLMarker";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/integration-services/{2}";
        try {
            this.invalidParameterHandler.validateName(serviceURLMarker, "serviceURLMarker", "disableIntegrationService");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
        this.restClient.callVoidDeleteRESTCall("disableIntegrationService", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/integration-services/{2}", this.adminUserId, this.serverName, serviceURLMarker);
    }

    public void configureIntegrationService(IntegrationServiceConfig serviceConfig) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "configureIntegrationService";
        String configName = "serviceConfig";
        String parameterName = "serviceURLMarker";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/integration-services/configuration";
        try {
            this.invalidParameterHandler.validateObject((Object)serviceConfig, "serviceConfig", "configureIntegrationService");
            this.invalidParameterHandler.validateName(serviceConfig.getIntegrationServiceURLMarker(), "serviceURLMarker", "configureIntegrationService");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
        this.restClient.callVoidPostRESTCall("configureIntegrationService", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/integration-services/configuration", serviceConfig, this.adminUserId, this.serverName);
    }

    public void setIntegrationServicesConfig(List<IntegrationServiceConfig> integrationServicesConfig) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "setIntegrationServicesConfig";
        String configName = "integrationServicesConfig";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/integration-services/configuration/all";
        try {
            this.invalidParameterHandler.validateObject(integrationServicesConfig, "integrationServicesConfig", "setIntegrationServicesConfig");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
        this.restClient.callVoidPostRESTCall("setIntegrationServicesConfig", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/integration-services/configuration/all", integrationServicesConfig, this.adminUserId, this.serverName);
    }

    public void clearAllIntegrationServices() throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "clearAllIntegrationServices";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/integration-services";
        this.restClient.callVoidDeleteRESTCall("clearAllIntegrationServices", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/integration-services", this.adminUserId, this.serverName);
    }

    public void clearIntegrationService(String serviceURLMarker) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "clearIntegrationService";
        String parameterName = "serviceURLMarker";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/integration-services/{2}";
        try {
            this.invalidParameterHandler.validateName(serviceURLMarker, "serviceURLMarker", "clearIntegrationService");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
        this.restClient.callVoidDeleteRESTCall("clearIntegrationService", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/integration-services/{2}", this.adminUserId, this.serverName);
    }
}

