/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.client;

import java.util.Map;
import org.odpi.openmetadata.adminservices.client.MetadataAccessPointConfigurationClient;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;

public class MetadataAccessServerConfigurationClient
extends MetadataAccessPointConfigurationClient {
    public MetadataAccessServerConfigurationClient(String adminUserId, String serverName, String serverPlatformRootURL) throws OMAGInvalidParameterException {
        super(adminUserId, serverName, serverPlatformRootURL);
    }

    public MetadataAccessServerConfigurationClient(String adminUserId, String serverName, String serverPlatformRootURL, String connectionUserId, String connectionPassword) throws OMAGInvalidParameterException {
        super(adminUserId, serverName, serverPlatformRootURL, connectionUserId, connectionPassword);
    }

    public void setInMemLocalRepository() throws OMAGNotAuthorizedException, OMAGConfigurationErrorException, OMAGInvalidParameterException {
        String methodName = "setInMemLocalRepository";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/local-repository/mode/in-memory-repository";
        this.restClient.callVoidPostRESTCall("setInMemLocalRepository", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/local-repository/mode/in-memory-repository", this.nullRequestBody, this.adminUserId, this.serverName);
    }

    public void setGraphLocalRepository(Map<String, Object> storageProperties) throws OMAGNotAuthorizedException, OMAGConfigurationErrorException, OMAGInvalidParameterException {
        String methodName = "setGraphLocalRepository";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/local-repository/mode/local-graph-repository";
        this.restClient.callVoidPostRESTCall("setGraphLocalRepository", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/local-repository/mode/local-graph-repository", storageProperties, this.adminUserId, this.serverName);
    }

    public void setReadOnlyLocalRepository() throws OMAGNotAuthorizedException, OMAGConfigurationErrorException, OMAGInvalidParameterException {
        String methodName = "setReadOnlyLocalRepository";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/local-repository/mode/read-only-repository";
        this.restClient.callVoidPostRESTCall("setReadOnlyLocalRepository", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/local-repository/mode/read-only-repository", this.nullRequestBody, this.adminUserId, this.serverName);
    }

    public void setPluginRepositoryConnection(Connection connection) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "setRepositoryConnection";
        String parameterName = "connection";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/local-repository/mode/plugin-repository/connection";
        try {
            this.invalidParameterHandler.validateConnection(connection, "connection", "setRepositoryConnection");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
        this.restClient.callVoidPostRESTCall("setRepositoryConnection", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/local-repository/mode/plugin-repository/connection", connection, this.adminUserId, this.serverName);
    }

    public void setPluginRepositoryConnection(String connectorProvider, Map<String, Object> additionalProperties) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "setNativeRepositoryConnection";
        String parameterName = "connectorProvider";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/local-repository/mode/plugin-repository/details?connectorProvider={2}";
        try {
            this.invalidParameterHandler.validateName(connectorProvider, "connectorProvider", "setNativeRepositoryConnection");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
        this.restClient.callVoidPostRESTCall("setNativeRepositoryConnection", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/local-repository/mode/plugin-repository/details?connectorProvider={2}", additionalProperties, this.adminUserId, this.serverName, connectorProvider);
    }
}

