/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.client;

import java.util.Set;
import org.odpi.openmetadata.adminservices.client.AdminServicesRESTClient;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.adminservices.rest.OMAGServerConfigResponse;
import org.odpi.openmetadata.adminservices.rest.OMAGServerConfigsResponse;
import org.odpi.openmetadata.adminservices.rest.URLRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;

public class ConfigurationManagementClient {
    private String adminUserId;
    private String serverPlatformRootURL;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private AdminServicesRESTClient restClient;
    private static final String NULL_SERVER_NAME = "<*>";

    public ConfigurationManagementClient(String adminUserId, String serverPlatformRootURL) throws OMAGInvalidParameterException {
        String methodName = "Client Constructor";
        try {
            this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformRootURL, NULL_SERVER_NAME, "Client Constructor");
            this.adminUserId = adminUserId;
            this.serverPlatformRootURL = serverPlatformRootURL;
            this.restClient = new AdminServicesRESTClient(NULL_SERVER_NAME, serverPlatformRootURL);
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
    }

    public ConfigurationManagementClient(String adminUserId, String serverPlatformRootURL, String userId, String password) throws OMAGInvalidParameterException {
        String methodName = "Client Constructor (with security)";
        try {
            this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformRootURL, NULL_SERVER_NAME, "Client Constructor (with security)");
            this.adminUserId = adminUserId;
            this.serverPlatformRootURL = serverPlatformRootURL;
            this.restClient = new AdminServicesRESTClient(NULL_SERVER_NAME, serverPlatformRootURL, userId, password);
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
    }

    public Set<OMAGServerConfig> getAllServerConfigurations() throws OMAGNotAuthorizedException, OMAGConfigurationErrorException, OMAGInvalidParameterException {
        String methodName = "getAllServerConfigurations";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/configurations";
        OMAGServerConfigsResponse restResult = this.restClient.callGetAllServerConfigurationsRESTCall("getAllServerConfigurations", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/configurations", this.adminUserId);
        return restResult.getOMAGServerConfigs();
    }

    public void setOMAGServerConfig(OMAGServerConfig serverConfig) throws OMAGNotAuthorizedException, OMAGConfigurationErrorException, OMAGInvalidParameterException {
        String methodName = "setOMAGServerConfig";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/configuration";
        this.restClient.callVoidPostRESTCall("setOMAGServerConfig", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/configuration", serverConfig, this.adminUserId, serverConfig.getLocalServerName());
    }

    public void deployOMAGServerConfig(String serverName, String destinationPlatformURLRoot) throws OMAGNotAuthorizedException, OMAGConfigurationErrorException, OMAGInvalidParameterException {
        String methodName = "deployOMAGServerConfig";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/configuration/deploy";
        URLRequestBody requestBody = new URLRequestBody();
        requestBody.setUrlRoot(destinationPlatformURLRoot);
        this.restClient.callVoidPostRESTCall("deployOMAGServerConfig", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/configuration/deploy", requestBody, this.adminUserId, serverName);
    }

    public OMAGServerConfig getOMAGServerConfig(String serverName) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "getOMAGServerConfig";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/configuration";
        OMAGServerConfigResponse restResult = this.restClient.callOMAGServerConfigGetRESTCall("getOMAGServerConfig", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/configuration", this.adminUserId, serverName);
        return restResult.getOMAGServerConfig();
    }
}

