/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.client;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adminservices.client.OMAGServerConfigurationClient;
import org.odpi.openmetadata.adminservices.configuration.properties.CohortConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.CohortTopicStructure;
import org.odpi.openmetadata.adminservices.configuration.properties.LocalRepositoryConfig;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.adminservices.properties.DedicatedTopicList;
import org.odpi.openmetadata.adminservices.rest.DedicatedTopicListResponse;
import org.odpi.openmetadata.adminservices.rest.URLRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.StringResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;

public class CohortMemberConfigurationClient
extends OMAGServerConfigurationClient {
    public CohortMemberConfigurationClient(String adminUserId, String serverName, String serverPlatformRootURL) throws OMAGInvalidParameterException {
        super(adminUserId, serverName, serverPlatformRootURL);
    }

    public CohortMemberConfigurationClient(String adminUserId, String serverName, String serverPlatformRootURL, String connectionUserId, String connectionPassword) throws OMAGInvalidParameterException {
        super(adminUserId, serverName, serverPlatformRootURL, connectionUserId, connectionPassword);
    }

    public void addCohortRegistration(String cohortName, Map<String, Object> additionalProperties) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "addCohortRegistration";
        String parameterName = "cohortName";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/cohorts/{2}";
        try {
            this.invalidParameterHandler.validateName(cohortName, "cohortName", "addCohortRegistration");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
        Map<String, Object> requestBody = additionalProperties;
        if (requestBody == null) {
            requestBody = new HashMap<String, Object>();
        }
        this.restClient.callVoidPostRESTCall("addCohortRegistration", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/cohorts/{2}", requestBody, this.adminUserId, this.serverName, cohortName);
    }

    public void addCohortRegistration(String cohortName, CohortTopicStructure cohortTopicStructure, Map<String, Object> additionalProperties) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "addCohortRegistration";
        String parameterName = "cohortName";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/cohorts/{2}/topic-structure/{3}";
        try {
            this.invalidParameterHandler.validateName(cohortName, "cohortName", "addCohortRegistration");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
        Map<String, Object> requestBody = additionalProperties;
        if (requestBody == null) {
            requestBody = new HashMap<String, Object>();
        }
        this.restClient.callVoidPostRESTCall("addCohortRegistration", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/cohorts/{2}/topic-structure/{3}", requestBody, this.adminUserId, this.serverName, cohortName, cohortTopicStructure);
    }

    public String getCohortTopicName(String cohortName) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "getCohortTopicName";
        String parameterName = "cohortName";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/cohorts/{2}/topic-name";
        try {
            this.invalidParameterHandler.validateName(cohortName, "cohortName", "getCohortTopicName");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
        StringResponse response = this.restClient.callStringGetRESTCall("getCohortTopicName", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/cohorts/{2}/topic-name", this.adminUserId, this.serverName, cohortName);
        return response.getResultString();
    }

    public DedicatedTopicList getDedicatedCohortTopicNames(String cohortName) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "getDedicatedCohortTopicNames";
        String parameterName = "cohortName";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/cohorts/{2}/dedicated-topic-names";
        try {
            this.invalidParameterHandler.validateName(cohortName, "cohortName", "getDedicatedCohortTopicNames");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
        DedicatedTopicListResponse response = this.restClient.callDedicatedTopicListGetRESTCall("getDedicatedCohortTopicNames", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/cohorts/{2}/dedicated-topic-names", this.adminUserId, this.serverName, cohortName);
        return response.getDedicatedTopicList();
    }

    public void overrideCohortTopicName(String cohortName, String topicName) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "overrideCohortTopicName";
        String parameterName = "cohortName";
        String topicParameterName = "topicName";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/cohorts/{2}/topic-name-override";
        try {
            this.invalidParameterHandler.validateName(cohortName, "cohortName", "overrideCohortTopicName");
            this.invalidParameterHandler.validateName(topicName, "topicName", "overrideCohortTopicName");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
        this.restClient.callVoidPostRESTCall("overrideCohortTopicName", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/cohorts/{2}/topic-name-override", topicName, this.adminUserId, this.serverName, cohortName);
    }

    public void overrideRegistrationCohortTopicName(String cohortName, String topicName) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "overrideRegistrationCohortTopicName";
        String parameterName = "cohortName";
        String topicParameterName = "topicName";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/cohorts/{2}/topic-name-override/registration";
        try {
            this.invalidParameterHandler.validateName(cohortName, "cohortName", "overrideRegistrationCohortTopicName");
            this.invalidParameterHandler.validateName(topicName, "topicName", "overrideRegistrationCohortTopicName");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
        this.restClient.callVoidPostRESTCall("overrideRegistrationCohortTopicName", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/cohorts/{2}/topic-name-override/registration", topicName, this.adminUserId, this.serverName, cohortName);
    }

    public void overrideTypesCohortTopicName(String cohortName, String topicName) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "overrideTypesCohortTopicName";
        String parameterName = "cohortName";
        String topicParameterName = "topicName";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/cohorts/{2}/topic-name-override/types";
        try {
            this.invalidParameterHandler.validateName(cohortName, "cohortName", "overrideTypesCohortTopicName");
            this.invalidParameterHandler.validateName(topicName, "topicName", "overrideTypesCohortTopicName");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
        this.restClient.callVoidPostRESTCall("overrideTypesCohortTopicName", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/cohorts/{2}/topic-name-override/types", topicName, this.adminUserId, this.serverName, cohortName);
    }

    public void overrideInstancesCohortTopicName(String cohortName, String topicName) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "overrideInstancesCohortTopicName";
        String parameterName = "cohortName";
        String topicParameterName = "topicName";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/cohorts/{2}/topic-name-override/instances";
        try {
            this.invalidParameterHandler.validateName(cohortName, "cohortName", "overrideInstancesCohortTopicName");
            this.invalidParameterHandler.validateName(topicName, "topicName", "overrideInstancesCohortTopicName");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
        this.restClient.callVoidPostRESTCall("overrideInstancesCohortTopicName", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/cohorts/{2}/topic-name-override/instances", topicName, this.adminUserId, this.serverName, cohortName);
    }

    public void setCohortConfig(String cohortName, CohortConfig cohortConfig) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "setCohortConfig";
        String parameterName = "cohortName";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/cohorts/{2}/configuration";
        try {
            this.invalidParameterHandler.validateName(cohortName, "cohortName", "setCohortConfig");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
        this.restClient.callVoidPostRESTCall("setCohortConfig", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/cohorts/{2}/configuration", cohortConfig, this.adminUserId, this.serverName, cohortName);
    }

    public void clearCohortRegistration(String cohortName) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "clearCohortRegistration";
        String parameterName = "cohortName";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/cohorts/{2}";
        try {
            this.invalidParameterHandler.validateName(cohortName, "cohortName", "clearCohortRegistration");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
        this.restClient.callVoidDeleteRESTCall("clearCohortRegistration", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/cohorts/{2}", this.adminUserId, this.serverName, cohortName);
    }

    public void addStartUpOpenMetadataArchiveFile(String fileName) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "addStartUpOpenMetadataArchiveFile";
        String parameterName = "fileName";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/open-metadata-archives/file";
        try {
            this.invalidParameterHandler.validateName(fileName, "fileName", "addStartUpOpenMetadataArchiveFile");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
        this.restClient.callVoidPostRESTCall("addStartUpOpenMetadataArchiveFile", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/open-metadata-archives/file", fileName, this.adminUserId, this.serverName);
    }

    public void addStartUpOpenMetadataArchiveList(List<Connection> connections) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "addStartUpOpenMetadataArchiveFile";
        String parameterName = "connections";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/open-metadata-archives";
        try {
            this.invalidParameterHandler.validateObject(connections, "connections", "addStartUpOpenMetadataArchiveFile");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
        this.restClient.callVoidPostRESTCall("addStartUpOpenMetadataArchiveFile", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/open-metadata-archives", connections, this.adminUserId, this.serverName);
    }

    public void clearOpenMetadataArchives() throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "clearOpenMetadataArchives";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/open-metadata-archives";
        this.restClient.callVoidDeleteRESTCall("clearOpenMetadataArchives", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/open-metadata-archives", this.adminUserId, this.serverName);
    }

    protected void setLocalRepositoryConfig(LocalRepositoryConfig localRepositoryConfig) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "setEventMapperConnection";
        String parameterName = "localRepositoryConfig";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/local-repository/configuration";
        try {
            this.invalidParameterHandler.validateObject((Object)localRepositoryConfig, "localRepositoryConfig", "setEventMapperConnection");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
        this.restClient.callVoidPostRESTCall("setEventMapperConnection", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/local-repository/configuration", localRepositoryConfig, this.adminUserId, this.serverName);
    }

    public void clearLocalRepository() throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "clearLocalRepository";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/local-repository";
        this.restClient.callVoidDeleteRESTCall("clearLocalRepository", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/local-repository", this.adminUserId, this.serverName);
    }

    public void resetRemoteCohortURL(String serverURLRoot) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "resetRemoteCohortURL";
        String parameterName = "serverURLRoot";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/local-repository/configuration/remote-repository-connector-url";
        try {
            this.invalidParameterHandler.validateName(serverURLRoot, "serverURLRoot", "resetRemoteCohortURL");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
        URLRequestBody requestBody = new URLRequestBody();
        requestBody.setUrlRoot(serverURLRoot);
        this.restClient.callVoidPostRESTCall("resetRemoteCohortURL", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/local-repository/configuration/remote-repository-connector-url", requestBody, this.adminUserId, this.serverName);
    }

    public void setLocalMetadataCollectionName(String name) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "setLocalMetadataCollectionName";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/local-repository/metadata-collection-name/{2}";
        this.restClient.callVoidPostRESTCall("setLocalMetadataCollectionName", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/local-repository/metadata-collection-name/{2}", this.nullRequestBody, this.adminUserId, this.serverName, name);
    }

    public String getLocalMetadataCollectionId() throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "getLocalMetadataCollectionId";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/local-repository/metadata-collection-id";
        GUIDResponse restResult = this.restClient.callGUIDGetRESTCall("getLocalMetadataCollectionId", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/local-repository/metadata-collection-id", this.adminUserId, this.serverName);
        return restResult.getGUID();
    }

    public void setLocalMetadataCollectionId(String metadataCollectionId) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "setLocalMetadataCollectionId";
        String parameterName = "metadataCollectionId";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/local-repository/metadata-collection-id";
        try {
            this.invalidParameterHandler.validateGUID(metadataCollectionId, "metadataCollectionId", "setLocalMetadataCollectionId");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
        this.restClient.callVoidPostRESTCall("setLocalMetadataCollectionId", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/local-repository/metadata-collection-id", metadataCollectionId, this.adminUserId, this.serverName);
    }
}

