/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.client;

import org.odpi.openmetadata.adminservices.client.CohortMemberConfigurationClient;
import org.odpi.openmetadata.adminservices.configuration.properties.RepositoryConformanceWorkbenchConfig;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.adminservices.rest.URLRequestBody;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;

public class ConformanceTestServerConfigurationClient
extends CohortMemberConfigurationClient {
    public ConformanceTestServerConfigurationClient(String adminUserId, String serverName, String serverPlatformRootURL) throws OMAGInvalidParameterException {
        super(adminUserId, serverName, serverPlatformRootURL);
    }

    public ConformanceTestServerConfigurationClient(String adminUserId, String serverName, String serverPlatformRootURL, String connectionUserId, String connectionPassword) throws OMAGInvalidParameterException {
        super(adminUserId, serverName, serverPlatformRootURL, connectionUserId, connectionPassword);
    }

    public void enableRepositoryConformanceSuiteWorkbench(RepositoryConformanceWorkbenchConfig repositoryConformanceWorkbenchConfig) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "enableRepositoryConformanceSuiteWorkbench";
        String parameterName = "repositoryConformanceWorkbenchConfig";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/conformance-suite-workbenches/repository-workbench/repositories";
        try {
            this.invalidParameterHandler.validateObject((Object)repositoryConformanceWorkbenchConfig, "repositoryConformanceWorkbenchConfig", "enableRepositoryConformanceSuiteWorkbench");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
        this.restClient.callVoidPostRESTCall("enableRepositoryConformanceSuiteWorkbench", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/conformance-suite-workbenches/repository-workbench/repositories", repositoryConformanceWorkbenchConfig, this.adminUserId, this.serverName);
    }

    public void enablePlatformConformanceSuiteWorkbench(String platformURL) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "enablePlatformConformanceSuiteWorkbench";
        String parameterName = "platformURL";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/conformance-suite-workbenches/platform-workbench/platforms";
        try {
            this.invalidParameterHandler.validateName(platformURL, "platformURL", "enablePlatformConformanceSuiteWorkbench");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
        URLRequestBody requestBody = new URLRequestBody();
        requestBody.setUrlRoot(platformURL);
        this.restClient.callVoidPostRESTCall("enablePlatformConformanceSuiteWorkbench", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/conformance-suite-workbenches/platform-workbench/platforms", requestBody, this.adminUserId, this.serverName);
    }

    public void disableRepositoryConformanceSuiteServices() throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "disableRepositoryConformanceSuiteServices";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/conformance-suite-workbenches/repository-workbench";
        this.restClient.callVoidDeleteRESTCall("disableRepositoryConformanceSuiteServices", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/conformance-suite-workbenches/repository-workbench", this.adminUserId, this.serverName);
    }

    public void disablePlatformConformanceSuiteServices() throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "disablePlatformConformanceSuiteServices";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/conformance-suite-workbenches/platform-workbench";
        this.restClient.callVoidDeleteRESTCall("disablePlatformConformanceSuiteServices", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/conformance-suite-workbenches/platform-workbench", this.adminUserId, this.serverName);
    }

    public void disableAllConformanceSuiteWorkbenches() throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "disableAllConformanceSuiteWorkbenches";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/conformance-suite-workbenches";
        this.restClient.callVoidDeleteRESTCall("disableAllConformanceSuiteWorkbenches", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/conformance-suite-workbenches", this.adminUserId, this.serverName);
    }
}

