/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.client;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adminservices.client.CohortMemberConfigurationClient;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.EnterpriseAccessConfig;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.adminservices.rest.AccessServicesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGService;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGServicesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.StringMapResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;

public class MetadataAccessServerConfigurationClient
extends CohortMemberConfigurationClient {
    public MetadataAccessServerConfigurationClient(String adminUserId, String serverName, String serverPlatformRootURL) throws OMAGInvalidParameterException {
        super(adminUserId, serverName, serverPlatformRootURL);
    }

    public MetadataAccessServerConfigurationClient(String adminUserId, String serverName, String serverPlatformRootURL, String connectionUserId, String connectionPassword) throws OMAGInvalidParameterException {
        super(adminUserId, serverName, serverPlatformRootURL, connectionUserId, connectionPassword);
    }

    public List<RegisteredOMAGService> getRegisteredAccessServices() throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "getRegisteredAccessServices";
        String urlTemplate = "/open-metadata/platform-services/users/{0}/server-platform/registered-services/access-services";
        RegisteredOMAGServicesResponse restResult = this.restClient.callRegisteredOMAGServicesGetRESTCall("getRegisteredAccessServices", this.serverPlatformRootURL + "/open-metadata/platform-services/users/{0}/server-platform/registered-services/access-services", this.adminUserId);
        return restResult.getServices();
    }

    public List<RegisteredOMAGService> getConfiguredAccessServices() throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "getConfiguredAccessServices";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/access-services";
        RegisteredOMAGServicesResponse restResult = this.restClient.callRegisteredOMAGServicesGetRESTCall("getConfiguredAccessServices", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/access-services", this.adminUserId, this.serverName);
        return restResult.getServices();
    }

    public List<AccessServiceConfig> getAccessServicesConfiguration() throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "getAccessServicesConfiguration";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/access-services/configuration";
        AccessServicesResponse restResult = this.restClient.callAccessServicesGetRESTCall("getAccessServicesConfiguration", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/access-services/configuration", this.adminUserId, this.serverName);
        return restResult.getServices();
    }

    public void configureAccessService(String serviceURLMarker) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        this.configureAccessService(serviceURLMarker, new HashMap<String, Object>());
    }

    public void disableAccessService(String serviceURLMarker) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "disableAccessService";
        String parameterName = "serviceURLMarker";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/access-services/{2}";
        try {
            this.invalidParameterHandler.validateName(serviceURLMarker, "serviceURLMarker", "disableAccessService");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
        this.restClient.callVoidDeleteRESTCall("disableAccessService", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/access-services/{2}", this.adminUserId, this.serverName, serviceURLMarker);
    }

    public void configureAccessService(String serviceURLMarker, Map<String, Object> accessServiceOptions) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "configureAccessService";
        String parameterName = "serviceURLMarker";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/access-services/{2}";
        try {
            this.invalidParameterHandler.validateName(serviceURLMarker, "serviceURLMarker", "configureAccessService");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
        this.restClient.callVoidPostRESTCall("configureAccessService", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/access-services/{2}", accessServiceOptions, this.adminUserId, this.serverName, serviceURLMarker);
    }

    public void configureAccessServiceNoTopics(String serviceURLMarker) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        this.configureAccessServiceNoTopics(serviceURLMarker, new HashMap<String, Object>());
    }

    public void configureAccessServiceNoTopics(String serviceURLMarker, Map<String, Object> accessServiceOptions) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "configureAccessServiceNoTopics";
        String parameterName = "serviceURLMarker";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/access-services/{2}/no-topics";
        try {
            this.invalidParameterHandler.validateName(serviceURLMarker, "serviceURLMarker", "configureAccessServiceNoTopics");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
        this.restClient.callVoidPostRESTCall("configureAccessServiceNoTopics", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/access-services/{2}/no-topics", accessServiceOptions, this.adminUserId, this.serverName, serviceURLMarker);
    }

    public void configureAllAccessServices(Map<String, Object> accessServiceOptions) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "configureAllAccessServices";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/access-services";
        this.restClient.callVoidPostRESTCall("configureAllAccessServices", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/access-services", accessServiceOptions, this.adminUserId, this.serverName);
    }

    public void configureAllAccessServicesNoTopics(Map<String, Object> accessServiceOptions) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "configureAllAccessServicesNoTopics";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/access-services/no-topics";
        this.restClient.callVoidPostRESTCall("configureAllAccessServicesNoTopics", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/access-services/no-topics", accessServiceOptions, this.adminUserId, this.serverName);
    }

    public Map<String, String> getAccessServiceTopicNames(String serviceURLMarker) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "getAccessServiceTopicNames";
        String parameterName = "serviceURLMarker";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/access-services/{2}/topic-names";
        try {
            this.invalidParameterHandler.validateName(serviceURLMarker, "serviceURLMarker", "getAccessServiceTopicNames");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
        StringMapResponse response = this.restClient.callStringMapGetRESTCall("getAccessServiceTopicNames", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/access-services/{2}/topic-names", this.adminUserId, this.serverName, serviceURLMarker);
        return response.getStringMap();
    }

    public Map<String, String> getAllAccessServiceTopicNames() throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "getAllAccessServiceTopicNames";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/access-services/topic-names";
        StringMapResponse response = this.restClient.callStringMapGetRESTCall("getAllAccessServiceTopicNames", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/access-services/topic-names", this.adminUserId, this.serverName);
        return response.getStringMap();
    }

    public void overrideAccessServiceInTopic(String serviceURLMarker, String topicName) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "overrideAccessServiceInTopic";
        String parameterName = "serviceURLMarker";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/access-services/{2}/topic-names/in-topic";
        try {
            this.invalidParameterHandler.validateName(serviceURLMarker, "serviceURLMarker", "overrideAccessServiceInTopic");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
        this.restClient.callVoidPostRESTCall("overrideAccessServiceInTopic", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/access-services/{2}/topic-names/in-topic", topicName, this.adminUserId, this.serverName, serviceURLMarker);
    }

    public void overrideAccessServiceOutTopic(String serviceURLMarker, String topicName) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "overrideAccessServiceOutTopic";
        String parameterName = "serviceURLMarker";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/access-services/{2}/topic-names/out-topic";
        try {
            this.invalidParameterHandler.validateName(serviceURLMarker, "serviceURLMarker", "overrideAccessServiceOutTopic");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
        this.restClient.callVoidPostRESTCall("overrideAccessServiceOutTopic", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/access-services/{2}/topic-names/out-topic", topicName, this.adminUserId, this.serverName, serviceURLMarker);
    }

    public void clearAllAccessServices() throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "clearAllAccessServices";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/access-services";
        this.restClient.callVoidDeleteRESTCall("clearAllAccessServices", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/access-services", this.adminUserId, this.serverName);
    }

    public void setAccessServicesConfig(List<AccessServiceConfig> accessServicesConfig) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "setAccessServicesConfig";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/access-services/configuration";
        this.restClient.callVoidPostRESTCall("setAccessServicesConfig", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/access-services/configuration", accessServicesConfig, this.adminUserId, this.serverName);
    }

    public void addRemoteEnterpriseTopic(Map<String, Object> configurationProperties) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "setEnterpriseAccessConfig";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/enterprise-access/remote-topic";
        this.restClient.callVoidPostRESTCall("setEnterpriseAccessConfig", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/enterprise-access/remote-topic", configurationProperties, this.adminUserId, this.serverName);
    }

    public void setEnterpriseAccessConfig(EnterpriseAccessConfig enterpriseAccessConfig) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "setEnterpriseAccessConfig";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/enterprise-access/configuration";
        this.restClient.callVoidPostRESTCall("setEnterpriseAccessConfig", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/enterprise-access/configuration", enterpriseAccessConfig, this.adminUserId, this.serverName);
    }
}

