/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.client;

import java.util.Set;
import org.odpi.openmetadata.adminservices.client.rest.AdminServicesRESTClient;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.adminservices.rest.ConnectionResponse;
import org.odpi.openmetadata.adminservices.rest.OMAGServerConfigResponse;
import org.odpi.openmetadata.adminservices.rest.OMAGServerConfigsResponse;
import org.odpi.openmetadata.adminservices.rest.PlatformSecurityRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;

public class OMAGServerPlatformConfigurationClient {
    protected String adminUserId;
    protected String serverPlatformRootURL;
    private final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private final AdminServicesRESTClient restClient;
    private static final String NULL_SERVER_NAME = "<*>";

    public OMAGServerPlatformConfigurationClient(String adminUserId, String serverPlatformRootURL) throws OMAGInvalidParameterException {
        String methodName = "Client Constructor";
        try {
            this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformRootURL, "Client Constructor");
            this.invalidParameterHandler.validateUserId(adminUserId, "Client Constructor");
            this.adminUserId = adminUserId;
            this.serverPlatformRootURL = serverPlatformRootURL;
            this.restClient = new AdminServicesRESTClient(NULL_SERVER_NAME, serverPlatformRootURL);
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
    }

    public OMAGServerPlatformConfigurationClient(String adminUserId, String serverPlatformRootURL, String connectionUserId, String connectionPassword) throws OMAGInvalidParameterException {
        String methodName = "Client Constructor (with security)";
        try {
            this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformRootURL, "Client Constructor (with security)");
            this.invalidParameterHandler.validateUserId(adminUserId, "Client Constructor (with security)");
            this.adminUserId = adminUserId;
            this.serverPlatformRootURL = serverPlatformRootURL;
            this.restClient = new AdminServicesRESTClient(NULL_SERVER_NAME, serverPlatformRootURL, connectionUserId, connectionPassword);
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
    }

    public void setDefaultOMAGServerConfig(OMAGServerConfig defaultServerConfig) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "setDefaultOMAGServerConfig";
        String parameterName = "defaultServerConfig";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/stores/default-configuration-document";
        try {
            this.invalidParameterHandler.validateObject((Object)defaultServerConfig, "defaultServerConfig", "setDefaultOMAGServerConfig");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
        this.restClient.callVoidPostRESTCall("setDefaultOMAGServerConfig", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/stores/default-configuration-document", defaultServerConfig, this.adminUserId);
    }

    public OMAGServerConfig getDefaultOMAGServerConfig() throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "getDefaultOMAGServerConfig";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/stores/default-configuration-document";
        OMAGServerConfigResponse restResult = this.restClient.callOMAGServerConfigGetRESTCall("getDefaultOMAGServerConfig", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/stores/default-configuration-document", this.adminUserId);
        return restResult.getOMAGServerConfig();
    }

    public void clearDefaultServerConfig() throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "clearDefaultServerConfig";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/stores/default-configuration-document";
        this.restClient.callVoidDeleteRESTCall("clearDefaultServerConfig", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/stores/default-configuration-document", this.adminUserId);
    }

    public void setConfigurationStoreConnection(Connection connection) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "setConfigurationStoreConnection";
        String parameterName = "connection";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/stores/connection";
        try {
            this.invalidParameterHandler.validateConnection(connection, "connection", "setConfigurationStoreConnection");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
        this.restClient.callVoidPostRESTCall("setConfigurationStoreConnection", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/stores/connection", connection, this.adminUserId);
    }

    public void clearConfigurationStoreConnection() throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "clearConfigurationStoreConnection";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/stores/connection";
        this.restClient.callVoidDeleteRESTCall("clearConfigurationStoreConnection", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/stores/connection", this.adminUserId);
    }

    public Connection getConfigurationStoreConnection() throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "getConfigurationStoreConnection";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/stores/connection";
        ConnectionResponse restResult = this.restClient.callConnectionGetRESTCall("getConfigurationStoreConnection", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/stores/connection", this.adminUserId);
        return restResult.getConnection();
    }

    @Deprecated
    public void setPlatformSecurityConnection(Connection connection) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "setPlatformSecurityConnection";
        String parameterName = "connection";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/platform/security/connection";
        try {
            this.invalidParameterHandler.validateConnection(connection, "connection", "setPlatformSecurityConnection");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OCFCheckedExceptionBase)error);
        }
        PlatformSecurityRequestBody requestBody = new PlatformSecurityRequestBody();
        requestBody.setPlatformSecurityConnection(connection);
        this.restClient.callVoidPostRESTCall("setPlatformSecurityConnection", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/platform/security/connection", requestBody, this.adminUserId);
    }

    @Deprecated
    public void clearPlatformSecurityConnection() throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "clearPlatformSecurityConnection";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/platform/security/connection";
        this.restClient.callVoidDeleteRESTCall("clearPlatformSecurityConnection", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/platform/security/connection", this.adminUserId);
    }

    @Deprecated
    public Connection getPlatformSecurityConnection() throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "getPlatformSecurityConnection";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/platform/security/connection";
        ConnectionResponse restResult = this.restClient.callConnectionGetRESTCall("getPlatformSecurityConnection", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/platform/security/connection", this.adminUserId);
        return restResult.getConnection();
    }

    public Set<OMAGServerConfig> getAllServerConfigurations() throws OMAGNotAuthorizedException, OMAGConfigurationErrorException, OMAGInvalidParameterException {
        String methodName = "getPlatformServerConfigs";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/configurations";
        OMAGServerConfigsResponse restResult = this.restClient.callGetAllServerConfigurationsRESTCall("getPlatformServerConfigs", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/configurations", this.adminUserId);
        return restResult.getOMAGServerConfigs();
    }
}

