/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.client.rest;

import org.odpi.openmetadata.adapters.connectors.restclients.RESTClientConnector;
import org.odpi.openmetadata.adapters.connectors.restclients.factory.RESTClientFactory;
import org.odpi.openmetadata.adminservices.client.rest.AdminClientRESTExceptionHandler;
import org.odpi.openmetadata.adminservices.ffdc.OMAGAdminErrorCode;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.adminservices.rest.AccessServicesResponse;
import org.odpi.openmetadata.adminservices.rest.BasicServerPropertiesResponse;
import org.odpi.openmetadata.adminservices.rest.ConnectionResponse;
import org.odpi.openmetadata.adminservices.rest.DedicatedTopicListResponse;
import org.odpi.openmetadata.adminservices.rest.EngineHostServicesResponse;
import org.odpi.openmetadata.adminservices.rest.EngineServiceConfigResponse;
import org.odpi.openmetadata.adminservices.rest.IntegrationGroupsResponse;
import org.odpi.openmetadata.adminservices.rest.IntegrationServiceConfigResponse;
import org.odpi.openmetadata.adminservices.rest.IntegrationServicesResponse;
import org.odpi.openmetadata.adminservices.rest.OMAGServerConfigResponse;
import org.odpi.openmetadata.adminservices.rest.OMAGServerConfigsResponse;
import org.odpi.openmetadata.adminservices.rest.OMAGServerStatusResponse;
import org.odpi.openmetadata.adminservices.rest.ServerTypeClassificationResponse;
import org.odpi.openmetadata.adminservices.rest.SuccessMessageResponse;
import org.odpi.openmetadata.adminservices.rest.ViewServicesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGServicesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.StringMapResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.StringResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;

public class AdminServicesRESTClient {
    private final String serverPlatformURLRoot;
    private final AdminClientRESTExceptionHandler exceptionHandler = new AdminClientRESTExceptionHandler();
    private final RESTClientConnector clientConnector;

    public AdminServicesRESTClient(String serverName, String serverPlatformURLRoot) throws OMAGInvalidParameterException {
        String methodName = "RESTClient(no authentication)";
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        RESTClientFactory factory = new RESTClientFactory(serverName, serverPlatformURLRoot);
        try {
            this.clientConnector = factory.getClientConnector();
        }
        catch (Exception error) {
            throw new OMAGInvalidParameterException(OMAGAdminErrorCode.NULL_LOCAL_SERVER_NAME.getMessageDefinition(new String[]{serverName, error.getMessage()}), this.getClass().getName(), "RESTClient(no authentication)", (Throwable)error);
        }
    }

    public AdminServicesRESTClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws OMAGInvalidParameterException {
        String methodName = "RESTClient(userId and password)";
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        RESTClientFactory factory = new RESTClientFactory(serverName, serverPlatformURLRoot, userId, password, null, null);
        try {
            this.clientConnector = factory.getClientConnector();
        }
        catch (Exception error) {
            throw new OMAGInvalidParameterException(OMAGAdminErrorCode.NULL_LOCAL_SERVER_NAME.getMessageDefinition(new String[]{serverName, error.getMessage()}), this.getClass().getName(), "RESTClient(userId and password)", (Throwable)error);
        }
    }

    public VoidResponse callVoidPostRESTCall(String methodName, String urlTemplate, Object requestBody, Object ... params) throws OMAGInvalidParameterException, OMAGNotAuthorizedException, OMAGConfigurationErrorException {
        VoidResponse restResult = this.callPostRESTCall(methodName, VoidResponse.class, urlTemplate, requestBody, params);
        this.exceptionHandler.detectAndThrowAdminExceptions((FFDCResponseBase)restResult);
        return restResult;
    }

    public VoidResponse callVoidDeleteRESTCall(String methodName, String urlTemplate, Object ... params) throws OMAGInvalidParameterException, OMAGNotAuthorizedException, OMAGConfigurationErrorException {
        VoidResponse restResult = this.callDeleteRESTCall(methodName, VoidResponse.class, urlTemplate, null, params);
        this.exceptionHandler.detectAndThrowAdminExceptions((FFDCResponseBase)restResult);
        return restResult;
    }

    public SuccessMessageResponse callSuccessMessagePostRESTCall(String methodName, String urlTemplate, Object requestBody, Object ... params) throws OMAGInvalidParameterException, OMAGNotAuthorizedException, OMAGConfigurationErrorException {
        SuccessMessageResponse restResult = this.callPostRESTCall(methodName, SuccessMessageResponse.class, urlTemplate, requestBody, params);
        this.exceptionHandler.detectAndThrowAdminExceptions((FFDCResponseBase)restResult);
        return restResult;
    }

    public StringResponse callStringGetRESTCall(String methodName, String urlTemplate, Object ... params) throws OMAGInvalidParameterException, OMAGNotAuthorizedException, OMAGConfigurationErrorException {
        StringResponse restResult = this.callGetRESTCall(methodName, StringResponse.class, urlTemplate, params);
        this.exceptionHandler.detectAndThrowAdminExceptions((FFDCResponseBase)restResult);
        return restResult;
    }

    public BasicServerPropertiesResponse callBasicServerPropertiesGetRESTCall(String methodName, String urlTemplate, Object ... params) throws OMAGInvalidParameterException, OMAGNotAuthorizedException, OMAGConfigurationErrorException {
        BasicServerPropertiesResponse restResult = this.callGetRESTCall(methodName, BasicServerPropertiesResponse.class, urlTemplate, params);
        this.exceptionHandler.detectAndThrowAdminExceptions((FFDCResponseBase)restResult);
        return restResult;
    }

    public DedicatedTopicListResponse callDedicatedTopicListGetRESTCall(String methodName, String urlTemplate, Object ... params) throws OMAGInvalidParameterException, OMAGNotAuthorizedException, OMAGConfigurationErrorException {
        DedicatedTopicListResponse restResult = this.callGetRESTCall(methodName, DedicatedTopicListResponse.class, urlTemplate, params);
        this.exceptionHandler.detectAndThrowAdminExceptions((FFDCResponseBase)restResult);
        return restResult;
    }

    public GUIDResponse callGUIDGetRESTCall(String methodName, String urlTemplate, Object ... params) throws OMAGInvalidParameterException, OMAGNotAuthorizedException, OMAGConfigurationErrorException {
        GUIDResponse restResult = this.callGetRESTCall(methodName, GUIDResponse.class, urlTemplate, params);
        this.exceptionHandler.detectAndThrowAdminExceptions((FFDCResponseBase)restResult);
        return restResult;
    }

    public StringMapResponse callStringMapGetRESTCall(String methodName, String urlTemplate, Object ... params) throws OMAGInvalidParameterException, OMAGNotAuthorizedException, OMAGConfigurationErrorException {
        StringMapResponse restResult = this.callGetRESTCall(methodName, StringMapResponse.class, urlTemplate, params);
        this.exceptionHandler.detectAndThrowAdminExceptions((FFDCResponseBase)restResult);
        return restResult;
    }

    public OMAGServerConfigResponse callOMAGServerConfigGetRESTCall(String methodName, String urlTemplate, Object ... params) throws OMAGInvalidParameterException, OMAGNotAuthorizedException, OMAGConfigurationErrorException {
        OMAGServerConfigResponse restResult = this.callGetRESTCall(methodName, OMAGServerConfigResponse.class, urlTemplate, params);
        this.exceptionHandler.detectAndThrowAdminExceptions((FFDCResponseBase)restResult);
        return restResult;
    }

    public OMAGServerConfigsResponse callGetAllServerConfigurationsRESTCall(String methodName, String urlTemplate, Object ... params) throws OMAGInvalidParameterException, OMAGNotAuthorizedException, OMAGConfigurationErrorException {
        OMAGServerConfigsResponse restResult = this.callGetRESTCall(methodName, OMAGServerConfigsResponse.class, urlTemplate, params);
        this.exceptionHandler.detectAndThrowAdminExceptions((FFDCResponseBase)restResult);
        return restResult;
    }

    @Deprecated
    public OMAGServerStatusResponse callOMAGServerStatusGetRESTCall(String methodName, String urlTemplate, Object ... params) throws OMAGInvalidParameterException, OMAGNotAuthorizedException, OMAGConfigurationErrorException {
        OMAGServerStatusResponse restResult = this.callGetRESTCall(methodName, OMAGServerStatusResponse.class, urlTemplate, params);
        this.exceptionHandler.detectAndThrowAdminExceptions((FFDCResponseBase)restResult);
        return restResult;
    }

    public ConnectionResponse callConnectionGetRESTCall(String methodName, String urlTemplate, Object ... params) throws OMAGInvalidParameterException, OMAGNotAuthorizedException, OMAGConfigurationErrorException {
        ConnectionResponse restResult = this.callGetRESTCall(methodName, ConnectionResponse.class, urlTemplate, params);
        this.exceptionHandler.detectAndThrowAdminExceptions((FFDCResponseBase)restResult);
        return restResult;
    }

    public ServerTypeClassificationResponse callServerClassificationGetRESTCall(String methodName, String urlTemplate, Object ... params) throws OMAGInvalidParameterException, OMAGNotAuthorizedException, OMAGConfigurationErrorException {
        ServerTypeClassificationResponse restResult = this.callGetRESTCall(methodName, ServerTypeClassificationResponse.class, urlTemplate, params);
        this.exceptionHandler.detectAndThrowAdminExceptions((FFDCResponseBase)restResult);
        return restResult;
    }

    public RegisteredOMAGServicesResponse callRegisteredOMAGServicesGetRESTCall(String methodName, String urlTemplate, Object ... params) throws OMAGInvalidParameterException, OMAGNotAuthorizedException, OMAGConfigurationErrorException {
        RegisteredOMAGServicesResponse restResult = this.callGetRESTCall(methodName, RegisteredOMAGServicesResponse.class, urlTemplate, params);
        this.exceptionHandler.detectAndThrowAdminExceptions((FFDCResponseBase)restResult);
        return restResult;
    }

    public AccessServicesResponse callAccessServicesGetRESTCall(String methodName, String urlTemplate, Object ... params) throws OMAGInvalidParameterException, OMAGNotAuthorizedException, OMAGConfigurationErrorException {
        AccessServicesResponse restResult = this.callGetRESTCall(methodName, AccessServicesResponse.class, urlTemplate, params);
        this.exceptionHandler.detectAndThrowAdminExceptions((FFDCResponseBase)restResult);
        return restResult;
    }

    public EngineHostServicesResponse callEngineHostServicesGetRESTCall(String methodName, String urlTemplate, Object ... params) throws OMAGInvalidParameterException, OMAGNotAuthorizedException, OMAGConfigurationErrorException {
        EngineHostServicesResponse restResult = this.callGetRESTCall(methodName, EngineHostServicesResponse.class, urlTemplate, params);
        this.exceptionHandler.detectAndThrowAdminExceptions((FFDCResponseBase)restResult);
        return restResult;
    }

    public EngineServiceConfigResponse callEngineServiceConfigGetRESTCall(String methodName, String urlTemplate, Object ... params) throws OMAGInvalidParameterException, OMAGNotAuthorizedException, OMAGConfigurationErrorException {
        EngineServiceConfigResponse restResult = this.callGetRESTCall(methodName, EngineServiceConfigResponse.class, urlTemplate, params);
        this.exceptionHandler.detectAndThrowAdminExceptions((FFDCResponseBase)restResult);
        return restResult;
    }

    public IntegrationServicesResponse callIntegrationServicesGetRESTCall(String methodName, String urlTemplate, Object ... params) throws OMAGInvalidParameterException, OMAGNotAuthorizedException, OMAGConfigurationErrorException {
        IntegrationServicesResponse restResult = this.callGetRESTCall(methodName, IntegrationServicesResponse.class, urlTemplate, params);
        this.exceptionHandler.detectAndThrowAdminExceptions((FFDCResponseBase)restResult);
        return restResult;
    }

    public IntegrationServiceConfigResponse callIntegrationServiceConfigGetRESTCall(String methodName, String urlTemplate, Object ... params) throws OMAGInvalidParameterException, OMAGNotAuthorizedException, OMAGConfigurationErrorException {
        IntegrationServiceConfigResponse restResult = this.callGetRESTCall(methodName, IntegrationServiceConfigResponse.class, urlTemplate, params);
        this.exceptionHandler.detectAndThrowAdminExceptions((FFDCResponseBase)restResult);
        return restResult;
    }

    public IntegrationGroupsResponse callIntegrationGroupsGetRESTCall(String methodName, String urlTemplate, Object ... params) throws OMAGInvalidParameterException, OMAGNotAuthorizedException, OMAGConfigurationErrorException {
        IntegrationGroupsResponse restResult = this.callGetRESTCall(methodName, IntegrationGroupsResponse.class, urlTemplate, params);
        this.exceptionHandler.detectAndThrowAdminExceptions((FFDCResponseBase)restResult);
        return restResult;
    }

    public ViewServicesResponse callViewServicesGetRESTCall(String methodName, String urlTemplate, Object ... params) throws OMAGInvalidParameterException, OMAGNotAuthorizedException, OMAGConfigurationErrorException {
        ViewServicesResponse restResult = this.callGetRESTCall(methodName, ViewServicesResponse.class, urlTemplate, params);
        this.exceptionHandler.detectAndThrowAdminExceptions((FFDCResponseBase)restResult);
        return restResult;
    }

    protected <T> T callGetRESTCallNoParams(String methodName, Class<T> returnClass, String urlTemplate) throws OMAGConfigurationErrorException {
        try {
            return (T)this.clientConnector.callGetRESTCall(methodName, returnClass, urlTemplate, new Object[0]);
        }
        catch (Exception error) {
            this.exceptionHandler.logRESTCallException(this.serverPlatformURLRoot, methodName, error);
            return null;
        }
    }

    protected <T> T callGetRESTCall(String methodName, Class<T> returnClass, String urlTemplate, Object ... params) throws OMAGConfigurationErrorException {
        try {
            return (T)this.clientConnector.callGetRESTCall(methodName, returnClass, urlTemplate, params);
        }
        catch (Exception error) {
            this.exceptionHandler.logRESTCallException(this.serverPlatformURLRoot, methodName, error);
            return null;
        }
    }

    protected <T> T callPostRESTCallNoParams(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody) throws OMAGConfigurationErrorException {
        try {
            return (T)this.clientConnector.callPostRESTCallNoParams(methodName, returnClass, urlTemplate, requestBody);
        }
        catch (Exception error) {
            this.exceptionHandler.logRESTCallException(this.serverPlatformURLRoot, methodName, error);
            return null;
        }
    }

    protected <T> T callPostRESTCall(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody, Object ... params) throws OMAGConfigurationErrorException {
        try {
            return (T)this.clientConnector.callPostRESTCall(methodName, returnClass, urlTemplate, requestBody, params);
        }
        catch (Exception error) {
            this.exceptionHandler.logRESTCallException(this.serverPlatformURLRoot, methodName, error);
            return null;
        }
    }

    protected <T> T callDeleteRESTCallNoParams(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody) throws OMAGConfigurationErrorException {
        try {
            return (T)this.clientConnector.callDeleteRESTCallNoParams(methodName, returnClass, urlTemplate, requestBody);
        }
        catch (Exception error) {
            this.exceptionHandler.logRESTCallException(this.serverPlatformURLRoot, methodName, error);
            return null;
        }
    }

    protected <T> T callDeleteRESTCall(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody, Object ... params) throws OMAGConfigurationErrorException {
        try {
            return (T)this.clientConnector.callDeleteRESTCall(methodName, returnClass, urlTemplate, requestBody, params);
        }
        catch (Exception error) {
            this.exceptionHandler.logRESTCallException(this.serverPlatformURLRoot, methodName, error);
            return null;
        }
    }
}

