/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adminservices.client;

import org.odpi.openmetadata.adminservices.client.rest.AdminServicesRESTClient;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.adminservices.properties.ServerServicesStatus;
import org.odpi.openmetadata.adminservices.rest.OMAGServerConfigResponse;
import org.odpi.openmetadata.adminservices.rest.OMAGServerStatusResponse;
import org.odpi.openmetadata.adminservices.rest.SuccessMessageResponse;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.OMFCheckedExceptionBase;

@Deprecated
public class OMAGServerOperationsClient {
    protected String adminUserId;
    protected String serverName;
    protected String serverPlatformRootURL;
    protected InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    protected AdminServicesRESTClient restClient;
    protected NullRequestBody nullRequestBody = new NullRequestBody();

    public OMAGServerOperationsClient(String adminUserId, String serverName, String serverPlatformRootURL) throws OMAGInvalidParameterException {
        String methodName = "Client Constructor";
        try {
            this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformRootURL, serverName, "Client Constructor");
            this.invalidParameterHandler.validateUserId(adminUserId, "Client Constructor");
            this.adminUserId = adminUserId;
            this.serverName = serverName;
            this.serverPlatformRootURL = serverPlatformRootURL;
            this.restClient = new AdminServicesRESTClient(serverName, serverPlatformRootURL);
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OMFCheckedExceptionBase)error);
        }
    }

    public OMAGServerOperationsClient(String adminUserId, String serverName, String serverPlatformRootURL, String connectionUserId, String connectionPassword) throws OMAGInvalidParameterException {
        String methodName = "Client Constructor (with security)";
        try {
            this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformRootURL, serverName, "Client Constructor (with security)");
            this.invalidParameterHandler.validateUserId(adminUserId, "Client Constructor (with security)");
            this.adminUserId = adminUserId;
            this.serverName = serverName;
            this.serverPlatformRootURL = serverPlatformRootURL;
            this.restClient = new AdminServicesRESTClient(serverName, serverPlatformRootURL, connectionUserId, connectionPassword);
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OMFCheckedExceptionBase)error);
        }
    }

    public String activateWithStoredConfig() throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "activateWithStoredConfig";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/instance";
        SuccessMessageResponse restResult = this.restClient.callSuccessMessagePostRESTCall("activateWithStoredConfig", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/instance", null, this.adminUserId, this.serverName);
        return restResult.getSuccessMessage();
    }

    public String activateWithSuppliedConfig(OMAGServerConfig configuration) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "activateWithSuppliedConfig";
        String parameterName = "configuration";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/instance/configuration";
        try {
            this.invalidParameterHandler.validateObject((Object)configuration, "configuration", "activateWithSuppliedConfig");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OMFCheckedExceptionBase)error);
        }
        SuccessMessageResponse restResult = this.restClient.callSuccessMessagePostRESTCall("activateWithSuppliedConfig", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/instance/configuration", configuration, this.adminUserId, this.serverName);
        return restResult.getSuccessMessage();
    }

    public void deactivateTemporarily() throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "deactivateTemporarily";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/instance";
        this.restClient.callVoidDeleteRESTCall("deactivateTemporarily", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/instance", this.adminUserId, this.serverName);
    }

    public void deactivatePermanently() throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "deactivatePermanently";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}";
        this.restClient.callVoidDeleteRESTCall("deactivatePermanently", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}", this.adminUserId, this.serverName);
    }

    public OMAGServerConfig getActiveConfiguration() throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "getActiveConfiguration";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/instance/configuration";
        OMAGServerConfigResponse restResult = this.restClient.callOMAGServerConfigGetRESTCall("getActiveConfiguration", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/instance/configuration", this.adminUserId, this.serverName);
        return restResult.getOMAGServerConfig();
    }

    public ServerServicesStatus getServerStatus() throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "getServerStatus";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/instance/status";
        OMAGServerStatusResponse restResult = this.restClient.callOMAGServerStatusGetRESTCall("getServerStatus", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/instance/status", this.adminUserId, this.serverName);
        return restResult.getServerStatus();
    }

    public void addOpenMetadataArchiveFile(String fileName) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "addOpenMetadataArchiveFile";
        String parameterName = "fileName";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/instance/open-metadata-archives/file";
        try {
            this.invalidParameterHandler.validateName(fileName, "fileName", "addOpenMetadataArchiveFile");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OMFCheckedExceptionBase)error);
        }
        this.restClient.callVoidPostRESTCall("addOpenMetadataArchiveFile", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/instance/open-metadata-archives/file", fileName, this.adminUserId, this.serverName);
    }

    public void addOpenMetadataArchive(Connection connection) throws OMAGNotAuthorizedException, OMAGInvalidParameterException, OMAGConfigurationErrorException {
        String methodName = "addOpenMetadataArchiveFile";
        String parameterName = "connection";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/instance/open-metadata-archives/connection";
        try {
            this.invalidParameterHandler.validateConnection(connection, "connection", "addOpenMetadataArchiveFile");
        }
        catch (InvalidParameterException error) {
            throw new OMAGInvalidParameterException(error.getReportedErrorMessage(), (OMFCheckedExceptionBase)error);
        }
        this.restClient.callVoidPostRESTCall("addOpenMetadataArchiveFile", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/instance/open-metadata-archives/connection", connection, this.adminUserId, this.serverName);
    }
}

